      subroutine ets5noe(coor,fomega,fgamma,pressi,norefs,BE)
C ...................................................................
C but: CALCULE LE SECOND MEMBRE LOCAL SUR UN ELEMENT L PAR
C      BE(I)=SOMME(F(X)*PHII)
C      PUIS AJOUTE LES INTEGRALES DE surface
c
c in : coor(4,ndim) : coordonees des 4 sommets.
C      fomega(2,4)  : fx, fy volumiques AUX 4 sommets.
c      fgamma(ndim,2*nbarete): fx, fy aux noeuds de chaque arete.
c      pressi(2*nbarete)     : pression aux noeuds de chaque arete
c      norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                         norefs(i,2) = 0 si pression = 0 sur arete_i
c
c out: BE(10)       : SECOND MEMBRE
C -------------------------------------------------------------------
      implicit none
      integer i, nt, n1, n2, n3, k, j1, j2, j3, iface, k1, k2,
     +        i1, i2, NP(3,4), ind(4), nbaret, j, norefs(4,2)
      parameter (nbaret=4)
      double precision coor(5,2),fomega(2,5),fgamma(2,8),pressi(8),
     +                 aret(2,nbaret),be(10),F(10),DIV1,SURF,X31,Y31,
     +                 X42,Y42,x(5),y(5),xji,yji,arelon,xnu,ynu
      DATA IND/2,3,4,1/
      DATA NP/1,2,5,2,3,5,3,4,5,4,1,5/
C
C     CALCUL DES COORDONNEES DES NOEUDS
C
      DO 1 I = 1,4
        X(I) = coor(I,1)
        Y(I) = coor(I,2)
 1    continue
      X31=X(3)-X(1)
      Y31=Y(3)-Y(1)
      X42=X(4)-X(2)
      Y42=Y(4)-Y(2)
      DIV1=1./(Y31*X42-Y42*X31)
      X(5)=(X(1)*Y31*X42-X(2)*Y42*X31+(Y(2)-Y(1))*X31*X42)*DIV1
      Y(5)=(Y(2)*Y31*X42-Y(1)*Y42*X31-(X(2)-X(1))*Y31*Y42)*DIV1
C
C     -- FORCES VOLUMIQUES
C
      DO 2 I=1,10
        be(I)=0.
 2    continue
      DO 3 I=1,5
        DO 3 K=1,2
         F(2*I-2+K)=FOMEGA(K,I)
 3    continue

C
C --  FOMEGA: INTEGRATION AUX 4 SOMMETS
C
      DO 5 NT=1,4
        N1=NP(1,NT)
        N2=NP(2,NT)
        N3=NP(3,NT)
C       -- CALCUL DE SURF
C
        SURF=((X(N1)-X(N2))*(Y(N1)-Y(N3))-(X(N1)-X(N3))*
     +       (Y(N1)-Y(N2)))/24.
C       -- BOUCLE SUR LES DIRECTIONS
C
        DO 4 K=1,2
          J1=(N1-1)*2+K
          J2=(N2-1)*2+K
          J3=(N3-1)*2+K
          BE(J1)=SURF*(F(J1)*2.+F(J2)+F(J3))+BE(J1)
          BE(J2)=SURF*(F(J2)*2.+F(J3)+F(J1))+BE(J2)
          BE(J3)=SURF*(F(J3)*2.+F(J1)+F(J2))+BE(J3)
 4      CONTINUE
 5    continue
C
C --  FGAMMA: INTEGRATION AU milieu des aretes.
c     fgamma(2,2*nbarete) fx, fy aux extremites de chaque arete
c     pressi(2*nbarete) pression aux extremites de chaque arete
c     aret(2,nbarete) fx, fy au milieu de chaque arete
c
      do 6 k = 1 , nbaret
        XNU = 0.D0
        YNU = 0.D0
        if(norefs(k,2) .ne. 0) then
C         -- LONGEUR ARETE, COSINUS DIRECTEURS DE LA NORMALE ext.
          J         = MOD(k,4) + 1
          XJI    = coor(J,1) - coor(k,1)
          YJI    = coor(J,2) - coor(k,2)
          ARELON = DSQRT(XJI**2 + YJI**2)
          XNU    =  YJI/ARELON
          YNU    = -XJI/ARELON
        end if
        aret(1,k) = (-(pressi(2*(k-1) + 1) + pressi(2*(k-1) + 2))* XNU 
     +            +   (fgamma(1,2*(k-1)+1) + fgamma(1,2*(k-1)+2)) )/2.d0
        aret(2,k) = (-(pressi(2*(k-1) + 1) + pressi(2*(k-1) + 2))* YNU 
     +            +   (fgamma(2,2*(k-1)+1) + fgamma(2,2*(k-1)+2)) )/2.d0
 6    continue
      DO 7 IFACE=1 , nbaret
        I1=IFACE
        I2=IND(IFACE)
        SURF=SQRT((X(I1)-X(I2))**2+(Y(I1)-Y(I2))**2)*.5
        J1=2*I1-1
        J2=2*I2-1
        K1=2*I1
        K2=2*I2
        be(J1) = be(J1) + SURF*ARET(1,IFACE)
        be(J2) = be(J2) + SURF*ARET(1,IFACE)
        be(K1) = be(K1) + SURF*ARET(2,IFACE)
        be(K2) = be(K2) + SURF*ARET(2,IFACE)
 7    continue
      END
