      SUBROUTINE etsap2c(coor,fomega,fgamma,pressi,norefs,alpha,
     +                   theta,car,iopt,be)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DE SECONDS MEMBRES DE L ELEMENT TRIA AP2C
C ---  
c in : 
c   coor(noe,ndim) : coordonnees R(6), Z(6) des 6 noeuds.
c   fomega(ndim,noe)        : fx, fy aux noeuds => fomega(ndim,npi)
c                               => fface(ndim=2 , npi=1)
c   fgamma(ndim,nnof*nbarete): fx, fy aux noeuds de chaque arete.
c   pressi(nnof*nbarete)     : pression aux noeuds de chaque arete
c                               => farete(ndim=2  ,npia*nbarete=6)
c   norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                      norefs(i,2) = 0 si pression = 0 sur arete_i
C   theta(6)    : theta aux 6 noeuds
C   alpha    : coef. dilatation thermique: radial, axial, tangentiel
c   car        : caracteristiques des materiaux
c        if(iopt .eq. 1) then
c          car(1) = young
c          car(2) = poisson
c        else
c          car(1) = E_1  (Young radial     -> E_r     )
c          car(2) = nu_1 (poisson          -> Nu_r    )
c          car(3) = E_2  (Young axial      -> E_z     )
c          car(4) = nu_2 (poisson          -> Nu_z    )
c          car(5) = E_3  (Young Tangentiel -> E_theta )
c        end if
C out: BE(12): second membre.
C  ..................................................................
      implicit none
      integer ndim,NBPOLY,NPI,nbarete,nnof,IP(12),npia,l,i,iopt,i1,il,
     +        norefs(3,2),j,k,m,k1,k4,l1,i2
      PARAMETER (ndim=2, NBPOLY=6, NPI=7, nbarete=3, nnof=3)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,npi),DFM1DP(2,nbpoly,npi),fomega(2,6),
     +                 fface(2,npi),fgamma(2,9),pressi(9),farete(2,9),
     +                 xnu(3),ynu(3),alpha(3),alpha_r,alpha_z,alpha_t,
     +                 theta(6),
     +                 BE(12),COOR(6,2),car(10),D1,D2,RR,
     +                 D2PI,POIDSA(3),XA(3),P1PA,P2PA,
     +                 P3PA,ELAS(10),A(4),G1(12),G2(12),G4(12,6),
     +                 fx,fy,arelon,
     +                 xmi, ymi,xjm,yjm, p25a(3,3),d
      DATA D2PI/ 6.2831853071795862D0 /
C 2P25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +             .10128650732345632D+00,   .10128650732345632D+00,
     +             .79742698535308720D+00,   .10128650732345632D+00,
     +             .10128650732345632D+00,   .79742698535308720D+00,
     +             .47014206410511505D+00,   .59715871789769801D-01,
     +             .47014206410511505D+00,   .47014206410511505D+00,
     +             .59715871789769801D-01,   .47014206410511505D+00,
     +             .33333334326744079D+00,   .33333334326744079D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS /
     +             .62969590272413583D-01,   .62969590272413583D-01,
     +             .62969590272413583D-01,   .66197076394253095D-01,
     +             .66197076394253095D-01,   .66197076394253095D-01,
     +             .11249999701976776D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / 
     +             .47435260858553857D+00,  -.80768594191887185D-01,
     +            -.80768594191887185D-01,   .32307437676754874D+00,
     +             .41035826263138293D-01,   .32307437676754874D+00,
     +            -.80768594191886977D-01,   .47435260858553840D+00,
     +            -.80768594191887185D-01,   .32307437676754879D+00,
     +             .32307437676754868D+00,   .41035826263138341D-01,
     +            -.80768594191887033D-01,  -.80768594191887185D-01,
     +             .47435260858553840D+00,   .41035826263138334D-01,
     +             .32307437676754868D+00,   .32307437676754890D+00,
     +            -.28074943223078796D-01,  -.28074943223078852D-01,
     +            -.52583901102545349D-01,   .88413424176407262D+00,
     +             .11229977289231514D+00,   .11229977289231517D+00,
     +            -.52583901102545571D-01,  -.28074943223078852D-01,
     +            -.28074943223078852D-01,   .11229977289231540D+00,
     +             .88413424176407240D+00,   .11229977289231540D+00,
     +            -.28074943223078765D-01,  -.52583901102545349D-01,
     +            -.28074943223078852D-01,   .11229977289231514D+00,
     +             .11229977289231514D+00,   .88413424176407262D+00,
     +            -.11111111773384862D+00,  -.11111110779974175D+00,
     +            -.11111110779974175D+00,   .44444443119896703D+00,
     +             .44444447093539807D+00,   .44444443119896703D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +            -.21897079414123492D+01,  -.21897079414123492D+01,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +             .27845619121185238D+01,  -.40514602929382531D+00,
     +             .40514602929382531D+00,   .40514602929382531D+00,
     +            -.40514602929382531D+00,   .27845619121185238D+01,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +             .21897079414123488D+01,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +            -.27845619121185229D+01,  -.31897079414123488D+01,
     +             .40514602929382531D+00,   .31897079414123488D+01,
     +            -.40514602929382531D+00,   .00000000000000000D+00,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .21897079414123488D+01,
     +             .00000000000000000D+00,  -.40514602929382531D+00,
     +             .31897079414123488D+01,   .40514602929382531D+00,
     +            -.31897079414123488D+01,  -.27845619121185229D+01,
     +            -.88056825642046065D+00,  -.88056825642046065D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.76113651284092076D+00,
     +             .00000000000000000D+00,  -.18805682564204602D+01,
     +             .23886348715907920D+00,   .18805682564204602D+01,
     +            -.23886348715907920D+00,   .16417047692613815D+01,
     +             .76113651284092043D+00,   .76113651284092043D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +            -.16417047692613806D+01,  -.18805682564204602D+01,
     +             .18805682564204602D+01,   .18805682564204602D+01,
     +            -.18805682564204602D+01,  -.16417047692613806D+01,
     +            -.88056825642046054D+00,  -.88056825642046054D+00,
     +            -.76113651284092076D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +             .16417047692613813D+01,  -.23886348715907920D+00,
     +             .18805682564204602D+01,   .23886348715907920D+00,
     +            -.18805682564204602D+01,   .00000000000000000D+00,
     +            -.33333325386047363D+00,  -.33333325386047363D+00,
     +             .33333337306976318D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .33333337306976318D+00,
     +            -.11920928955078125D-06,  -.13333333730697631D+01,
     +             .13333333730697631D+01,   .13333333730697631D+01,
     +            -.13333333730697631D+01,  -.11920928955078125D-06 /
C
      DATA NPIA,POIDSA,XA/3, 0.277777777777D0,0.444444444444D0,
     +                       0.277777777777D0, 0.1127015D0,0.5D0,
     +                       0.8872985D0/
c   -- Valeurs aux pt d'int. num. a partir valeurs aux noeuds
c      Efforts volumiques  fomega(ndim,noe) -> fface(ndim,npi)
      do 2 i = 1 , npi
        fface(1,i) = 0.d0
        fface(2,i) = 0.d0
        do 1 j = 1 , nbpoly
          fface(1,i) =  fface(1,i) + P25(j,i) * fomega(1,j)
          fface(2,i) =  fface(2,i) + P25(j,i) * fomega(2,j)
 1      continue
 2    continue
c   -- Valeurs aux pt d'int. num. a partir valeurs aux noeuds
c      fgamma(ndim,(nnof*nbarete) -> farete(ndim, npia*nbarete)
c      pressi(nnof*nbarete)       -> idem
      do 5 k = 1 , nbarete
C       -- LONGEUR DE L ARETE, COSINUS DIRECTEURS DE LA NORMALE ext.
        J         = MOD(k,3) + 1
        M         = k + 3
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) ) 
        il = npia*(k-1)
        do 4 i = 1 , npia
          fx = 0.d0
          fy = 0.d0
          P25A(1,i) = ( 1.D0 - XA(I) ) * ( 1.D0 - 2.D0 * XA(I) )
          P25A(2,i) =   XA(I) * ( 2.D0 * XA(I) - 1.D0 )
          P25A(3,i) = 4.D0 * ( 1.D0 - XA(I) ) * XA(I)
          do 3 j = 1 , nnof
            fx = fx + p25a(j,i)*(fgamma(1,j+il) - pressi(j+il) * XNU(j))
            fy = fy + p25a(j,i)*(fgamma(2,j+il) - pressi(j+il) * YNU(j))
 3      continue
          farete(1,il+i) = fx
          farete(2,il+i) = fy
 4     continue
 5      continue
C
c     -- CALCUL DE F1,F2,FFM1,DFM1DP
c
      CALL E2AP2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
C
      do 6 i = 1 , 12
        be(i) = 0.d0
 6    continue
C
c     -- CONTRIBUTION DES EFFORTS SURFACIQUES 
C             FOMEGA(2,npi)
      DO 9 I=1,NBPOLY
        DO 8 J=1,2
          I1 = IP(I + NBPOLY * (J-1))
          D1 = 0.D0
          DO 7 L = 1,NPI
            D1 = D1 + POIDEL(L) * P25(I,L) * fface(J,L)
 7        CONTINUE
          BE(I1) = BE(I1) + D1
 8      CONTINUE
 9    CONTINUE
C
c     -- CONTRIBUTIONS DES EFFORTS SUR LES ARETES
C
      DO 12 K=1,3
        K1   = MOD(k,3) + 1
        K4 = K + 3
        DO 11 L=1,NPIA
          RR = COOR(K,1)*P25A(1,L) + COOR(K1,1)*P25A(2,L)
     +       + COOR(K4,1)*P25A(3,L)
          P1PA = 4.D0 * XA(L) - 3.D0
          P2PA = 4.D0 * XA(L) - 1.D0
          P3PA = 4.D0 - 8.D0 * XA(L)
          D1 = COOR(K,1)*P1PA + COOR(K1,1)*P2PA
     +       + COOR(K4,1)*P3PA
          D2 = COOR(K,2)*P1PA + COOR(K1,2)*P2PA
     +       + COOR(K4,2)*P3PA
          D1 = D1 * D1 + D2 * D2
          D1 = D2PI * DSQRT(D1)
          L1 = L + NPIA * ( K - 1 )
          DO 10 J=1,2
            I  = IP(K  +(J-1)*NBPOLY)
            I1 = IP(K1 +(J-1)*NBPOLY)
            I2 = IP(K+3+(J-1)*NBPOLY)
            D = RR * D1 * POIDSA(L) * farete(J,L1)
            BE(I)  = BE(I)  + D * P25A(1,L)
            BE(I1) = BE(I1) + D * P25A(2,L)
            BE(I2) = BE(I2) + D * P25A(3,L)
 10       CONTINUE
 11     CONTINUE
 12   CONTINUE
C
c     -- CONTRIBUTIONS DES CONTRAINTES THERMIQUES
C
      call hookax(iopt,car,elas)
c
c  [  Sig_zz  ]    [      ] [alpha_z]
c  [          ]    [      ] [       ]
c  [  Sig_rr  ]    [      ] [alpha_r]                [ theta(1) ]
c  [          ] := [ elas ]*[       ]*[ p1 p2 p3 ] * [ theta(2) ]
c  [  Sig_tt  ]    [      ] [alpha_t]           1*3  [ theta(3) ]
c  [          ]    [      ] [       ]                          3*1
c  [  Sig_rz  ]    [      ] [  0    ]
c            4*1         4*4       4*1      
C
C -- [ A ]  = [ELAS] * [ALPHA]
C       4*1       4*4       4*1
      alpha_r = alpha(1)
      alpha_z = alpha(2)
      alpha_t = alpha(3)
      A(1) = ALPHA_z*ELAS(4) + ALPHA_r*ELAS(5) + ALPHA_t*ELAS(6)
      A(2) = ALPHA_z*ELAS(2) + ALPHA_r*ELAS(3) + ALPHA_t*ELAS(5)
      A(3) = ALPHA_z*ELAS(7) + ALPHA_r*ELAS(8) + ALPHA_t*ELAS(9)
      A(4) = ALPHA_z*ELAS(1) + ALPHA_r*ELAS(2) + ALPHA_t*ELAS(4)
C
      do 15 L = 1 , 6
        do 15 I = 1 , 12
          G4(I,L) = 0.d0
 15   continue
C
      DO 17 L=1,NPI
         D    = POIDEL(L)
         DO 16 I=2,4
            G1(I) = D * A(I)
   16    CONTINUE
         D = D/F1(L)
         G1(1) = D * A(1)
C
C       -- TP * G1(1) + TDFM1DP * (G1(2),G1(3))
C
         CALL TAB0D(NBPOLY,1,1,P25(1,L),G1(1),G2)
         CALL TAB1D(NBPOLY,2,1,DFM1DP(1,1,L),G1(2),G2)
C
C       -- TDFM1DP * (G1(2),G1(4))
C
         CALL TAB0D(NBPOLY,2,1,DFM1DP(1,1,L),G1(3),G2(7))
C        G2 * P
         CALL AB1D(12,1,NBPOLY,G2,P25(1,L),G4)
   17 CONTINUE
C
C     THETA * G4  => BE = BE + G4(IP)
C
      DO 20 I=1,12
         L = IP(I)
         D = 0.D0
         DO 18 J = 1,NBPOLY
            D = D + theta(J) * G4(I,J)
 18      CONTINUE
         BE(L) = BE(L) + D
 20   CONTINUE
      END
