      subroutine etsaq2c(coor,fomega,fgamma,pressi,norefs,alpha,
     +                   theta,car,iopt,be)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DE SECONDS MEMBRES DE L ELEMENT QUAD AQ2C
C ---  
c in : 
c   coor(noe,ndim) : coordonnees R(6), Z(6) des 8 noeuds.
c   fomega(ndim,noe)        : fx, fy aux noeuds => fomega(ndim,npi)
c                               => fface(ndim=2 , npi=1)
c   fgamma(ndim,nnof*nbarete): fx, fy aux noeuds de chaque arete.
c   pressi(nnof*nbarete)     : pression aux noeuds de chaque arete
c                               => farete(ndim=2  ,npia*nbarete=6)
c   norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                      norefs(i,2) = 0 si pression = 0 sur arete_i
C   theta(8) : theta aux noeuds
C   alpha    : coef. dilatation thermique: radial, axial, tangentiel
c   car      : caracteristiques des materiaux
c        if(iopt .eq. 1) then
c          car(1) = young
c          car(2) = poisson
c        else
c          car(1) = E_1  (Young radial     -> E_r     )
c          car(2) = nu_1 (poisson          -> Nu_r    )
c          car(3) = E_2  (Young axial      -> E_z     )
c          car(4) = nu_2 (poisson          -> Nu_z    )
c          car(5) = E_3  (Young Tangentiel -> E_theta )
c        end if
C out: BE(16): second membre.
C  ..................................................................
      implicit none
      integer ndim,NBPOLY,NPI,nbarete,nnof,IP(16),npia,l,i,iopt,i1,il,
     +        j,k,m,k1,k4,l1,i2,norefs(4,2)
      PARAMETER (ndim=2, NBPOLY=8, NPI=9, nbarete=4, nnof=3)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,npi),DFM1DP(2,nbpoly,npi),fomega(2,8),
     +              fface(2,npi),fgamma(2,12),pressi(12),farete(2,12),
     +                 xnu(3),ynu(3),alpha(3),alpha_r,alpha_z,alpha_t,
     +                 theta(8),BE(16),COOR(8,2),car(10),D1,D2,RR,
     +                 D2PI,POIDSA(3),XA(3),P1PA,P2PA,
     +                 P3PA,ELAS(10),A(4),G1(16),G2(16),G4(16,8),
     +                 fx,fy,arelon,
     +                 xmi, ymi,xjm,yjm, p25a(3,3),d
c
      DATA D2PI/ 6.2831853071795862D0 /
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
c
      DATA NPIA,POIDSA,XA/3, 0.277777777777D0,0.444444444444D0,
     +                       0.277777777777D0,0.1127015D0,0.5D0,
     +                       0.8872985D0/
c   -- Valeurs aux pt d'int. num. a partir valeurs aux noeuds
c      Efforts volumiques  fomega(ndim,noe) -> fface(ndim,npi)
      do 2 i = 1 , npi
        fface(1,i) = 0.d0
        fface(2,i) = 0.d0
        do 1 j = 1 , nbpoly
          fface(1,i) =  fface(1,i) + P25(j,i) * fomega(1,j)
          fface(2,i) =  fface(2,i) + P25(j,i) * fomega(2,j)
 1      continue
 2    continue
c   -- Valeurs aux pt d'int. num. a partir valeurs aux noeuds
c      fgamma(ndim,(nnof*nbarete) -> farete(ndim, npia*nbarete)
c      pressi(nnof*nbarete)       -> idem
      do 5 k = 1 , nbarete
C       -- LONGEUR DE L ARETE, COSINUS DIRECTEURS DE LA NORMALE ext.
        J         = MOD(k,4) + 1
        M         = k + 4
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) ) 
        il = npia*(k-1)
        do 4 i = 1 , npia
          fx = 0.d0
          fy = 0.d0
          P25A(1,i) = ( 1.D0 - XA(I) ) * ( 1.D0 - 2.D0 * XA(I) )
          P25A(2,i) = XA(I) * ( 2.D0 * XA(I) - 1.D0 )
          P25A(3,i) = 4.D0 * XA(I) * ( 1.D0 - XA(I) )
          do 3 j = 1 , nnof
            fx = fx + p25a(j,i)*(fgamma(1,j+il) - pressi(j+il) * XNU(j))
            fy = fy + p25a(j,i)*(fgamma(2,j+il) - pressi(j+il) * YNU(j))
 3      continue
          farete(1,il+i) = fx
          farete(2,il+i) = fy
 4     continue
 5      continue
C
C     F1 , F2 , DFM1 , POIDEL , IP , DP PRETS A L EMPLOI
C
      CALL E2AQ2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
      do 6 i = 1 , 16
        be(i) = 0.d0
 6    continue
C
C     CONTRIBUTION DES EFFORTS SURFACIQUES
C
      DO 9 I=1,NBPOLY
         DO 8 J=1,2
            I1 = IP(I + NBPOLY * (J-1))
            D1 = 0.D0
            DO 7 L = 1,NPI
               D1 = D1 + POIDEL(L) * P25(I,L) * fface(J,L)
 7          CONTINUE
            BE(I1) = BE(I1) + D1
 8       CONTINUE
 9    CONTINUE
C
c     -- CONTRIBUTIONS DES EFFORTS SUR LES ARETES
c
      DO 12 K=1,4
        K1   = MOD(k,4) + 1
        K4 = K + 4
        DO 11 L=1,NPIA
          RR = COOR(K,1)*P25A(1,L) + COOR(K1,1)*P25A(2,L)
     +       + COOR(K4,1)*P25A(3,L)
          P1PA = 4.D0 * XA(L) - 3.D0
          P2PA = 4.D0 * XA(L) - 1.D0
          P3PA = 4.D0 - 8.D0 * XA(L)
          D1 = COOR(K,1)*P1PA + COOR(K1,1)*P2PA
     +       + COOR(K4,1)*P3PA
          D2 = COOR(K,2)*P1PA + COOR(K1,2)*P2PA
     +       + COOR(K4,2)*P3PA
          D1 = D1 * D1 + D2 * D2
          D1 = D2PI * DSQRT(D1)
          L1 = L + NPIA * ( K - 1 )
          DO 10 J=1,2
            I  = IP(K  +(J-1)*NBPOLY)
            I1 = IP(K1 +(J-1)*NBPOLY)
            I2 = IP(K+4+(J-1)*NBPOLY)
            D = RR * D1 * POIDSA(L) * farete(J,L1)
            BE(I)  = BE(I)  + D * P25A(1,L)
            BE(I1) = BE(I1) + D * P25A(2,L)
            BE(I2) = BE(I2) + D * P25A(3,L)
 10       CONTINUE
 11     CONTINUE
 12   CONTINUE
c
c     -- CONTRIBUTIONS DES CONTRAINTES THERMIQUES
C
      call hookax(iopt,car,elas)
c
c [Sig_zz]   [    ] [alpha_z]                               [theta(1)]
c [      ]   [    ] [       ]                               [theta(2)]
c [Sig_rr]   [    ] [alpha_r]                               [theta(3)]
c [      ] = [elas]*[       ]*[ q1 q2 q3 q4 q5 q6 q7 q8 ] * [theta(4)]
c [Sig_tt]   [    ] [alpha_t]                          1*8  [theta(5)]
c [      ]   [    ] [       ]                               [theta(6)]
c [Sig_rz]   [    ] [  0    ]                               [theta(7)]
c       4*1      4*4       4*1                              [theta(8)]
C                                                                  8*1
C -- [ A ]  = [ELAS] * [ALPHA]
C       4*1       4*4       4*1
      alpha_r = alpha(1)
      alpha_z = alpha(2)
      alpha_t = alpha(3)
      A(1) = ALPHA_z*ELAS(4) + ALPHA_r*ELAS(5) + ALPHA_t*ELAS(6)
      A(2) = ALPHA_z*ELAS(2) + ALPHA_r*ELAS(3) + ALPHA_t*ELAS(5)
      A(3) = ALPHA_z*ELAS(7) + ALPHA_r*ELAS(8) + ALPHA_t*ELAS(9)
      A(4) = ALPHA_z*ELAS(1) + ALPHA_r*ELAS(2) + ALPHA_t*ELAS(4)
c
      do 20 L = 1 , 8
        do 20 I = 1 , 16
          G4(I,L) = 0.d0
 20   continue
C
      DO 14 L=1,NPI
         D    = POIDEL(L)
         DO 13 I=2,4
            G1(I) = D * A(I)
 13      CONTINUE
         D = D/F1(L)
         G1(1) = D * A(1)
C
C       -- TP * G1(1) + TDFM1DP * (G1(2),G1(3))
C
         CALL TAB0D(NBPOLY,1,1,P25(1,L),G1(1),G2)
         CALL TAB1D(NBPOLY,2,1,DFM1DP(1,1,L),G1(2),G2)
C
C       -- TDFM1DP * (G1(3),G1(4))
C
         CALL TAB0D(NBPOLY,2,1,DFM1DP(1,1,L),G1(3),G2(9))
C        G2 * P
         CALL AB1D(16,1,NBPOLY,G2,P25(1,L),G4)
 14   CONTINUE
C
C     Theta * G4  => BE = BE + G4(IP)
C
      DO 16 I=1,16
         L = IP(I)
            D = 0.D0
            DO 15 J=1,NBPOLY
               D = D + theta(J) * G4(I,J)
 15         CONTINUE
            BE(L) = BE(L) + D
 16   CONTINUE
      END

