      SUBROUTINE hookax(iopt,car,elas)
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DE LA MATRICE D ELASTICITE ( 4*4 ) AXISYMETRIQUE .
c
c in : car: caracteristiques des materiaux
c           if(iopt .lt. 3) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c out: elas(10)                        -1
c      Deformation             [ Elas ]                        Stress
c         ||                      ||                             ||
c      | s_zz |   |   1/E_2    -Nu_2/E_2  -Nu_2/E_2   0   |   | s_zz |
c      | s_rr | - | -Nu_1/E_1    1/E_1    -Nu_1/E_1   0   |   | s_rr |
c      | s_tt | - | -Nu_3/E3   -Nu_3/E_3    1/E_3     0   | * | s_tt |
c      | s_rz |   |     0          0          0     1/G_2 |   | s_rz |
c
c isotrope  : E_1 = E_2 = E_3     ;    Nu_1 = Nu_2 = Nu_3
c
c orthotrope: -Nu_2/E_2 = -Nu_1/E_1 ; -Nu_3/E3 = -Nu_2/E_2 ;
c             -Nu_3/E_3 = -Nu_1/E_1 ; G_2 = E_2 / (2*(1+Nu_2))
C ....................................................................
c ...............................................................
c  programmeur : modulef
c ...............................................................
      implicit none
      integer iopt
      double precision car(10),elas(10),E,nu,E1,E2,E3,nu1,nu2
C
      IF(iopt .lt. 3) THEN
        E  = car(1)
        nu = car(2)
        elas(1) = E*(nu-1)/(2*nu**2+nu-1)
        elas(2) = -E*nu/(2*nu**2+nu-1)
        elas(3) = E*(nu-1)/(2*nu**2+nu-1)
        elas(4) = -E*nu/(2*nu**2+nu-1)       
        elas(5) = -E*nu/(2*nu**2+nu-1)
        elas(6) = E*(nu-1)/(2*nu**2+nu-1)
        elas(7) = 0.
        elas(8) = 0.
        elas(9) = 0.
        elas(10)= E / ( 2*(1+nu) )
      else
        E1  = car(1)
        Nu1 = car(2)
        E2  = car(3)
        Nu2 = car(4)
        E3  = car(5)

        elas(1) = (E1-nu1**2*E3)/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)*E2**2

        elas(2) = nu2*(E1+nu1*E3)*E2*E1/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)

        elas(3) = (E2-nu2**2*E3)/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)*E1**2

        elas(4) = nu2*(nu1+1)*E2*E1/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)*E3

        elas(5) = (nu1*E2+nu2**2*E1)*E1/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)*E3

        elas(6) = (E2-nu2**2*E1)*E1/(E2*E1-E2*nu1**2*E3-nu2**2*E1**2
     +           -2*nu2**2*E1*nu1*E3-nu2**2*E1*E3)*E3
        elas(7) = 0.
        elas(8) = 0.
        elas(9) = 0.
        elas(10)= E2 / ( 2*(1+nu2) )
      endif
c
      return
      end
