function [val,i1]=stack_get(Up,st,st1,GiveData)

%STACK_GET stack handling routines for use by SDT
%
%       Syntax: [StackRows,index]=stack_get(Up,typ);
%               [StackRows,index]=stack_get(Up,typ,name);
%               [StackRows,index]=stack_get(Up,typ,name,GiveData);

%       Etienne Balmes  05/01/01, 30/11/01
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.
%       $Revision: 1.3 $  $Date: 2003/08/28 13:19:07 $

name='';i1=[];
if ~isfield(Up,'Stack') Up.Stack={}; end

if isempty(Up.Stack) i1=[];
elseif nargin==1|isempty(st)
 i1=[1:size(Up.Stack,1)]';
else
 i1=find(strcmp(st,Up.Stack(:,1)));
end

if isempty(i1) val=cell(0,3);
elseif nargin>2
  i2=find(strcmp(st1,Up.Stack(i1,2)));
  if isempty(i2) val=cell(0,3); i1=[];
  else i1=i1(i2);val=Up.Stack(i1,:);
  end
else
  val=Up.Stack(i1,:);
end

if nargin==4 
 if size(val,1)==1 val=val{1,3};
 elseif isempty(val) val=[];
 else error('Cannot return value for multiple matches');end
end