function Up=stack_rm(Up,st,st1,TestLow)

% stack handling routines for use by SDT
%
%       Syntax: Up=stack_rm(Up,typ,name);
%               Up=stack_rm(Up,typ);
%               Up=stack_rm(Up,'',name);

%       Etienne Balmes  05/01/01, 29/07/01
%       Copyright (c) 2001-2005 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.
%       $Revision: 1.7 $  $Date: 2006/05/10 08:33:36 $

name='';
if ~isfield(Up,'Stack') Up.Stack={}; end
if ~isempty(Up.Stack)

 [CAM,st]=comstr(st,1);
 if isempty(st);i1=[1:size(Up.Stack,1)]; 
 elseif nargin>3;i1=find(strcmp(comstr(st,-27),comstr(Up.Stack(:,1),-27)));
 else; i1=find(strcmp(st,lower(Up.Stack(:,1))));
 end

 if nargin==2 st1=''; else st1=comstr(st1,1); end
 if isempty(i1) % no match for type
 elseif ~isempty(st1) % try matching 
  i2=find(strcmp(st1,Up.Stack(i1,2)));
  if ~isempty(i2) i1=i1(i2); else i1=[];end
 else % remove all
   i2=[1:length(i1)];
 end

 if ~isempty(i1) 
   i2=[1:size(Up.Stack,1)];i2(i1)=0;i2=find(i2);
   Up.Stack=Up.Stack(i2,:);
 end

end 
