
% Tests/developement of thermal capabilities in the mat_og element family

model=femesh(';reset;teststruct hexa8b');

% Uniform temperature of 30 degrees (nominal 20)
defT=struct('def',ones(size(model.Node,1),1)*30,'DOF',model.Node(:,1)+.20);

% Define thermal expansion coefficients and reference temperatures
[i1,i2]=intersect(model.pl(:,1),[100;112]);
model.pl(i2,8:9)=[1e-5 20;2e-5 20];


model.Elt(2:end,9)=100;
model.Elt(feutil('findelt withnode {z==0}',model),9)=112;



% Initialize case and compute temperature generated stresses

Case=fe_stres('thermal',model,defT);

b=fe_mknl('assemble',model,Case,103);

%cf=feplot;cf.model=model;cf.def={b,model.DOF};fecom colordataa

% Compute deformation under thermal load

k=fe_mknl('assemble',model,Case,1);
q=ofact(k,Case.T'*b); def=struct('def',Case.T*q,'DOF',model.DOF);

