% Read NOPO file
model = nopo('read q2','3D');

% Create empty plot
%cf = feplot;

% Plot selected model
%fecom(';view3;colorfacew;showpatch');
%cf.model = {FEnode,FEelt};

% Construct vector of DOF
mdof = femesh('finddof group1',FEelt);

% Find nodes such that z=0
i1 = femesh('findnode z==0');

% Extract vector of active DOF from mdof
adof = fe_c(mdof, i1, 'dof', 2);

% Properties
pl = [1 0.1e+1 0.21e+6 0.3 0];

% Assemble
[m,k,adof1]=fe_mk(FEnode,FEelt,pl,[],[],adof,[0]);

% Create complete model
model = struct('Node',FEnode,'Elt',FEelt,'pl',pl,'il',[],'DOF',adof);

% Apply uniform pressure on upper face
r1 = struct('sel',{{'','selfacei','',femesh('findnode z==1')}}, ...
                   'def',1,'DOF',0.19);

% Compute deformation
load=fe_load(model,{'Fsurf','Surface load', r1});


% Plot deformation
def=k\load.def;

feplot('InitDef',def,model.DOF);
% same : cf.def = {def,model.DOF};

%fecom('anim ncycle 200');
%fecom('anim start');

defg = fe_c(mdof,adof)'*def;


