function [out,out1,out2]=tetra4(CAM,varargin);

%TETRA4B 4 node, 4 sided volume element supporting 
%
%     Should be replaced by TETRA4 elements with appropriate 
%       P_SOLID, P_HEAT or P_PIEZO element property entries
%
%       See also doc tetra4, integrules, p_solid

%	Etienne Balmes, Jean-Michel Leclere
%       Copyright (c) 2001-2005 by INRIA and SDTools,All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if comstr(CAM,'cvs')
 out='$Revision: 1.11 $  $Date: 2006/01/27 14:28:50 $'; return;
end
if ischar(CAM);

 [CAM,Cam]=comstr(CAM,1);
 if comstr(Cam,'integinfo')

  %constit integ,elmap                 ID,pl,il
  [out,out1,out2]= ...
   p_solid('buildconstit',[varargin{1};12;4;1],varargin{2},varargin{3});

 elseif comstr(Cam,'call'); out=elem0('callmat_og');
 elseif comstr(Cam,'rhscall'); out=elem0('rhsmat_og'); % call for load
 elseif  comstr(Cam,'test'); [CAM,Cam] = comstr(CAM,5);
   [out,out1]=femesh(strcat('teststruct tetra4b',Cam));
 else; 
  if nargout==0; tetra4(CAM,varargin{:});
  elseif nargout==1; out=tetra4(CAM,varargin{:});
  elseif nargout==2; [out,out1]=tetra4(CAM,varargin{:});
  elseif nargout==3; [out,out1,out2]=tetra4(CAM,varargin{:});
  end
 end % commands

 return;

 end % of standard calls with one input argument

