function [out,out1,out2]=tria6(CAM,varargin);

%TRIA6	element function of a 6-node plate element
%
%	As all element functions (see ELEM0), TRIA6 is called by FE_MK for
%	model assembly, FEPLOT for structural deformation visualization, ...
%
%	TRIA6 header rows follow the format [Inf  abs('tria6') 0 EGID ...]
%	TRIA6 element property rows follow the format
%	    [n1 ... n6 MatID ProID (EltID Theta Zoff T1 ... T6)]
%         with
%          n1 ... n6  identification numbers for the element nodes
%	   MatID  material property identification number
%	   ProID  element property identification number
%	   EltID  optional element identification number
%	   Theta  unused
%          Zoff   optional offset from the surface of the nodes to the 
%		  reference plane
%	   T1 ... T6  optional thickness at nodes (used instead of IL entry)
%		  Currently the mean of Ti is used.
%
% 	TRIA6 is currently for plotting ONLY

%	Etienne Balmes   10/10/90, 19/03/02
%       Copyright (c) 2001-2002 by INRIA and SDTools

%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.

if comstr(CAM,'cvs')
 out='$Revision: 1.14 $  $Date: 2006/02/28 15:03:59 $'; return;
end
% standard calls with one input argument
if ischar(CAM)

 [CAM,Cam]=comstr(CAM,1);
 % Build Constit, Integ, and Elmap for later integration
 if comstr(Cam,'integinfo')

  [pe,ie,dm,db,ds]=fe_mat(2,varargin{1},varargin{2},varargin{3});
  %          rho*h       eta       f d h k 12I/t3 nsm   dm db ds
  constit = [pe(5)*ie(6) pe(5) ie([3 4 6 7 9      11 ]) dm(:)' db(:)' ds(:)'];
  iopt=varargin{1};%matid proid
  out1=iopt(:); out=constit(:); 
  % element map
  out2=[];

 elseif comstr(Cam,'matcall')

  out=@tria6;  k=0; % SymFlag

 elseif comstr(Cam,'call')  % call for matrix assembly
   out='[k1,m1]=tria6(nodeE,elt(cEGI(jElt),:),pointers(:,jElt),integ,constit,elmap);';
 elseif comstr(Cam,'rhscall') % call for load assembly
   out='be=tria6(CamE,elt(cEGI(jElt),:),pointers(:,jElt),integ,constit,elmap,gstate);';

 elseif  comstr(Cam,'groupinit');   out = '';
 elseif  comstr(Cam,'node');    out = [1:6];
 elseif comstr(Cam,'dofcall');out=elem0('dofcall'); % variable field elements
 elseif  comstr(Cam,'dof');
   out = [1+[1:6]'/100;2+[1:6]'/100;3+[1:6]'/100; 
          4+[1:6]'/100;5+[1:6]'/100;6+[1:6]'/100];
 elseif  comstr(Cam,'line'); out = [1 4 2 5 3 6 1]; return; 
 elseif  comstr(Cam,'patch');   out = [1 4 2 5 3 6];return; 
 elseif  comstr(Cam,'prop');   out = [7 8 9];
 elseif  comstr(Cam,'parent');  out = 'tria6';
 elseif  comstr(Cam,'edge');   out = [1 2 4; 2 3 5; 3 1 6];
 elseif  comstr(Cam,'face');   out = [1 2 3 4 5 6];
 elseif  comstr(Cam,'flip');   out=[1 3 2 6 5 4];out1=1:6; 
 elseif  comstr(Cam,'sci_face');  out = [1 4 6;4 2 5;5 3 6;4 5 6];
 elseif  comstr(Cam,'test'); 
   warning('Tria6 : Matrix computations not supported yet');
   out='error';
 end
 return
end % of standard calls with one input argument

warning('Matrix computations not supported yet');
out='error';
