/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;
import org.jdesktop.jdic.packager.impl.WinMsiWrapper;

public class WinUtility {
    private static final int BUFFER = 2048;
    public static final int BIN_RES_ID = 104;
    public static final int STRING_RES_UUID_ID = 1600;
    public static final int STRING_RES_LOCALIZATION_FLAG_ID = 1760;

    public static void checkFileValid(String string) throws IOException {
        File file = new File(string);
        if (!FileOperUtility.isFileReadable(file)) {
            throw new IOException("The file " + string + " does not exist or can not be accessed!");
        }
    }

    private static void checkDirValid(String string) throws IOException {
        File file = new File(string);
        if (!FileOperUtility.isDirectoryReadable(file)) {
            throw new IOException("The dir " + string + " does not exist or can not be accessed!");
        }
    }

    private static void putIntoZip(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        try {
            byte[] byArray = new byte[2048];
            BufferedInputStream bufferedInputStream = null;
            FileInputStream fileInputStream = new FileInputStream(string2);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            int n = 0;
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                n += n2;
            }
            bufferedInputStream.close();
            fileInputStream.close();
            fileInputStream = new FileInputStream(string2);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            CheckedInputStream checkedInputStream = new CheckedInputStream(bufferedInputStream, new CRC32());
            long l = 0L;
            while ((n2 = checkedInputStream.read(byArray, 0, 2048)) != -1) {
            }
            l = checkedInputStream.getChecksum().getValue();
            checkedInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
            fileInputStream = new FileInputStream(string2);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(0);
            zipEntry.setSize(n);
            zipEntry.setCrc(l);
            zipOutputStream.putNextEntry(zipEntry);
            while ((n2 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                zipOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            throw new IOException("Failed to package the zip file!");
        }
    }

    public static void jarJnlpFiles(String string, JnlpPackageInfo jnlpPackageInfo) throws IOException {
        try {
            String string2 = jnlpPackageInfo.getResourceDirPath();
            Iterator iterator = jnlpPackageInfo.getJnlpRefFilePaths();
            if (iterator == null) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            CheckedOutputStream checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(checkedOutputStream));
            zipOutputStream.setLevel(0);
            zipOutputStream.setMethod(0);
            WinUtility.checkDirValid(string2);
            boolean bl = true;
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = null;
                if (!bl) {
                    string4 = string2 + File.separator + string3;
                } else {
                    string4 = string3;
                    bl = false;
                }
                WinUtility.checkFileValid(string4);
                WinUtility.putIntoZip(string3, string4, zipOutputStream);
            }
            zipOutputStream.flush();
            zipOutputStream.close();
            checkedOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Failed to create the jar file " + string);
        }
    }

    public static void extractFileFromJarFile(String string, String string2, String string3) throws IOException {
        try {
            JarEntry jarEntry;
            WinUtility.checkFileValid(string);
            boolean bl = false;
            BufferedOutputStream bufferedOutputStream = null;
            FileInputStream fileInputStream = new FileInputStream(string);
            JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(fileInputStream));
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n;
                String string4 = jarEntry.getName();
                if (!jarEntry.getName().equalsIgnoreCase(string2)) continue;
                bl = true;
                byte[] byArray = new byte[2048];
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = jarInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            jarInputStream.close();
            fileInputStream.close();
            if (!bl) {
                throw new IOException("The jar file " + string + " does not contain file " + string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Error: Illegal File Name: " + string3);
        }
        catch (Exception exception) {
            throw new IOException("Error extracting data from the jar file!");
        }
    }

    public static void updateResourceString(String string, String string2, int n) throws IOException {
        WinUtility.checkFileValid(string);
        WinMsiWrapper.winUpdateResourceString(string, string2, n);
    }

    public static void updateResourceData(String string, String string2, int n) throws IOException {
        WinUtility.checkFileValid(string);
        WinUtility.checkFileValid(string2);
        WinMsiWrapper.winUpdateResourceData(string, string2, n);
    }
}

