/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.io.File;

public class WebBrowserUtil {
    private static final String EMBED_BINARY_WINDOWS_IE = "IeEmbed.exe";
    private static final String EMBED_BINARY_WINDOWS_MOZILLA = "MozEmbed.exe";
    private static final String EMBED_BINARY_LINUX_GTK1 = "mozembed-linux-gtk1.2";
    private static final String EMBED_BINARY_LINUX_GTK2 = "mozembed-linux-gtk2";
    private static final String EMBED_BINARY_FREEBSD_GTK1 = "mozembed-freebsd-gtk1.2";
    private static final String EMBED_BINARY_FREEBSD_GTK2 = "mozembed-freebsd-gtk2";
    private static final String EMBED_BINARY_SOLARIS_GTK1 = "mozembed-solaris-gtk1.2";
    private static final String EMBED_BINARY_SOLARIS_GTK2 = "mozembed-solaris-gtk2";
    private static String embedBinary;
    private static String browserPath;
    private static boolean isDebugOn;

    private static native String nativeGetBrowserPath();

    private static native String nativeGetMozillaGreHome();

    public static String getEmbedBinaryName() {
        if (embedBinary != null && embedBinary.length() > 0) {
            return embedBinary;
        }
        String string = WebBrowserUtil.getBrowserPath();
        if (null == string) {
            WebBrowserUtil.trace("No default browser is found. Or environment variable MOZILLA_FIVE_HOME is not set to a Mozilla binary path if you are on Linux/Unix platform.");
            return null;
        }
        String string2 = System.getProperty("os.name");
        if (string2.indexOf("Windows") >= 0) {
            String string3 = string;
            int n = string3.indexOf("mozilla.exe");
            embedBinary = n >= 0 ? EMBED_BINARY_WINDOWS_MOZILLA : EMBED_BINARY_WINDOWS_IE;
        } else {
            String string4 = string + File.separator + "components" + File.separator + "libwidget_gtk2.so";
            File file = new File(string4);
            if (!file.exists()) {
                if (string2.indexOf("Linux") >= 0) {
                    embedBinary = EMBED_BINARY_LINUX_GTK1;
                } else if (string2.indexOf("SunOS") >= 0) {
                    embedBinary = EMBED_BINARY_SOLARIS_GTK1;
                } else if (string2.indexOf("FreeBSD") >= 0) {
                    embedBinary = EMBED_BINARY_FREEBSD_GTK1;
                }
            } else if (string2.indexOf("Linux") >= 0) {
                embedBinary = EMBED_BINARY_LINUX_GTK2;
            } else if (string2.indexOf("SunOS") >= 0) {
                embedBinary = EMBED_BINARY_SOLARIS_GTK2;
            } else if (string2.indexOf("FreeBSD") >= 0) {
                embedBinary = EMBED_BINARY_FREEBSD_GTK2;
            }
        }
        return embedBinary;
    }

    public static String getBrowserPath() {
        if (browserPath == null) {
            browserPath = WebBrowserUtil.nativeGetBrowserPath();
        }
        return browserPath;
    }

    public static boolean isDefaultBrowserMozilla() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("solaris") >= 0 || string.indexOf("linux") >= 0) {
            return true;
        }
        String string2 = WebBrowserUtil.getBrowserPath();
        return string2.indexOf("mozilla") >= 0;
    }

    public static String getMozillaGreHome() {
        return WebBrowserUtil.nativeGetMozillaGreHome();
    }

    public static void enableDebugMessages(boolean bl) {
        isDebugOn = bl;
    }

    public static void trace(String string) {
        if (isDebugOn) {
            System.out.println("*** Jtrace: " + string);
        }
    }

    public static void error(String string) {
        System.err.println("*** Error: " + string);
    }

    public static native void nativeSetEnv();

    static {
        browserPath = null;
        isDebugOn = false;
    }
}

