/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;
import org.jdesktop.jdic.packager.impl.PackageGenerator;
import org.jdesktop.jdic.packager.impl.PackageGeneratorFactory;

public final class Jnlp2Package {
    private Jnlp2Package() {
    }

    private static boolean getBoolProperty(String string) {
        String string2 = System.getProperty(string);
        boolean bl = false;
        if (string2 == null) {
            bl = false;
        } else if (string2.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string2.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new IllegalArgumentException("The value of property " + string + " can only be either true or false.");
        }
        return bl;
    }

    private static JnlpPackageInfo parseArguments(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        JnlpPackageInfo jnlpPackageInfo = null;
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Please specify the jnlp file path.");
        }
        jnlpPackageInfo = new JnlpPackageInfo();
        URL uRL = null;
        if (stringArray[0].startsWith("http://")) {
            try {
                uRL = new URL(stringArray[0]);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Invalid url argument: " + malformedURLException.getMessage());
            }
            jnlpPackageInfo.parseRemoteJnlpInfo(uRL);
        } else {
            File file = new File(stringArray[0]);
            if (!file.exists() || !file.isFile()) {
                throw new IOException("invalid local jnlp file: " + file.getPath());
            }
            String string6 = System.getProperty("JnlpConstants.PROPERTY_NAME_RESOURCEDIR");
            if (string6 == null) {
                string6 = file.getParent();
            }
            jnlpPackageInfo.setResourcePath(Jnlp2Package.getValidFileArgument(string6, "resource path", false));
            jnlpPackageInfo.parseLocalJnlpInfo(file.toURL());
        }
        jnlpPackageInfo.setLocalizedInformation();
        Jnlp2Package.checkPackageNameArgument(jnlpPackageInfo);
        Jnlp2Package.checkOutputDirNameArgument(jnlpPackageInfo);
        string = System.getProperty("Version");
        if (string == null) {
            string = "1.0";
        }
        jnlpPackageInfo.setVersion(string);
        string2 = System.getProperty("Release");
        if (string2 == null) {
            string2 = "1";
        }
        jnlpPackageInfo.setRelease(string2);
        string3 = System.getProperty("LicenseDir");
        string3 = Jnlp2Package.getValidFileArgument(string3, "license directory", true);
        if (string3 != null) {
            bl = true;
        }
        jnlpPackageInfo.setShowLicense(bl);
        jnlpPackageInfo.setLicenseDirPath(string3);
        string4 = System.getProperty("BannerJpgFile");
        string4 = Jnlp2Package.getValidFileArgument(string4, "Banner Jpeg File", true);
        jnlpPackageInfo.setBannerJpgFilePath(string4);
        string5 = System.getProperty("PanelJpgFile");
        string5 = Jnlp2Package.getValidFileArgument(string5, "Panel Jpeg File", true);
        jnlpPackageInfo.setPanelJpgFilePath(string5);
        Jnlp2Package.checkMSSDKPathArgument(jnlpPackageInfo);
        bl2 = Jnlp2Package.getBoolProperty("EnableShortcut");
        jnlpPackageInfo.setShortcutEnabled(bl2);
        bl3 = Jnlp2Package.getBoolProperty("EnableAssociation");
        jnlpPackageInfo.setAssociationEnabled(bl3);
        bl4 = Jnlp2Package.getBoolProperty("EnableSystemCache");
        jnlpPackageInfo.setSystemCacheEnabled(bl4);
        return jnlpPackageInfo;
    }

    private static String getValidFileArgument(String string, String string2, boolean bl) throws IOException {
        if (string == null) {
            if (bl) {
                return null;
            }
            throw new IllegalArgumentException(string2 + " could not be null.");
        }
        File file = new File(string);
        if ((file = file.getCanonicalFile()).canRead()) {
            return file.getPath();
        }
        throw new IllegalArgumentException("The given " + string2 + " is not valid: " + string);
    }

    private static void checkResourcePathArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        Object object;
        String string = System.getProperty("ResourceDir");
        String string2 = jnlpPackageInfo.getJnlpFilePath();
        File file = new File(string2);
        if (string == null) {
            object = file.getParent();
            string = Jnlp2Package.getValidFileArgument((String)object, "resource dir", false);
        } else {
            string = Jnlp2Package.getValidFileArgument(string, "resource dir", false);
        }
        object = new File(string);
        Iterator iterator = jnlpPackageInfo.getJnlpRefFilePaths();
        while (iterator.hasNext()) {
            File file2;
            String string3 = (String)iterator.next();
            if (string3 == null || FileOperUtility.isFileReadable(file2 = new File((File)object, string3))) continue;
            throw new IllegalArgumentException("Cann't read resource file: " + string3 + " from resource path: " + ((File)object).toString());
        }
        jnlpPackageInfo.setResourcePath(string);
    }

    private static void checkPackageNameArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        File file;
        File file2;
        String string = System.getProperty("PackageName");
        if (string == null ? (string = FileOperUtility.getFileNameWithoutExt(file2 = new File(jnlpPackageInfo.getJnlpFilePath()))) == null : (file = new File(string)).isDirectory()) {
            throw new IllegalArgumentException("The given jnlp file name is not a valid package name.");
        }
        jnlpPackageInfo.setPackageName(string);
    }

    private static void checkMSSDKPathArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = null;
        String string3 = null;
        if (string.startsWith("windows")) {
            string2 = System.getProperty("MSSDKDir");
            string2 = Jnlp2Package.getValidFileArgument(string2, "MS SDK Path", false);
            string2 = string2 + (string2.endsWith(File.separator) ? "" : File.separator);
            string3 = string2 + "Samples\\SysMgmt\\msi\\database\\UISample.Msi";
            string3 = Jnlp2Package.getValidFileArgument(string3, "raw MSI file path", false);
        }
        jnlpPackageInfo.setMSSDKDirPath(string2);
        jnlpPackageInfo.setRawMsiFilePath(string3);
    }

    private static void checkOutputDirNameArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        File file;
        String string = System.getProperty("OutputDir");
        if (string == null) {
            string = "." + File.separator;
        }
        if (!(string = Jnlp2Package.getValidFileArgument(string, "output dir", false)).endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((file = new File(string)).isDirectory()) {
            if (!file.canWrite()) {
                throw new IllegalArgumentException("The given package path is not writable: " + file);
            }
        } else {
            throw new IllegalArgumentException("The given output dir is not valid: " + file);
        }
        jnlpPackageInfo.setOutputDirPath(string);
    }

    public static void generatePackage(String[] stringArray) throws IOException {
        boolean bl = false;
        Object var2_2 = null;
        JnlpPackageInfo jnlpPackageInfo = null;
        jnlpPackageInfo = Jnlp2Package.parseArguments(stringArray);
        PackageGenerator packageGenerator = PackageGeneratorFactory.newInstance();
        packageGenerator.generatePackage(jnlpPackageInfo);
    }
}

