/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import com.sun.deploy.xml.XMLEncoding;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JDICPackagerFileRefVisitor;
import org.jdesktop.jdic.packager.impl.JDICPackagerInfoElementVisitor;
import org.jdesktop.jdic.packager.impl.JnlpConstants;

public final class JnlpPackageInfo {
    private static String osName = System.getProperty("os.name").toLowerCase();
    private String[] titles = new String[JnlpConstants.LOCALES.length];
    private String[] vendors = new String[JnlpConstants.LOCALES.length];
    private String[] licenses = new String[JnlpConstants.LOCALES.length];
    private String[] descriptions = new String[JnlpConstants.LOCALES.length];
    private String licenseDirPath;
    private String uniqueTmpDirPath = null;
    private String packageName;
    private String outputDirPath;
    private String jnlpFileHref;
    private String jnlpFilePath;
    private String resourceDirPath;
    private String version;
    private String release;
    private List jnlpRefFilePaths = new ArrayList();
    private String bannerJpgFilePath = null;
    private String panelJpgFilePath = null;
    private String msSDKDirPath;
    private String rawMsiFilePath;
    private boolean enableLocalization = false;
    private boolean enableLicense;
    private boolean shortcutEnabled;
    private boolean enableAssociation;
    private boolean enableSystemCache;

    public String getBannerJpgFilePath() {
        return this.bannerJpgFilePath;
    }

    public void setBannerJpgFilePath(String string) {
        this.bannerJpgFilePath = string;
    }

    public String getPanelJpgFilePath() {
        return this.panelJpgFilePath;
    }

    public void setPanelJpgFilePath(String string) {
        this.panelJpgFilePath = string;
    }

    public String getMSSDKDirPath() {
        return this.msSDKDirPath;
    }

    public void setMSSDKDirPath(String string) {
        this.msSDKDirPath = string;
    }

    public String getRawMsiFilePath() {
        return this.rawMsiFilePath;
    }

    public void setRawMsiFilePath(String string) {
        this.rawMsiFilePath = string;
    }

    public boolean getSystemCacheEnabled() {
        return this.enableSystemCache;
    }

    public void setSystemCacheEnabled(boolean bl) {
        this.enableSystemCache = bl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getOutputDirPath() {
        return this.outputDirPath;
    }

    public void setOutputDirPath(String string) {
        this.outputDirPath = string;
    }

    public String getJnlpFileHref() {
        return this.jnlpFileHref;
    }

    public void setJnlpFileHref(String string) {
        this.jnlpFileHref = string;
    }

    public String getJnlpFilePath() {
        return this.jnlpFilePath;
    }

    public void setJnlpFilePath(String string) {
        this.jnlpFilePath = string;
    }

    public String getJnlpFileName() {
        return new File(this.jnlpFilePath).getName();
    }

    public String getResourceDirPath() {
        return this.resourceDirPath;
    }

    public void setResourcePath(String string) {
        this.resourceDirPath = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        if (osName.startsWith("windows")) {
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error: Illegal Version Number (Valid input: digits & '.')");
            }
        }
        this.version = string;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String string) {
        if (osName.startsWith("windows")) {
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error: Illegal Release Number (Valid input: digits & '.')");
            }
        }
        this.release = string;
    }

    public Iterator getJnlpRefFilePaths() {
        return this.jnlpRefFilePaths.iterator();
    }

    public boolean getShortcutEnabled() {
        return this.shortcutEnabled;
    }

    public void setShortcutEnabled(boolean bl) {
        this.shortcutEnabled = bl;
    }

    public boolean getAssociationEnabled() {
        return this.enableAssociation;
    }

    public void setAssociationEnabled(boolean bl) {
        this.enableAssociation = bl;
    }

    public boolean getLocalizationEnabled() {
        return this.enableLocalization;
    }

    public void setGlocalizationEnabled(boolean bl) {
        this.enableLocalization = bl;
    }

    public String getLicenseDirPath() {
        return this.licenseDirPath;
    }

    public void setLicenseDirPath(String string) {
        this.licenseDirPath = string;
    }

    public void setShowLicense(boolean bl) {
        this.enableLicense = bl;
    }

    public boolean getShowLicense() {
        return this.enableLicense;
    }

    public String getUniqueTmpDirPath() throws IOException {
        if (this.uniqueTmpDirPath == null) {
            this.uniqueTmpDirPath = FileOperUtility.createUniqueTmpDir();
        }
        return this.uniqueTmpDirPath;
    }

    public String getLocalizedJnlpInfo(String string, String string2) {
        int n = this.getLocaleIndex(string);
        String string3 = null;
        if (string2.compareToIgnoreCase("title") == 0) {
            string3 = this.titles[n];
        } else if (string2.compareToIgnoreCase("vendor") == 0) {
            string3 = this.vendors[n];
        } else if (string2.compareToIgnoreCase("license") == 0) {
            string3 = this.licenses[n];
        } else if (string2.compareToIgnoreCase("description") == 0) {
            string3 = this.descriptions[n];
        }
        return string3;
    }

    protected int getLocaleIndex(String string) {
        int n = -1;
        for (int i = 0; i < JnlpConstants.LOCALES.length; ++i) {
            if (string.compareToIgnoreCase(JnlpConstants.LOCALES[i]) != 0) continue;
            n = i;
            break;
        }
        return n;
    }

    public void parseRemoteJnlpInfo(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("url is null when trying to parse JnlpInfo");
        }
        String string = FileOperUtility.createUniqueTmpDir();
        URL uRL2 = FileOperUtility.getRemoteResource(uRL, string);
        this.setResourcePath(string);
        this.parseLocalJnlpInfo(uRL2);
    }

    public void addJnlpRefFilePath(URL uRL, URL uRL2) throws IOException {
        String string = FileOperUtility.getRelativePath(uRL.toString(), uRL2.toString());
        this.jnlpRefFilePaths.add(string);
    }

    public void parseLocalJnlpInfo(URL uRL) throws IOException {
        URL uRL2 = null;
        if (uRL == null) {
            throw new IOException("url is null when trying to parse JnlpInfo");
        }
        if (this.resourceDirPath == null || this.resourceDirPath.length() <= 0) {
            throw new IOException("resourcePath have not been set");
        }
        try {
            File file = new File(uRL.toURI());
            this.setJnlpFilePath(file.getPath());
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor((URL)uRL);
            uRL2 = launchDesc.getCodebase();
            this.setJnlpFileHref(launchDesc.getCanonicalHome().toString());
            InformationDesc informationDesc = launchDesc.getInformation();
            this.setTitle(0, informationDesc.getTitle());
            this.setVendor(0, informationDesc.getVendor());
            this.setDescription(0, informationDesc.getDescription(0));
            this.addJnlpRefFilePaths(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addJnlpRefFilePaths(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("url is null when trying to parse JnlpInfo");
        }
        if (this.resourceDirPath == null || this.resourceDirPath.length() <= 0) {
            throw new IOException("resourcePath have not been set");
        }
        try {
            File file = new File(uRL.toURI());
            this.jnlpRefFilePaths.add(file.getAbsolutePath());
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor((URL)uRL);
            URL uRL2 = launchDesc.getCodebase();
            InformationDesc informationDesc = launchDesc.getInformation();
            IconDesc[] iconDescArray = informationDesc.getIcons();
            for (int i = 0; i < iconDescArray.length; ++i) {
                URL uRL3 = iconDescArray[i].getLocation();
                this.addJnlpRefFilePath(uRL3, uRL2);
            }
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            resourcesDesc.visit((ResourceVisitor)new JDICPackagerFileRefVisitor(uRL2, this.resourceDirPath, this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTitle(int n, String string) {
        this.titles[n] = string;
    }

    public void setVendor(int n, String string) {
        this.vendors[n] = string;
    }

    public void setDescription(int n, String string) {
        this.descriptions[n] = string;
    }

    public void setLicense(int n, String string) {
        this.licenses[n] = string;
    }

    public void setLocalizedInformation() throws IOException {
        byte[] byArray;
        File file = null;
        file = new File(this.getJnlpFilePath());
        if (file == null) {
            throw new IOException("Cannot find local jnlp file: " + file.getPath());
        }
        try {
            byArray = LaunchDescFactory.readBytes((InputStream)new FileInputStream(file), (long)file.length());
        }
        catch (Exception exception) {
            throw new IOException("Exception when build localized InfoDesc " + exception.getMessage());
        }
        this.setLocalizedInformation(byArray);
        for (int i = 0; i < JnlpConstants.LOCALES.length; ++i) {
            if (this.titles[i] == null || this.titles[i].length() == 0) {
                this.titles[i] = this.titles[0];
            }
            if (this.vendors[i] == null || this.vendors[i].length() == 0) {
                this.vendors[i] = this.vendors[0];
            }
            if (this.descriptions[i] != null && this.descriptions[i].length() != 0) continue;
            this.descriptions[i] = this.descriptions[0];
        }
    }

    private void setLocalizedInformation(byte[] byArray) throws IOException {
        XMLNode xMLNode;
        String string;
        try {
            string = XMLEncoding.decodeXML((byte[])byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception determining encoding of jnlp file: " + exception.getMessage());
        }
        try {
            xMLNode = new XMLParser(string).parse();
        }
        catch (Exception exception) {
            throw new IOException("exception parsing jnlp file " + exception.getMessage());
        }
        try {
            XMLUtils.visitElements((XMLNode)xMLNode, (String)"<information>", (XMLUtils.ElementVisitor)new JDICPackagerInfoElementVisitor(this));
        }
        catch (Exception exception) {
            throw new IOException("exception creating InformationDesc " + exception.getMessage());
        }
    }
}

