/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import com.sun.deploy.net.proxy.DeployProxySelector;
import com.sun.deploy.net.proxy.StaticProxyManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.StringTokenizer;
import org.jdesktop.jdic.packager.impl.JDICPackagerResourceCopyVisitor;

public class FileOperUtility {
    public static void urlFile2LocalFile(URL uRL, URL uRL2, String string) throws IOException {
        if (uRL == null || uRL.getFile() == null || uRL.getFile().length() <= 0) {
            return;
        }
        String string2 = FileOperUtility.getRelativePath(uRL.toString(), uRL2.toString());
        File file = new File(string + File.separator + string2);
        FileOperUtility.copyRemoteFile(uRL, file);
    }

    private static void createLocalFile(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            try {
                if (!file.getParentFile().mkdirs()) {
                    throw new IOException("Cannot make parent directory when trying to create local file");
                }
            }
            catch (Exception exception) {
                throw new IOException("Cannot make parent directory when trying to create local file: " + exception.getMessage());
            }
        }
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    throw new IOException("Cannot delete original file when trying to create local file");
                }
            }
            catch (Exception exception) {
                throw new IOException("Cannot delete original file when trying to create local file: " + exception.getMessage());
            }
        }
        try {
            if (!file.createNewFile()) {
                throw new IOException("Cannot create new local file");
            }
        }
        catch (Exception exception) {
            throw new IOException("Cannot create new local file: " + exception.getMessage());
        }
    }

    private static void copyRemoteFile(URL uRL, File file) throws IOException {
        if (uRL == null || file == null) {
            return;
        }
        if (uRL.getFile() == "" || uRL.getFile() == null) {
            return;
        }
        if (file.isDirectory()) {
            file = new File(file.getPath() + File.separator + uRL.getFile());
        }
        if (!file.exists()) {
            FileOperUtility.createLocalFile(file);
        }
        DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        FileOperUtility.copyStream(dataInputStream, dataOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        try {
            byte[] byArray;
            while ((n = inputStream.read(byArray = new byte[512], 0, 512)) > 0) {
                outputStream.write(byArray, 0, n);
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static String getRelativePath(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.lastIndexOf(string2) < 0) {
            int n = string.lastIndexOf("/");
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        String string3 = string.substring(string.lastIndexOf(string2) + string2.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/", false);
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            if (string4.length() == 0) {
                string4 = stringTokenizer.nextToken();
                continue;
            }
            string4 = string4 + File.separator + stringTokenizer.nextToken();
        }
        return string4;
    }

    public static void copyLocalFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return;
        }
        if (file2.exists() && file.getPath().equals(file2.getPath())) {
            return;
        }
        if (file.isFile()) {
            if (file2.isDirectory()) {
                file2 = new File(file2.getPath() + File.separator + file.getName());
            }
            FileOperUtility.createLocalFile(file2);
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
            FileOperUtility.copyStream(dataInputStream, dataOutputStream);
        } else if (file.isDirectory()) {
            if (file2.exists() && !file2.isDirectory()) {
                throw new IOException("cannot copy directory because there is a file with the same name in destination: " + file2.getPath());
            }
            try {
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IOException("cannot create local directory: " + file2.getPath());
                }
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].getPath().equals(file2.getPath())) {
                        return;
                    }
                    String string3 = string2 + File.separator + FileOperUtility.getRelativePath(fileArray[i].getCanonicalPath(), file.getCanonicalPath());
                    FileOperUtility.copyLocalFile(fileArray[i].getCanonicalPath(), string3);
                }
            }
            catch (Exception exception) {
                throw new IOException("Cannot copy local directory: " + exception.getMessage());
            }
        }
    }

    public static void deleteDirTree(File file) throws IOException {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        try {
            if (fileArray == null) {
                if (!file.delete()) {
                    throw new IOException("Cannot delete directory: " + file.getPath());
                }
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isFile()) {
                    if (fileArray[i].delete()) continue;
                    throw new IOException("Cannot delete file: " + fileArray[i].getPath());
                }
                if (!fileArray[i].isDirectory()) continue;
                FileOperUtility.deleteDirTree(fileArray[i]);
            }
        }
        catch (Exception exception) {
            throw new IOException("Failed to delete directory: " + exception.getMessage());
        }
    }

    public static String createUniqueTmpDir() throws IOException {
        String string = null;
        try {
            File file = new File(System.getProperty("java.io.tmpdir"));
            File file2 = File.createTempFile("jnlp", "jnlp", file);
            string = file2.getPath();
            file2.delete();
            file2 = new File(string);
            file2.mkdirs();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create a local temp directory: " + string);
        }
        return string + File.separator;
    }

    protected static URL getRemoteResource(URL uRL, String string) throws IOException {
        URL uRL2 = null;
        URL uRL3 = null;
        try {
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor((URL)uRL);
            uRL3 = launchDesc.getCodebase();
            String string2 = uRL.getFile().substring(uRL.getFile().lastIndexOf("/") + 1);
            File file = new File(string + File.separator + string2);
            FileOperUtility.copyRemoteFile(uRL, file);
            if (file == null || !file.exists()) {
                throw new IOException("Cannot copy remote jnlp file to local");
            }
            uRL2 = file.toURL();
            InformationDesc informationDesc = launchDesc.getInformation();
            IconDesc[] iconDescArray = informationDesc.getIcons();
            for (int i = 0; i < iconDescArray.length; ++i) {
                URL uRL4 = iconDescArray[i].getLocation();
                FileOperUtility.urlFile2LocalFile(uRL4, uRL3, string);
            }
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            resourcesDesc.visit((ResourceVisitor)new JDICPackagerResourceCopyVisitor(uRL3, string));
        }
        catch (Exception exception) {
            throw new IOException("Exception when geting remote resource: " + exception.getMessage());
        }
        return uRL2;
    }

    public static boolean isDirectoryReadable(File file) {
        return file.isDirectory() && file.canRead();
    }

    public static boolean isDirectoryWritable(File file) {
        return file.isDirectory() && file.canWrite();
    }

    public static boolean isFileReadable(File file) {
        return file.isFile() && file.canRead();
    }

    public static String getFileNameWithoutExt(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getName();
        if (string == null) {
            return null;
        }
        return string.substring(0, string.lastIndexOf("."));
    }

    static {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            ServiceManager.setService((int)33024);
        } else {
            ServiceManager.setService((int)36864);
        }
        try {
            DeployProxySelector.reset();
        }
        catch (Throwable throwable) {
            StaticProxyManager.reset();
        }
    }
}

