/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import sun.awt.image.IntegerComponentRaster;

public class WinTrayIconService
implements TrayIconService {
    private JPopupMenu menu;
    private Icon icon;
    private boolean autoSize;
    private byte[] caption = "JDIC TrayIcon".getBytes();
    private long hicon;
    private Image oldIconImage;
    private static HashMap map = new HashMap();
    private LinkedList actionList = new LinkedList();
    private LinkedList balloonListeners = new LinkedList();
    static int noIcons;
    int iconID = noIcons++;
    AnimationObserver observer;
    private final int WINDOWS_TASKBAR_ICON_WIDTH = 16;
    private final int WINDOWS_TASKBAR_ICON_HEIGHT = 16;
    static PopupParent popupParentFrame;
    boolean created;

    public static void removeAllIcons() {
        for (int i = 0; i < noIcons; ++i) {
            WinTrayIconService.removeIcon(i);
        }
    }

    public WinTrayIconService() {
        if (popupParentFrame == null) {
            popupParentFrame = new PopupParent();
            popupParentFrame.pack();
        }
    }

    private native long createIconIndirect(int[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private native void createIcon(long var1, int var3, byte[] var4);

    private native void updateNativeIcon(long var1, int var3, byte[] var4);

    private native void showBalloonMessage(long var1, int var3, byte[] var4, byte[] var5, int var6);

    private native void deleteHIcon(long var1);

    private native int[] getRectangleOnScreen(int var1);

    private static native void removeIcon(int var0);

    public void showBalloonMessage(String string, String string2, int n) {
        byte[] byArray = string == null ? new byte[]{} : string.getBytes();
        byte[] byArray2 = string2 == null ? new byte[]{} : string2.getBytes();
        this.showBalloonMessage(this.hicon, this.iconID, byArray, byArray2, n);
    }

    public void addNotify() {
        if (popupParentFrame == null) {
            popupParentFrame = new PopupParent();
            popupParentFrame.pack();
        }
        map.put(new Integer(this.iconID), this);
        this.observer = new AnimationObserver();
        this.updateIcon(null);
        this.created = true;
    }

    private void updateBufferedImage() {
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (this.menu != null) {
            this.menu.setLightWeightPopupEnabled(false);
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    popupParentFrame.setVisible(false);
                    popupParentFrame.toBack();
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            popupParentFrame.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                }

                public void windowLostFocus(WindowEvent windowEvent) {
                    WinTrayIconService.this.menu.setVisible(false);
                }
            });
        }
    }

    protected long createNativeIcon(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[n * n2 / 8];
        int n6 = nArray.length;
        for (n5 = 0; n5 < n6; ++n5) {
            int n7 = n5 / 8;
            int n8 = 1 << 7 - n5 % 8;
            if ((nArray[n5] & 0xFF000000) != 0 || n7 >= byArray.length) continue;
            int n9 = n7;
            byArray[n9] = (byte)(byArray[n9] | n8);
        }
        n5 = writableRaster.getWidth();
        if (writableRaster instanceof IntegerComponentRaster) {
            n5 = ((IntegerComponentRaster)writableRaster).getScanlineStride();
        }
        return this.createIconIndirect(((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), byArray, n5, writableRaster.getWidth(), writableRaster.getHeight(), n3, n4);
    }

    public void processEvent(int n, int n2, int n3) {
        switch (n) {
            case 512: {
                break;
            }
            case 514: {
                ListIterator listIterator = this.actionList.listIterator(0);
                while (listIterator.hasNext()) {
                    ActionListener actionListener = (ActionListener)listIterator.next();
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "PressAction", System.currentTimeMillis(), 0));
                }
                break;
            }
            case 517: {
                if (this.menu == null) break;
                Point point = new Point(n2, n3);
                Dimension dimension = this.menu.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                point.x = point.x + dimension.width > dimension2.width ? point.x - dimension.width : point.x;
                point.y = point.y + dimension.height > dimension2.height ? point.y - dimension.height : point.y;
                popupParentFrame.setVisible(true);
                this.menu.show(popupParentFrame.getContentPane(), point.x, point.y);
                popupParentFrame.toFront();
                break;
            }
            case 1029: {
                ListIterator listIterator = this.balloonListeners.listIterator(0);
                while (listIterator.hasNext()) {
                    ActionListener actionListener = (ActionListener)listIterator.next();
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "PressAction", System.currentTimeMillis(), 0));
                }
                break;
            }
        }
    }

    public static synchronized void notifyEvent(int n, final int n2, final int n3, final int n4) {
        final WinTrayIconService winTrayIconService = (WinTrayIconService)map.get(new Integer(n));
        if (winTrayIconService == null) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    winTrayIconService.processEvent(n2, n3, n4);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIcon(Image image) {
        if (this.icon != null) {
            Graphics2D graphics2D;
            if (image == null) {
                image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
                graphics2D = (Graphics2D)((BufferedImage)image).getGraphics();
                graphics2D.setComposite(AlphaComposite.Src);
                this.icon.paintIcon(this.observer, graphics2D, 0, 0);
                this.oldIconImage = image;
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage(image, 0, 0, 16, 16, null);
            }
            finally {
                graphics2D.dispose();
            }
            bufferedImage.flush();
            if (this.hicon != 0L) {
                this.deleteHIcon(this.hicon);
            }
            this.hicon = this.createNativeIcon(bufferedImage, 16, 16, 0, 0);
            if (this.created) {
                this.updateNativeIcon(this.hicon, this.iconID, this.caption);
            } else {
                this.createIcon(this.hicon, this.iconID, this.caption);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setCaption(String string) {
        this.caption = (string == null ? "" : string).getBytes();
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setIconAutoSize(boolean bl) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionList.remove(actionListener);
    }

    public Point getLocationOnScreen() {
        int[] nArray = this.getRectangleOnScreen(this.iconID);
        return new Point(nArray[0], nArray[1]);
    }

    void remove() {
        WinTrayIconService.removeIcon(this.iconID);
        if (this.hicon != 0L) {
            this.deleteHIcon(this.hicon);
        }
        map.remove(new Integer(this.iconID));
        this.created = false;
        if (map.size() == 0) {
            popupParentFrame.dispose();
            popupParentFrame = null;
        }
    }

    private static void restartTaskbar() {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            WinTrayIconService winTrayIconService = (WinTrayIconService)map.get(iterator.next());
            if (!winTrayIconService.created) continue;
            winTrayIconService.remove();
            winTrayIconService.addNotify();
        }
    }

    public void addBalloonActionListener(ActionListener actionListener) {
        this.balloonListeners.add(actionListener);
    }

    public void removeBalloonActionListener(ActionListener actionListener) {
        this.balloonListeners.remove(actionListener);
    }

    static {
        popupParentFrame = new PopupParent();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WinTrayIconService.removeAllIcons();
            }
        });
    }

    private class AnimationObserver
    extends Component {
        boolean update = true;

        private AnimationObserver() {
        }

        public void setUpdate(boolean bl) {
            this.update = bl;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (this.update && WinTrayIconService.this.created) {
                WinTrayIconService.this.updateIcon(image);
            }
            return this.update;
        }
    }

    static class PopupParent
    extends JDialog {
        public PopupParent() {
            super((Frame)null, "JDIC Tray Icon");
            try {
                Method method = this.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
                method.invoke((Object)this, Boolean.TRUE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.setUndecorated(true);
            this.setBounds(0, 0, 0, 0);
        }
    }
}

