/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;

class JDICPackagerFileRefVisitor
implements ResourceVisitor {
    private URL codebase = null;
    private String localBase = null;
    private JnlpPackageInfo pkgInfo = null;

    public JDICPackagerFileRefVisitor(URL uRL, String string, JnlpPackageInfo jnlpPackageInfo) {
        this.codebase = uRL;
        this.localBase = string;
        this.pkgInfo = jnlpPackageInfo;
    }

    public void visitJARDesc(JARDesc jARDesc) {
        try {
            this.pkgInfo.addJnlpRefFilePath(jARDesc.getLocation(), this.codebase);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void visitExtensionDesc(ExtensionDesc extensionDesc) {
        String string = FileOperUtility.getRelativePath(extensionDesc.getLocation().toString(), this.codebase.toString());
        File file = new File(this.pkgInfo.getResourceDirPath() + File.separator + string);
        try {
            this.pkgInfo.addJnlpRefFilePaths(file.toURL());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void visitPropertyDesc(PropertyDesc propertyDesc) {
    }

    public void visitJREDesc(JREDesc jREDesc) {
    }

    public void visitPackageDesc(PackageDesc packageDesc) {
    }
}

