/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    private boolean isBrowserNativeInitialized = false;
    boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    String libPathEnv = this.isWindows ? "PATH" : "LD_LIBRARY_PATH";
    String nativeLibPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        WebBrowserUtil.trace("init share native..... ");
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            String string = System.getProperty("javawebstart.version");
            if (string != null) {
                WebBrowserUtil.trace("Loaded by JavaWebStart,version is " + string);
                this.nativeLibPath = this.caculateNativeLibPathBySunJWS();
                return;
            }
            String string2 = new URL(JdicManager.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
            String string3 = new File(string2).getCanonicalPath();
            this.nativeLibPath = this.caculateNativeLibPath(string3);
            String string4 = this.nativeLibPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", string4);
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            if (field != null) {
                field.set(System.class.getClassLoader(), null);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isShareNativeInitialized = true;
    }

    private String caculateNativeLibPath(String string) throws MalformedURLException, JdicInitException {
        String string2 = string + File.separator + JdicManager.getPlatform();
        File file = new File(string2 + File.separator + "jdic_stub.jar");
        if (!file.exists()) {
            return string;
        }
        String string3 = string2 + File.separator + JdicManager.getArchitecture();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            String string4 = "We detect that you are not using java.net.URLClassLoader for cross platform versoin, you have to set jdic_stub.jar manually!";
            WebBrowserUtil.error(string4);
            return string3;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, file.toURL());
            return string3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new JdicInitException("Error, could not add URL to system classloader");
        }
    }

    private String caculateNativeLibPathBySunJWS() throws IOException, JdicInitException {
        String string = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof JNLPClassLoader)) {
            throw new JdicInitException("Unexpected ClassLoader for webstart, only com.sun.jnlp.JNLPClassLoader is supported.");
        }
        JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)classLoader;
        String string2 = jNLPClassLoader.findLibrary("jdic");
        string = new File(string2).getParentFile().getCanonicalPath();
        WebBrowserUtil.trace("running path " + this.nativeLibPath);
        this.isShareNativeInitialized = true;
        return string;
    }

    private static String getPlatform() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "windows";
        }
        return JdicManager.canonical(string);
    }

    private static String getArchitecture() {
        String string = System.getProperty("os.arch");
        if (string.endsWith("86")) {
            return "x86";
        }
        return JdicManager.canonical(string);
    }

    private static String canonical(String string) {
        WebBrowserUtil.trace("value:" + string);
        WebBrowserUtil.trace("canonical:" + string.toLowerCase().replaceAll("[\\\\/ ]", "_"));
        return string.toLowerCase().replaceAll("[\\\\/ ]", "_");
    }

    public void initBrowserNative() throws JdicInitException {
        if (this.isBrowserNativeInitialized) {
            return;
        }
        try {
            String string = this.getBinaryPath();
            InitUtility.preAppendEnv(this.libPathEnv, string);
            String string2 = WebBrowserUtil.getBrowserPath();
            if (string2 == null) {
                throw new JdicInitException("Can't locate the native browser path!");
            }
            if (WebBrowserUtil.isDefaultBrowserMozilla()) {
                Object object;
                String string3 = InitUtility.getEnv("MOZILLA_FIVE_HOME");
                if (string3 == null) {
                    object = new File(string2);
                    string3 = ((File)object).isDirectory() ? ((File)object).getCanonicalPath() : ((File)object).getCanonicalFile().getParent();
                }
                if (!this.isWindows) {
                    InitUtility.preAppendEnv("PATH", string);
                    object = WebBrowserUtil.getEmbedBinaryName();
                    Runtime.getRuntime().exec("chmod a+x " + string + File.separator + (String)object);
                } else {
                    object = string3 + File.separator + "xpcom.dll";
                    if (!new File((String)object).isFile()) {
                        String string4 = WebBrowserUtil.getMozillaGreHome();
                        if (string4 == null) {
                            throw new JdicInitException("Can't locate the GRE directory of the installed Mozilla binary: " + string3);
                        }
                        string3 = string4;
                    }
                }
                InitUtility.setEnv("MOZILLA_FIVE_HOME", string3);
                InitUtility.preAppendEnv(this.libPathEnv, string3);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isBrowserNativeInitialized = true;
    }

    public String getBinaryPath() {
        return this.nativeLibPath;
    }
}

