(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31851,        799]
NotebookOptionsPosition[     30054,        739]
NotebookOutlinePosition[     30398,        754]
CellTagsIndexPosition[     30355,        751]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Esquisse de programme d'apr\[EGrave]s [1] et [2]\
\>", "Section",
 CellChangeTimes->{{3.4326260719597006`*^9, 3.4326260845688334`*^9}, {
   3.4326261294429717`*^9, 3.432626135630353*^9}, {3.4326271885476365`*^9, 
   3.4326272035317235`*^9}, {3.4328857023773136`*^9, 3.4328857033617077`*^9}, 
   3.4328857497532234`*^9, {3.4347042406920853`*^9, 3.4347042463328915`*^9}, {
   3.4348782929117813`*^9, 3.4348782955681505`*^9}, {3.4361844763660116`*^9, 
   3.4361845036541157`*^9}, {3.4361845426725397`*^9, 3.436184555874962*^9}}],

Cell["\<\
Nous allons decomposer les trois rotations \[EAcute]l\[EAcute]mentaires:
Tout d'abord l'angle de precession not\[EAcute]e \[Psi]\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4365216919455576`*^9, 3.436521702996832*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"precession", "[", "\[Psi]", "]"}], ":=", 
  RowBox[{"Matrix", "[", 
   RowBox[{"precession", "[", "\[Psi]_", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"precession", "[", "\[Psi]_", "]"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Psi]", "]"}], ",", 
      RowBox[{"Sin", "[", "\[Psi]", "]"}], ",", "0"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Psi]", "]"}]}], ",", 
      RowBox[{"Cos", "[", "\[Psi]", "]"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "   "}]}], "Input",
 CellChangeTimes->{{3.436184586076276*^9, 3.436184654474737*^9}, {
  3.436184684846505*^9, 3.436184691010494*^9}, {3.4361855582564135`*^9, 
  3.436185575970061*^9}, {3.4361856441847844`*^9, 3.436185697809961*^9}, {
  3.4361865867402315`*^9, 3.4361865891620445`*^9}, {3.436501053309298*^9, 
  3.436501054340852*^9}, {3.436521634886937*^9, 3.4365216593048725`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matrix", "[", 
   RowBox[{"precession", "[", "0", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4361874217320404`*^9, 3.4361874221851625`*^9}, {
   3.436187455684948*^9, 3.4361874774660516`*^9}, 3.4365012578226137`*^9, {
   3.4365217324585543`*^9, 3.4365217423458786`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.4361874247476463`*^9, {3.4361874571849384`*^9, 3.436187480622261*^9}, 
   3.436187772649773*^9, 3.4365010582795105`*^9, 3.436501259463722*^9, {
   3.4365216466015387`*^9, 3.4365216649744396`*^9}, {3.4365217357877045`*^9, 
   3.436521743584923*^9}, 3.436522662830825*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4361866182862988`*^9, 3.4361866183019238`*^9}}],

Cell["Ensuite la nutation not\[EAcute]e \[Theta]", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.436185807527088*^9, 3.4361858187758636`*^9}, {
   3.4365216856877575`*^9, 3.436521689705265*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nutation", "[", "\[Theta]", "]"}], ":=", 
  RowBox[{"Matrix", "[", 
   RowBox[{"nutation", "[", "\[Theta]_", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"nutation", "[", "\[Theta]_", "]"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}], 
  "   "}]}], "Input",
 CellChangeTimes->{{3.4361848718489656`*^9, 3.436184899462221*^9}, {
   3.43618532207824*^9, 3.436185323748831*^9}, {3.436185616036643*^9, 
   3.436185640357762*^9}, {3.436186575006157*^9, 3.436186580006029*^9}, 
   3.4365010632497234`*^9, {3.436521673122095*^9, 3.4365216841483383`*^9}, {
   3.4365226492998886`*^9, 3.436522652394896*^9}}],

Cell["\<\

Enfin l'angle de  rotation propre not\[EAcute]e \[CurlyPhi]\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.4365217097177095`*^9, 3.436521718678879*^9}, 3.4365217687162476`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rotationpropre", "[", "\[CurlyPhi]", "]"}], ":=", 
  RowBox[{"Matrix", "[", 
   RowBox[{"rotationpropre", "[", "\[CurlyPhi]_", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"rotationpropre", "[", "\[CurlyPhi]_", "]"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], ",", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], ",", "0"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.4361852900247507`*^9, 3.4361853308839717`*^9}, {
   3.436185750127084*^9, 3.43618578798234*^9}, {3.436186560709648*^9, 
   3.436186564803293*^9}, 3.436501068344973*^9, {3.436521754310792*^9, 
   3.4365217960127716`*^9}}],

Cell["\<\

Nous allons maintenant d\[EAcute]finir, les angles nautiques. Tout d'abord la \
matrice de l'angle de tangage not\[EAcute]e \[Beta]\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.436501199399169*^9, 3.436501240598795*^9}, 3.4365012734991026`*^9, 
   3.4365217564259286`*^9, {3.4365218126460037`*^9, 3.4365218152867956`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"tangage", "[", "\[Beta]_", "]"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Beta]", "]"}], ",", "0", ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Beta]", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Beta]", "]"}], ",", "0", ",", 
      RowBox[{"Cos", "[", "\[Beta]", "]"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4361858481007977`*^9, 3.4361858511160946`*^9}, {
   3.4361859821807895`*^9, 3.4361860118808727`*^9}, {3.4361860618288827`*^9, 
   3.436186088123065*^9}, 3.4361866013804817`*^9, 3.4361867997663317`*^9, 
   3.4365010721898546`*^9, 3.436521772733755*^9}],

Cell["\<\
Ensuite la matrice de l'angle de roulis not\[EAcute]e \[Gamma]\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.436501199399169*^9, 3.436501240598795*^9}, {3.4365012734991026`*^9, 
   3.4365013042268963`*^9}, {3.4365218166259646`*^9, 3.436521820017692*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Matrix", "[", 
    RowBox[{"roulis", "[", "\[Gamma]_", "]"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Cos", "[", "\[Gamma]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Gamma]", "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        RowBox[{"Sin", "[", "\[Gamma]", "]"}]}], ",", 
       RowBox[{"Cos", "[", "\[Gamma]", "]"}]}], "}"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.4361867607983294`*^9, 3.4361869466554856`*^9}, 
   3.436501075456441*^9, 3.4365012860965605`*^9, {3.4365234752789636`*^9, 
   3.436523478121203*^9}, {3.4365236028788023`*^9, 3.4365236082061768`*^9}}],

Cell["\<\
Enfin la  matrice de l'angle de lacet not\[EAcute]e \[Alpha]\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.436501199399169*^9, 3.436501240598795*^9}, 3.4365012734991026`*^9, {
   3.436501308884517*^9, 3.4365013158709483`*^9}, {3.4365218212191896`*^9, 
   3.4365218392009683`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"lacet", "[", "\[Alpha]_", "]"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", 
      RowBox[{"Sin", "[", "\[Alpha]", "]"}], ",", "0"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
      RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.43618695945236*^9, 3.4361870111554856`*^9}, 
   3.4365010793482113`*^9, 3.4365218427113237`*^9}],

Cell["\<\
Nous allons cr\[EAcute]er la matrice de rotation des angles d'Euler en \
multiplaint les trois matrices d\[EAcute]finissant les angles d'Euler\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.436501199399169*^9, 3.436501240598795*^9}, 3.4365012734991026`*^9, {
   3.436501308884517*^9, 3.4365013158709483`*^9}, {3.4365218212191896`*^9, 
   3.43652186161212*^9}, {3.43652189375653*^9, 3.436521924595435*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"euler", "[", 
    RowBox[{"{", 
     RowBox[{"\[Psi]", ",", "\[Theta]", ",", "\[CurlyPhi]"}], "}"}], "]"}], ":=",
    
   RowBox[{"Matrix", "[", 
    RowBox[{"euler", 
     RowBox[{"{", 
      RowBox[{"\[Psi]_", ",", "\[Theta]_", ",", "\[CurlyPhi]_"}], "}"}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"euler", 
    RowBox[{"{", 
     RowBox[{"\[Psi]_", ",", "\[Theta]_", ",", "\[CurlyPhi]_"}], "}"}]}], 
   "]"}], ":=", 
  RowBox[{
   RowBox[{"Matrix", "[", 
    RowBox[{"precession", "[", "\[Psi]", "]"}], "]"}], ".", 
   RowBox[{"Matrix", "[", 
    RowBox[{"nutation", "[", "\[Theta]", "]"}], "]"}], ".", 
   RowBox[{"Matrix", "[", 
    RowBox[{"rotationpropre", "[", "\[CurlyPhi]", "]"}], 
    "]"}]}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4361870259679856`*^9, 3.43618716088986*^9}, {
  3.4361875267779207`*^9, 3.436187556183794*^9}, {3.436187614636171*^9, 
  3.4361877004163227`*^9}, {3.436521933037695*^9, 3.43652201899788*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matrix", "[", 
   RowBox[{"euler", 
    RowBox[{"{", 
     RowBox[{"\[Psi]_", ",", "\[Theta]_", ",", "\[CurlyPhi]_"}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.436187733009656*^9, 3.4361877334002757`*^9}, {
  3.436522128171213*^9, 3.4365221697732124`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "\[Theta]_", "]"}]}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Theta]_", "]"}]}]},
     {
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}]}], " ", 
       RowBox[{"Sin", "[", "\[Theta]_", "]"}]}], 
      RowBox[{"Cos", "[", "\[Theta]_", "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.4361877356658716`*^9, 3.436187785321486*^9, 3.436187939741888*^9, 
   3.436501086303384*^9, {3.436521997863221*^9, 3.436522026758376*^9}, 
   3.4365220657784405`*^9, {3.4365221340469437`*^9, 3.4365221714324217`*^9}, 
   3.4365229682149057`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"precession", "[", "\[Psi]", "]"}], ".", 
   RowBox[{"nutation", "[", "\[Theta]", "]"}], ".", 
   RowBox[{"rotationpropre", "[", "\[CurlyPhi]", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4365233953683095`*^9, 3.4365234538840847`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "\[Theta]_", "]"}]}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[Psi]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Psi]_", "]"}]}]}], 
      RowBox[{
       RowBox[{"Cos", "[", "\[Psi]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Theta]_", "]"}]}]},
     {
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]_", "]"}], " ", 
       RowBox[{"Sin", "[", "\[CurlyPhi]_", "]"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[CurlyPhi]_", "]"}]}], " ", 
       RowBox[{"Sin", "[", "\[Theta]_", "]"}]}], 
      RowBox[{"Cos", "[", "\[Theta]_", "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.43652348603887*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matrix", "[", 
   RowBox[{"euler", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4365246705490274`*^9, 3.4365246737210445`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"Matrix", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.4365246747835917`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.43618775066568*^9, 3.4361877536500163`*^9}, {
  3.4361878206960335`*^9, 3.436187833024*^9}, {3.436188019929388*^9, 
  3.436188112523138*^9}, {3.436188155179388*^9, 3.436188161976263*^9}, {
  3.4365010918987803`*^9, 3.436501117640732*^9}, {3.436522092657317*^9, 
  3.4365221126446714`*^9}, {3.43652219128204*^9, 3.436522192895582*^9}, {
  3.43652222571443*^9, 3.436522234238806*^9}, {3.4365235315919657`*^9, 
  3.4365235796945667`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4365239060605965`*^9, 3.4365239060917997`*^9}}],

Cell["\<\
Nous allons cr\[EAcute]er la matrice de rotation des angles nautiques en \
multipliant les trois matrices\
\>", "Text",
 CellChangeTimes->{
  3.432627212265931*^9, {3.43262765084934*^9, 3.432627812189992*^9}, {
   3.432628127777683*^9, 3.43262814040244*^9}, {3.4331436459384165`*^9, 
   3.4331438046249013`*^9}, {3.434703865164444*^9, 3.4347038744459915`*^9}, {
   3.4347043016002846`*^9, 3.4347043043191214`*^9}, {3.4347052594278092`*^9, 
   3.434705273459508*^9}, {3.4347053966822014`*^9, 3.4347055388273745`*^9}, {
   3.4347058046796317`*^9, 3.434705805039018*^9}, {3.434878373899785*^9, 
   3.4348784917900763`*^9}, {3.434878523258625*^9, 3.4348785438834925`*^9}, {
   3.4348785985862675`*^9, 3.4348786084455795`*^9}, {3.4348786462890873`*^9, 
   3.4348786468672085`*^9}, {3.434887246780859*^9, 3.4348872644994955`*^9}, {
   3.436184564304677*^9, 3.436184578514325*^9}, {3.436184806867799*^9, 
   3.436184818930724*^9}, {3.4361858220098867`*^9, 3.4361858281654673`*^9}, {
   3.436501199399169*^9, 3.436501240598795*^9}, 3.4365012734991026`*^9, {
   3.436501308884517*^9, 3.4365013158709483`*^9}, {3.4365218212191896`*^9, 
   3.43652186161212*^9}, {3.43652189375653*^9, 3.436521924595435*^9}, {
   3.4365227264262238`*^9, 3.436522754965612*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Matrix", "[", 
   RowBox[{"nautique", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], "]"}],
   ":=", 
  RowBox[{
   RowBox[{"Matrix", "[", 
    RowBox[{"lacet", "[", "\[Alpha]", "]"}], "]"}], ".", 
   RowBox[{"Matrix", "[", 
    RowBox[{"tangage", "[", "\[Beta]", "]"}], "]"}], ".", 
   RowBox[{"Matrix", "[", 
    RowBox[{"roulis", "[", "\[Gamma]", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.43618775066568*^9, 3.4361877536500163`*^9}, {
  3.4361878206960335`*^9, 3.436187833024*^9}, {3.436188019929388*^9, 
  3.436188112523138*^9}, {3.436188155179388*^9, 3.436188161976263*^9}, {
  3.4365010918987803`*^9, 3.436501117640732*^9}, {3.436522092657317*^9, 
  3.4365221126446714`*^9}, {3.43652219128204*^9, 3.436522192895582*^9}, {
  3.43652222571443*^9, 3.436522234238806*^9}, {3.4365227642661867`*^9, 
  3.436522781234291*^9}, {3.4365228426678514`*^9, 3.436522922788288*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matrix", "[", 
   RowBox[{"nautique", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.4365229314617767`*^9, 3.43652294291203*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"Cos", "[", "\[Alpha]_", "]"}], " ", 
       RowBox[{"Cos", "[", "\[Beta]_", "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Gamma]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Alpha]_", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Beta]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Gamma]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "\[Alpha]_", "]"}]}], " ", 
        RowBox[{"Cos", "[", "\[Gamma]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Beta]_", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Gamma]_", "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[Beta]_", "]"}]}], " ", 
       RowBox[{"Sin", "[", "\[Alpha]_", "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Cos", "[", "\[Gamma]_", "]"}]}], "-", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Beta]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Gamma]_", "]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Gamma]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Beta]_", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Alpha]_", "]"}], " ", 
        RowBox[{"Sin", "[", "\[Gamma]_", "]"}]}]}]},
     {
      RowBox[{"Sin", "[", "\[Beta]_", "]"}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[Beta]_", "]"}]}], " ", 
       RowBox[{"Sin", "[", "\[Gamma]_", "]"}]}], 
      RowBox[{
       RowBox[{"Cos", "[", "\[Beta]_", "]"}], " ", 
       RowBox[{"Cos", "[", "\[Gamma]_", "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.436522944160014*^9, 3.436522973596837*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matrix", "[", 
   RowBox[{"nautique", 
    RowBox[{"{", 
     RowBox[{"\[Pi]", ",", "\[Pi]", ",", "\[Pi]"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4365230035640526`*^9, 3.436523052687823*^9}, {
  3.436523188265684*^9, 3.436523221070321*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.4365230320180874`*^9, 3.4365230540138054`*^9}, {
  3.4365231968800526`*^9, 3.436523222850625*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4365229840019035`*^9, 3.436522986763068*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4361848250267267`*^9, 3.436184826320763*^9}}]
}, Open  ]]
},
WindowSize->{616, 750},
WindowMargins->{{18, Automatic}, {Automatic, 23}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 535, 8, 71, "Section"],
Cell[1128, 33, 1005, 15, 47, "Text"],
Cell[2136, 50, 1098, 26, 72, "Input"],
Cell[CellGroupData[{
Cell[3259, 80, 334, 6, 31, "Input"],
Cell[3596, 88, 910, 23, 58, "Output"]
}, Open  ]],
Cell[4521, 114, 96, 1, 31, "Input"],
Cell[4620, 117, 963, 13, 29, "Text"],
Cell[5586, 132, 1086, 27, 72, "Input"],
Cell[6675, 161, 1015, 16, 47, "Text"],
Cell[7693, 179, 1017, 25, 72, "Input"],
Cell[8713, 206, 1163, 18, 47, "Text"],
Cell[9879, 226, 827, 20, 52, "Input"],
Cell[10709, 248, 1093, 16, 29, "Text"],
Cell[11805, 266, 830, 20, 72, "Input"],
Cell[12638, 288, 1119, 17, 29, "Text"],
Cell[13760, 307, 675, 18, 52, "Input"],
Cell[14438, 327, 1243, 18, 47, "Text"],
Cell[15684, 347, 1074, 28, 112, "Input"],
Cell[CellGroupData[{
Cell[16783, 379, 328, 8, 31, "Input"],
Cell[17114, 389, 2689, 70, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19840, 464, 304, 6, 31, "Input"],
Cell[20147, 472, 2461, 66, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22645, 543, 250, 6, 31, "Input"],
Cell[22898, 551, 226, 7, 44, "Output"]
}, Open  ]],
Cell[23139, 561, 484, 7, 31, "Input"],
Cell[23626, 570, 96, 1, 31, InheritFromParent],
Cell[23725, 573, 1258, 19, 29, "Text"],
Cell[24986, 594, 960, 20, 52, "Input"],
Cell[CellGroupData[{
Cell[25971, 618, 276, 7, 31, "Input"],
Cell[26250, 627, 2491, 67, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28778, 699, 315, 8, 31, "Input"],
Cell[29096, 709, 736, 20, 58, "Output"]
}, Open  ]],
Cell[29847, 732, 94, 1, 31, "Input"],
Cell[29944, 735, 94, 1, 31, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
