//---------------------------------------------------------------------------
#define INITGUID // <- important !
#include <windows.h>
#include <stdlib.h>

#include <vcl.h>
#pragma hdrstop
#include <setupapi.h>


/* This define is required so that the GUID_DEVINTERFACE_USBPRINT variable is
 * declared an initialised as a static locally, since windows does not include it in any
 * of its libraries
 */
#include "TestMarchepas.h"
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void MyFct(void)
{
/*Pour crire le GUID il faut chercher dans le cd de drivers du priphrique,
ici "parppl.inf:
    [version]
    signature="$CHICAGO$"
    Class=Ports
    ClassGUID={4d36e978-e325-11ce-bfc1-08002be10318}
Ensuite il suffit d'identifier le code et l'crire sous cette forme:
GUID GUID_de_Nom =
{ 0x4d36e978, 0xe325, 0x11ce, { 0xbf, 0xc1, 0x08, 0x00, 0x2b, 0xe1, 0x03, 0x18 } };
*/

GUID GUID_DEVINTERFACE_USB_DEVICE =
{ 0x4d36e978, 0xe325, 0x11ce, { 0xbf, 0xc1, 0x08, 0x00, 0x2b, 0xe1, 0x03, 0x18 } };

LPGUID  pGuid = (LPGUID)&GUID_DEVINTERFACE_USB_DEVICE;

int l_driveSignature = 0;
int s_errorStatus = 0;
bool endFlag = false;

HDEVINFO hDevInfo  = SetupDiGetClassDevs( pGuid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);

 	if(INVALID_HANDLE_VALUE == hDevInfo)
	{
		endFlag = true;
		s_errorStatus = 2; // no device found [invalid device handler]
	}


	PSP_DEVICE_INTERFACE_DATA DevInfoData = (PSP_DEVICE_INTERFACE_DATA)malloc(sizeof(SP_DEVICE_INTERFACE_DATA));
	DevInfoData->cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

	short i = 0;

	while(!endFlag)
	{
    Form1->Memo1->Lines->Add("endFlag");

		if(SetupDiEnumDeviceInterfaces(hDevInfo, NULL, pGuid, i++,DevInfoData))
		{
            Form1->Memo1->Lines->Add("SetupDiEnumDeviceInterfaces");
            LPVOID lpMsgBuf;
            FormatMessage(  FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                            NULL,
                            GetLastError(),
                            MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
                            (LPTSTR) &lpMsgBuf,
                            0,
                            NULL
                        );

            // Display the string.
            MessageBox( NULL, (char*)lpMsgBuf, "GetLastError", MB_OK|MB_ICONINFORMATION );
            // Free the buffer.
            LocalFree( lpMsgBuf );

			ULONG requiredLength = 0;

			SetupDiGetInterfaceDeviceDetail (hDevInfo, DevInfoData, NULL, 0, &requiredLength, NULL);
                Form1->Memo1->Lines->Add("GetLastError1: "+ String(GetLastError()));
                Form1->Memo1->Lines->Add("DevInfoData->cbSize: "+ String(DevInfoData->cbSize));

			PSP_DEVICE_INTERFACE_DETAIL_DATA DevInfoDetail =
			(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(requiredLength);

			DevInfoDetail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

            SP_DEVINFO_DATA dd = {sizeof(SP_DEVINFO_DATA)};
			SetupDiGetInterfaceDeviceDetail(hDevInfo, DevInfoData, DevInfoDetail, requiredLength, &requiredLength, &dd);
                Form1->Memo1->Lines->Add("GetLastError2: "+ String(GetLastError()));
        		Form1->Memo1->Lines->Add("DevInfoData->cbSize: "+ String(DevInfoData->cbSize));
        		Form1->Memo1->Lines->Add("DevInfoDetail->cbSize: "+ String(DevInfoDetail->cbSize));
        		Form1->Memo1->Lines->Add("requiredLength: "+ String(requiredLength));

                Form1->Memo1->Lines->Add(DevInfoDetail->DevicePath);

                Form1->Memo1->Lines->Add("------------------------------------------------------");

			free(DevInfoDetail);
		}
		else
		{
			if(ERROR_NO_MORE_ITEMS == GetLastError())
			{
					endFlag = true;
			}
		}
	}
	if(!l_driveSignature)
	{
		s_errorStatus = 4; // no key inserted
	}

}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
MyFct();
}
//---------------------------------------------------------------------------
