
#include <windows.h>

// HID specific...
#define VENDOR_ID        1240
#define PRODUCT_ID       0005
#define BUFFER_IN_SIZE   64
#define BUFFER_OUT_SIZE  64
typedef char HIDBufferIn  [BUFFER_IN_SIZE];
typedef char HIDBufferOut [BUFFER_OUT_SIZE];

// HID events...
#define WM_HID_EVENT     WM_APP + 200
#define NOTIFY_PLUGGED   0x0001
#define NOTIFY_UNPLUGGED 0x0002
#define NOTIFY_CHANGED   0x0003
#define NOTIFY_READ      0x0004

// HID interface...
typedef BOOL (WINAPI *CONNECT) (HWND pHostWin);
typedef BOOL (WINAPI *DISCONNECT) ();
typedef UINT (WINAPI *GET_ITEM) (UINT);
typedef UINT (WINAPI *GET_ITEM_COUNT) ();
typedef BOOL (WINAPI *READ) (UINT, LPVOID);
typedef BOOL (WINAPI *WRITE) (UINT, LPVOID);
typedef BOOL (WINAPI *READ_EX) (UINT, UINT, LPVOID);
typedef BOOL (WINAPI *WRITE_EX) (UINT, UINT, LPVOID);
typedef UINT (WINAPI *GET_HANDLE) (UINT, UINT);
typedef UINT (WINAPI *GET_VENDOR_ID) (UINT pHandle);
typedef UINT (WINAPI *GET_PRODUCT_ID) (UINT pHandle);
typedef UINT (WINAPI *GET_VERSION_ID) (UINT);
typedef UINT (WINAPI *GET_VENDOR_NAME) (UINT, LPSTR, UINT);
typedef UINT (WINAPI *GET_PRODUCT_NAME) (UINT, LPSTR, UINT);
typedef UINT (WINAPI *GET_SERIAL_NUMBER) (UINT, LPSTR, UINT);
typedef UINT (WINAPI *GET_INPUT_REPORT_LENGTH) (UINT);
typedef UINT (WINAPI *GET_OUTPUT_REPORT_LENGTH) (UINT);
typedef void (WINAPI *SET_READ_NOTIFY) (UINT, BOOL);
typedef BOOL (WINAPI *IS_READ_NOTIFY_ENABLED) ();
typedef BOOL (WINAPI *IS_AVAILABLE) ();

extern CONNECT Connect;
extern DISCONNECT Disconnect;
extern GET_ITEM GetItem;
extern GET_ITEM_COUNT GetItemCount;
extern READ Read;
extern WRITE Write;
extern READ_EX ReadEx;
extern WRITE_EX WriteEx;
extern GET_HANDLE GetHandle;
extern GET_VENDOR_ID GetVendorID;
extern GET_PRODUCT_ID GetProductID;
extern GET_VERSION_ID GetVersionID;
extern GET_VENDOR_NAME GetVendorName;
extern GET_PRODUCT_NAME GetProductName;
extern GET_SERIAL_NUMBER GetSerialNumber;
extern GET_INPUT_REPORT_LENGTH GetInputReportLength;
extern GET_OUTPUT_REPORT_LENGTH GetOutputReportLength;
extern SET_READ_NOTIFY SetReadNotify;
extern IS_READ_NOTIFY_ENABLED IsReadNotifyEnabled;
extern IS_AVAILABLE IsAvailable;

extern int LoadHID();
