#define WIN32_LEAN_AND_MEAN  /* speed up compilations */
#include <windows.h>
#include <commdlg.h>
#include <commctrl.h>
#include <shellapi.h>
#include <shlwapi.h>
#include <math.h>
#include "Decagon.h"
#include "Ressources.h"
#include "libgfl.h"
#include "libgfle.h"

#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' ""version='6.0.0.0' processorArchitecture='*' publicKeyToken='6595b64144ccf1df' language='*'\"")

#pragma lib "Comdlg32.lib"
#pragma lib "comctl32.lib"
#pragma lib "shlwapi.lib"
#pragma lib "Shell32.lib"
#pragma lib "libgfl.lib"
#pragma lib "libgfle.lib"

char				szProgramClass[]						=	"DKGoneClass" ;
char				szProgramTitle[]						=	"Decagon" ;
char				szEmptyString[]							=	"\0\0\0" ;

char				szProgramName[MAX_PATH + 4] ;
char				szProgramPathAndName[MAX_PATH + 4] ;
char				szProgramFolder[MAX_PATH + 4] ;
char				szProfileFileName[MAX_PATH + 4] ;

HINSTANCE			hInstance ;

HWND				hMainWnd ;

SYSTEM_INFO			InfosSystem ;
DECAGON				ObjectDecagon ;

DECAGON_COORDINATES	DecagonCoordinates[]	=	{
													{0,"E6", 0.30901699437494742410229341718282, 0.95105651629515357211643933337938},
													{1,"E7", 0.80901699437494742410229341718282, 0.58778525229247312916870595463907},
													{2,"E8", 1.00000000000000000000000000000000, 0.00000000000000000000000000000000},
													{3,"E9", 0.80901699437494742410229341718282,-0.58778525229247312916870595463907},
													{4,"E10",0.30901699437494742410229341718282,-0.95105651629515357211643933337938},
													{5,"E1",-0.30901699437494742410229341718282,-0.95105651629515357211643933337938},
													{6,"E2",-0.80901699437494742410229341718282,-0.58778525229247312916870595463907},
													{7,"E3",-1.00000000000000000000000000000000, 0.00000000000000000000000000000000},
													{8,"E4",-0.80901699437494742410229341718282, 0.58778525229247312916870595463907},
													{9,"E5",-0.30901699437494742410229341718282, 0.95105651629515357211643933337938}
												} ;

DECAGON_LIBELLES	Diagonales[]			=	{
													{ 0,"(None)"},
													{ 1,"All"},
													{ 2,"E6"},
													{ 3,"E7"},
													{ 4,"E8"},
													{ 5,"E9"},
													{ 6,"E10"},
													{ 7,"E1"},
													{ 8,"E2"},
													{ 9,"E3"},
													{10,"E4"},
													{11,"E5"},
													{-1,""}
												} ;

COLORS				ListOfColors[]			=	{
													{ 1,0x00000000},
													{ 2,0x000000FF},
													{ 3,0x000014A8},
													{ 4,0x00006600},
													{ 5,0x00008000},
													{ 6,0x0000BFFF},
													{ 7,0x0000FF00},
													{ 8,0x0000FFFF},
													{ 9,0x000BDA51},
													{10,0x000F52BA},
													{11,0x001560BD},
													{12,0x00189BCC},
													{13,0x001E90FF},
													{14,0x001F75FE},
													{15,0x002C3E50},
													{16,0x003F00FF},
													{17,0x004666FF},
													{18,0x0048D1CC},
													{19,0x005B2C6F},
													{20,0x006050DC},
													{21,0x00612086},
													{22,0x0066FF66},
													{23,0x006A0DAD},
													{24,0x006CA0DC},
													{25,0x0078184A},
													{26,0x007F00FF},
													{27,0x007FFFD4},
													{28,0x00800080},
													{29,0x00808080},
													{30,0x008DA399},
													{31,0x0093CCEA},
													{32,0x009F00FF},
													{33,0x00A81C07},
													{34,0x00B22222},
													{35,0x00CCCCFF},
													{36,0x00CD7F32},
													{37,0x00CF71AF},
													{38,0x00E59866},
													{39,0x00E74C3C},
													{40,0x00F0F8FF},
													{41,0x00FF0000},
													{42,0x00FF00FF},
													{43,0x00FF69B4},
													{44,0x00FF6FFF},
													{45,0x00FF7F50},
													{46,0x00FFFACD},
													{47,0x00FFFF00},
													{48,0x00FFFFFF},
													{-1,0x00000000}
												} ;

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void ImageResize(DWORD __dwOriginalWidth,DWORD __dwOriginalHeight,DWORD __dwExpectedWidth,DWORD __dwExpectedHeight,DWORD *__lpdwNewWidth,DWORD *__lpdwNewHeight)
{
	register	DWORD	_dwWidth ;
	register	DWORD	_dwHeight ;

				double	_dRatio ;

	if(__dwOriginalWidth > __dwOriginalHeight)
	{
		_dRatio = (double) __dwOriginalHeight / (double) __dwOriginalWidth ;

		_dwWidth = __dwExpectedWidth ;
		_dwHeight = (DWORD) ((double) _dwWidth * _dRatio) ;

		if(_dwHeight > __dwExpectedHeight)
		{
			_dwHeight = __dwExpectedHeight ;
			_dwWidth = (DWORD) (((double) _dwHeight) / _dRatio) ;
		}

		*__lpdwNewWidth = _dwWidth ;
		*__lpdwNewHeight = _dwHeight ;

		return ;
	}

	_dRatio = (double) __dwOriginalWidth / (double) __dwOriginalHeight ;

	_dwHeight = __dwExpectedHeight ;
	_dwWidth = (DWORD) (((double) _dwHeight) * _dRatio) ;

	if(_dwWidth > __dwExpectedWidth)
	{
		_dwWidth = __dwExpectedWidth ;
		_dwHeight = (DWORD) (((double) _dwWidth) / _dRatio) ;
	}

	*__lpdwNewWidth = _dwWidth ;
	*__lpdwNewHeight = _dwHeight ;

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Error(LPSTR __lpszText)
{
	MessageBox(hMainWnd,__lpszText,"Error",MB_OK|MB_ICONERROR|MB_APPLMODAL|MB_TOPMOST) ;

	return (0) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int IsAtStartOfEditControl(HWND __hWnd)
{
	return (LOWORD(SendMessage(__hWnd,EM_GETSEL,0,0)) == 0) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

LRESULT CALLBACK SignedIntegerSubclassProc(HWND __hWnd,UINT __uMsg,WPARAM __wParam,LPARAM __lParam,UINT_PTR __uIdSubclass,DWORD_PTR __dwRefData)
{
	char	_ch ;

	__dwRefData = __dwRefData ;

	switch(__uMsg)
	{
		case	WM_NCDESTROY :	RemoveWindowSubclass(__hWnd,SignedIntegerSubclassProc,__uIdSubclass) ;
								break ;

		case	WM_CHAR :		_ch = (char) __wParam ;

								if(_ch < ' ')						break ;		// let control character through
								else if((_ch == '-' || _ch == '.') &&			// hyphen-minus or Unicode minus sign
									IsAtStartOfEditControl(__hWnd))	break ;		// at start of edit control is okay
								else if(isdigit(_ch))				break ;		// let digit through
									MessageBeep(0) ;							// otherwise invalid

								return (0) ;
	}

	return (DefSubclassProc(__hWnd,__uMsg,__wParam,__lParam)) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

BOOL EnforceSignedIntegerEdit(HWND __hWnd)
{
	return (SetWindowSubclass(__hWnd,SignedIntegerSubclassProc,0,0)) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_SetDefaultColors(LPDECAGON __lpDecagon)
{
	__lpDecagon->ColorDiagonals[0] = GetPrivateProfileInt("Colors","E6" , 8,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[1] = GetPrivateProfileInt("Colors","E7" ,7,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[2] = GetPrivateProfileInt("Colors","E8" ,25,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[3] = GetPrivateProfileInt("Colors","E9" ,29,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[4] = GetPrivateProfileInt("Colors","E10",10,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[5] = GetPrivateProfileInt("Colors","E1" , 6,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[6] = GetPrivateProfileInt("Colors","E2" ,18,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[7] = GetPrivateProfileInt("Colors","E3" ,42,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[8] = GetPrivateProfileInt("Colors","E4" ,40,szProfileFileName) ;
	__lpDecagon->ColorDiagonals[9] = GetPrivateProfileInt("Colors","E5" , 1,szProfileFileName) ;

	__lpDecagon->ColorBackground		= GetPrivateProfileInt("Colors","Background",		0,szProfileFileName) ;
	__lpDecagon->ColorExternalCircle	= GetPrivateProfileInt("Colors","External Circle",	34,szProfileFileName) ;
	__lpDecagon->ColorInternalCircle	= GetPrivateProfileInt("Colors","Internal Circle",	24,szProfileFileName) ;
	__lpDecagon->ColorLines				= GetPrivateProfileInt("Colors","Lines",			17,szProfileFileName) ;

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_SetDefaultValues(LPDECAGON __lpDecagon)
{
	MemorySetTo0(__lpDecagon,sizeof(DECAGON)) ;

	__lpDecagon->KindOfObject		= OBJECT_DECAGON ;

	__lpDecagon->IndexDiagonals		= 1 ;

	__lpDecagon->Angle_3D			= 40.00 ;
	__lpDecagon->ShowExternalCircle	= TRUE ;
	__lpDecagon->ShowInternalCircle	= TRUE ;
	__lpDecagon->Height				= 127.442 * 2 ;

	Decagon_SetDefaultColors(__lpDecagon) ;

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_DrawOneDiagonale(HDC __hDC,LPDECAGON __lpDecagon,int __iIndiceDecagon,int __iIndiceCouleur)
{
	int		_i, _iRayon, _iX1, _iY1, _iX2, _iY2 ;
	HPEN	_hPen, _hPenOld ;
	double	_dRayon ;

	_hPen = CreatePen(PS_SOLID,1,ListOfColors[__lpDecagon->ColorDiagonals[__iIndiceCouleur]].Color) ;
	if(_hPen)
	{
		_hPenOld = SelectObject(__hDC,_hPen) ;
		if(_hPenOld)
		{
			_dRayon = __lpDecagon->RayonExterieur ;
			_iRayon = (int) _dRayon ;

			_iX1 = _iRayon + __lpDecagon->Datas[__iIndiceDecagon].x ;
			_iY1 = _iRayon + __lpDecagon->Datas[__iIndiceDecagon].y ;

			for(_i = 1 ; _i < MAX_DECAGON_POINTS ; _i++)
			{
				_iX2 = _iRayon + __lpDecagon->Datas[_i].x ;
				_iY2 = _iRayon + __lpDecagon->Datas[_i].y ;

				MoveToEx(__hDC,_iX1,_iY1,NULL) ;
				LineTo(__hDC,_iX2,_iY2) ;
			}

			SelectObject(__hDC,_hPenOld) ;
		}

		DeleteObject(_hPen) ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_DrawAllDiagonales(HDC __hDC,LPDECAGON __lpDecagon)
{
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,9,0) ;		// E6
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,8,1) ;		// E7
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,7,2) ;		// E8
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,6,3) ;		// E9
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,5,4) ;		// E10
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,4,5) ;		// E1
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,3,6) ;		// E2
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,2,7) ;		// E3
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,1,8) ;		// E4
	Decagon_DrawOneDiagonale(__hDC,__lpDecagon,0,9) ;		// E5

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

HBITMAP Decagon_CreateMemory_Image(HWND __hWnd,LPDECAGON __lpDecagon)
{
	HDC		_hDC, _hDCMem ;
	HBITMAP	_hBmpMem, _hBmpMemOld, _hResult ;
	HPEN	_hPen, _hPenOld ;
	HBRUSH	_hBrush, _hBrushOld ;
	RECT	_RcBmp ;
	double	_dRayon ;
	int		_iRayon, _iHeight, _iWidth, _iXStart, _iYStart ;
	int		_iW, _iH, _iIndex ;

	_hResult = NULL ;

	_hDC = GetDC(__hWnd) ;
	if(_hDC)
	{
		_hDCMem = CreateCompatibleDC(_hDC) ;
		if(_hDCMem)
		{
			_iHeight = _iWidth = (int) __lpDecagon->Height ;
			_iXStart = _iYStart = 0 ;

			_hBmpMem = CreateCompatibleBitmap(_hDC,_iWidth,_iHeight) ;
			if(_hBmpMem)
			{
				_hBmpMemOld = SelectObject(_hDCMem,_hBmpMem) ;
				if(_hBmpMemOld)
				{
					SetRect(&_RcBmp,_iXStart,_iYStart,_iWidth,_iHeight) ;

					_hBrush = CreateSolidBrush(ListOfColors[__lpDecagon->ColorBackground].Color) ;
					if(_hBrush)
					{
						FillRect(_hDCMem,&_RcBmp,_hBrush) ;

						_hBrushOld = SelectObject(_hDCMem,_hBrush) ;
						if(_hBrushOld)
						{
							if(__lpDecagon->ShowExternalCircle == TRUE)
							{
								_hPen = CreatePen(PS_SOLID,1,ListOfColors[__lpDecagon->ColorExternalCircle].Color) ;
								if(_hPen)
								{
									_hPenOld = SelectObject(_hDCMem,_hPen) ;
									if(_hPenOld)
									{
										_iW = (_iWidth  - (2 *__lpDecagon->RayonExterieur)) / 2 ;
										_iH = (_iHeight - (2 *__lpDecagon->RayonExterieur)) / 2 ;

										Ellipse(_hDCMem,_iW,_iH,_iW + (2 * __lpDecagon->RayonExterieur),_iH + (2 * __lpDecagon->RayonExterieur)) ;

										SelectObject(_hDCMem,_hPenOld) ;
									}

									DeleteObject(_hPen) ;
								}
							}

							if(IsDlgButtonChecked(__hWnd,IDC_RADIO_01) == BST_CHECKED)
								__lpDecagon->ShowExternalCircle = TRUE ;
							else
								__lpDecagon->ShowExternalCircle = FALSE ;

							if(IsDlgButtonChecked(__hWnd,IDC_RADIO_03) == BST_CHECKED)
								__lpDecagon->ShowInternalCircle = TRUE ;
							else
								__lpDecagon->ShowInternalCircle = FALSE ;

							if(__lpDecagon->ShowInternalCircle == TRUE)
							{
								_hPen = CreatePen(PS_DOT,1,ListOfColors[__lpDecagon->ColorInternalCircle].Color) ;
								if(_hPen)
								{
									_hPenOld = SelectObject(_hDCMem,_hPen) ;
									if(_hPenOld)
									{
										_iW = (_iWidth  - (2 * __lpDecagon->RayonInterieur)) / 2 ;
										_iH = (_iHeight - (2 * __lpDecagon->RayonInterieur)) / 2 ;

										Ellipse(_hDCMem,_iW,_iH,_iW +(2 *  __lpDecagon->RayonInterieur),_iH + (2 * __lpDecagon->RayonInterieur)) ;

										SelectObject(_hDCMem,_hPenOld) ;
									}

									DeleteObject(_hPen) ;
								}
							}

							_hPen = CreatePen(PS_SOLID,1,ListOfColors[__lpDecagon->ColorLines].Color) ;
							if(_hPen)
							{
								_hPenOld = SelectObject(_hDCMem,_hPen) ;
								if(_hPenOld)
								{
									_dRayon = __lpDecagon->RayonExterieur ;
									_iRayon = (int) _dRayon ;

									MoveToEx(_hDCMem,_iRayon + __lpDecagon->Datas[0].x,_iRayon + __lpDecagon->Datas[0].y,NULL) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[1].x,_iRayon + __lpDecagon->Datas[1].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[2].x,_iRayon + __lpDecagon->Datas[2].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[3].x,_iRayon + __lpDecagon->Datas[3].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[4].x,_iRayon + __lpDecagon->Datas[4].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[5].x,_iRayon + __lpDecagon->Datas[5].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[6].x,_iRayon + __lpDecagon->Datas[6].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[7].x,_iRayon + __lpDecagon->Datas[7].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[8].x,_iRayon + __lpDecagon->Datas[8].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[9].x,_iRayon + __lpDecagon->Datas[9].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[0].x,_iRayon + __lpDecagon->Datas[0].y) ;

									SelectObject(_hDCMem,_hPenOld) ;

									_hResult = _hBmpMem ;
								}

								DeleteObject(_hPen) ;

								if(__lpDecagon->IndexDiagonals != 0)
								{
									_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_04,CB_GETCURSEL,0,0) ;
									__lpDecagon->IndexDiagonals = SendDlgItemMessage(__hWnd,IDC_COMBO_04,CB_GETITEMDATA,_iIndex,0) ;

									switch(__lpDecagon->IndexDiagonals)
									{
										case	1 :	Decagon_DrawAllDiagonales(_hDCMem,__lpDecagon) ;	break ;
										case	2 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,9,0) ;	break ;	// E6
										case	3 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,8,1) ;	break ;	// E7
										case	4 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,7,2) ;	break ;	// E8
										case	5 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,6,3) ;	break ;
										case	6 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,5,4) ;	break ;
										case	7 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,4,5) ;	break ;
										case	8 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,3,6) ;	break ;
										case	9 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,2,7) ;	break ;
										case	10 :Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,1,8) ;	break ;
										case	11 :Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,0,9) ;	break ;
									}
								}
							}

							SelectObject(_hDCMem,_hBrushOld) ;
						}

						DeleteObject(_hBrush) ;
					}

					SelectObject(_hDCMem,_hBmpMemOld) ;
				}
			}

			DeleteDC(_hDCMem) ;
		}

		ReleaseDC(__hWnd,_hDC) ;
	}

	return (_hResult) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_Compute_Datas(LPDECAGON __lpDecagon)
{
	int		_i ;

	for(_i = 0 ; _i < 10 ; _i++)
	{
		__lpDecagon->Datas[_i].x = __lpDecagon->RayonExterieur * DecagonCoordinates[_i].Sinus ;
		__lpDecagon->Datas[_i].y = -__lpDecagon->RayonExterieur * DecagonCoordinates[_i].Cosinus ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_GetDatas(HWND __hWnd,LPDECAGON __lpDecagon)
{
	int				_iIndex ;
	char			_szTmp[1024] ;

	if(GetDlgItemText(__hWnd,IDC_EDIT_01,_szTmp,sizeof(_szTmp)))
	{
		__lpDecagon->Height = strtod(_szTmp,NULL) ;

		if(GetDlgItemText(__hWnd,IDC_EDIT_02,_szTmp,sizeof(_szTmp)))
			__lpDecagon->Angle_3D = strtod(_szTmp,NULL) ;
		else
			__lpDecagon->Angle_3D = 40 ;

		if(IsDlgButtonChecked(__hWnd,IDC_RADIO_01) == BST_CHECKED)
			__lpDecagon->ShowExternalCircle = TRUE ;
		else
			__lpDecagon->ShowExternalCircle = FALSE ;

		if(IsDlgButtonChecked(__hWnd,IDC_RADIO_03) == BST_CHECKED)
			__lpDecagon->ShowInternalCircle = TRUE ;
		else
			__lpDecagon->ShowInternalCircle = FALSE ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_01,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorExternalCircle = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_01,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_02,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorInternalCircle = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_02,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_03,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorBackground = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_03,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_04,CB_GETCURSEL,0,0) ;
		__lpDecagon->IndexDiagonals = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_04,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_15,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorLines = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_15,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[0] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_06,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[1] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_07,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[2] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_08,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[3] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_09,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[4] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_10,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[5] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_11,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[6] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_12,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[7] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_13,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[8] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;

		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_14,CB_GETCURSEL,0,0) ;
		__lpDecagon->ColorDiagonals[9] = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_GETITEMDATA,_iIndex,0) ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_Debug_Datas(LPDECAGON __lpDecagon,int __iScreenOffset_X,int __iScreenOffset_Y,LPSTR __lpszFile)
{
	char	_szTmp[512] ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[0].x,__lpDecagon->Datas[0].y) ;
	WritePrivateProfileString("Debug","E6",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[1].x,__lpDecagon->Datas[1].y) ;
	WritePrivateProfileString("Debug","E7",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[2].x,__lpDecagon->Datas[2].y) ;
	WritePrivateProfileString("Debug","E8",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[3].x,__lpDecagon->Datas[3].y) ;
	WritePrivateProfileString("Debug","E9",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[4].x,__lpDecagon->Datas[4].y) ;
	WritePrivateProfileString("Debug","E10",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[5].x,__lpDecagon->Datas[5].y) ;
	WritePrivateProfileString("Debug","E1",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[6].x,__lpDecagon->Datas[6].y) ;
	WritePrivateProfileString("Debug","E2",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[7].x,__lpDecagon->Datas[7].y) ;
	WritePrivateProfileString("Debug","E3",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[8].x,__lpDecagon->Datas[8].y) ;
	WritePrivateProfileString("Debug","E4",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f, %.4f",__lpDecagon->Datas[9].x,__lpDecagon->Datas[9].y) ;
	WritePrivateProfileString("Debug","E5",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->RayonExterieur) ;
	WritePrivateProfileString("Trigo","Rayon Exterieur",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->RayonInterieur) ;
	WritePrivateProfileString("Trigo","Rayon Interieur",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Corde) ;
	WritePrivateProfileString("Trigo","Corde",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Hypothenuse) ;
	WritePrivateProfileString("Trigo","Hypothnuse",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__iScreenOffset_X) ;
	WritePrivateProfileString("Offsets","X",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__iScreenOffset_Y) ;
	WritePrivateProfileString("Offsets","Y",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[0]) ;
	WritePrivateProfileString("Colors","E6",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[1]) ;
	WritePrivateProfileString("Colors","E7",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[2]) ;
	WritePrivateProfileString("Colors","E8",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[3]) ;
	WritePrivateProfileString("Colors","E9",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[4]) ;
	WritePrivateProfileString("Colors","E10",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[5]) ;
	WritePrivateProfileString("Colors","E1",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[6]) ;
	WritePrivateProfileString("Colors","E2",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[7]) ;
	WritePrivateProfileString("Colors","E3",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[8]) ;
	WritePrivateProfileString("Colors","E4",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorDiagonals[9]) ;
	WritePrivateProfileString("Colors","E5",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorBackground) ;
	WritePrivateProfileString("Colors","Background",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorExternalCircle) ;
	WritePrivateProfileString("Colors","External Circle",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorInternalCircle) ;
	WritePrivateProfileString("Colors","Internal Circle",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->ColorLines) ;
	WritePrivateProfileString("Colors","Lines",_szTmp,__lpszFile) ;

	snprintf(_szTmp,sizeof(_szTmp),"%d",__lpDecagon->IndexDiagonals) ;
	WritePrivateProfileString("Diagonale","Selected",_szTmp,__lpszFile) ;

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Decagon_Compute(LPDECAGON __lpDecagon)
{
	int			_iXCentre, _iYCentre ;
	int			_iX1, _iY1 ;
	int			_iX2, _iY2 ;
	int			_iDelta ;

	if(__lpDecagon == NULL)							return (FALSE) ;
	if(__lpDecagon->KindOfObject != OBJECT_DECAGON)	return (FALSE) ;

	_iX1 = 0 ;
	_iY1 = 0 ;

	if(__lpDecagon->Height == 0)			__lpDecagon->Height = 100 ;
	else									__lpDecagon->RayonExterieur = __lpDecagon->Height / 2 ;

	if(__lpDecagon->RayonExterieur == 0)	__lpDecagon->RayonExterieur = __lpDecagon->Height / 2 ;
/*
I draw a circle of radius R = 100
The decagon is made up of 10 isosceles triangles.
The angles formed by the strings are 72.
To obtain the value of a cord, it is therefore necessary to cut these triangles by half.
By cutting this triangle in two, we divide the angles by two.
On snapshot therefore a triangle with an angle of 18, another of 72 and finally an angle of 90.
In this circle I position a right-angled triangle.
This triangle forms an angle of 72 degrees with the center of the circle.
Applying the sine law, I get:

	         a = 31
	        +---------+
	        |C|.....B/
	        |-+...../
	        |....../
	        |...../ c = 100
	b = 95  |..../
	        |.../
	        |../
	        |A/
	        |/
	        +

Angle of A = 18
Angle of B = 72
Angle of C = 90

The sum of the angles equal to 180: 90 - 72 - 18 = 180

We must consider the value of the radius as being the hypotenuse.
From this we deduce that:

Cosine = Adjacent Side / Hypothenuse
Cosine = Adjacent Side / 100
Adjacent side = 100 * cos(18)
Adjacent side = = 100 * 0.951056516295154
Adjacent side = 95.1056516295154

Sinus = Opposite Side / Hypothenuse
Sine = Opposite Side / 100
Opposite side = 100 * sin(18)
Opposite side = 100 * 0.309016994374947
Opposite side = 30.9016994374947

Cosine(18) = 95.1056516295154 / 100
Cosine(18) = 0.951056516295154

Value provided by Libre Office = 0.951056516295154

Sine(18) = 30.9016994374947 / 100
Sine(18) = 0.309016994374947

Value provided by Libre Office = 0.309016994374947

Then we can check the values ??by means of the Pythagorean theorem

C = A + B
100 = 30.9016994374947 + 95.1056516295154
10000 = 954.91502812526 + 9045.08497187475
10000 = 10000
C = SQRT(10000)
C = 100

The value of A is the value of a half chord
The chord is therefore A * 2 => 30.9016994374947 * 2 = 61.8033988749895
*/

/*
	***********************************************
	*** Sinus = Opposite Side / Hypothenuse     ***
	*** Sine = Opposite Side / 100              ***
	*** Opposite side = 100 * sin(18)          ***
	*** Opposite side = 100 * 0.309016994374947 ***
	*** Opposite side = 30.9016994374947        ***
	***********************************************
*/
	_iDelta = __lpDecagon->RayonExterieur ;

	_iX2 = _iX1 + _iDelta ;
	_iY2 = _iY1 + _iDelta ;

	__lpDecagon->RayonInterieur		= ((double) _iDelta) * COSINUS_18 ;
	__lpDecagon->Corde				= __lpDecagon->RayonExterieur * SINUS_18 ;
	__lpDecagon->Hypothenuse		= sqrt(pow(__lpDecagon->RayonExterieur,2) + pow(__lpDecagon->Corde,2)) ;
	__lpDecagon->Corde				= __lpDecagon->Corde * 2.00 ;
	__lpDecagon->Angle				= 36.00 ;
	__lpDecagon->Arc				= DECAGON_PI_ARC * __lpDecagon->RayonExterieur ;
	__lpDecagon->Point_D			= __lpDecagon->Hypothenuse * COSINUS_18 ;

	_iX2							= _iX1 + (__lpDecagon->RayonExterieur * 2) ;
	_iY2							= _iY1 + (__lpDecagon->RayonExterieur * 2) ;

	__lpDecagon->Center.x			= __lpDecagon->RayonExterieur ;
	__lpDecagon->Center.y			= __lpDecagon->RayonExterieur ;
	__lpDecagon->Center.z			= 0.00 ;

	_iXCentre						= (int) abs(_iX2 - _iX1) / 2 ;
	_iYCentre						= (int) abs(_iY2 - _iY1) / 2 ;

	__lpDecagon->Left.x				= _iX1 ;
	__lpDecagon->Left.y				= _iY1 ;

	__lpDecagon->Right.x			= _iX2 ;
	__lpDecagon->Right.y			= _iY2 ;

	__lpDecagon->Rectangle.x		= _iX1 ;
	__lpDecagon->Rectangle.y		= _iY1 ;
	__lpDecagon->Rectangle.z		= 0 ;
	__lpDecagon->Rectangle.height	= abs(_iX2 - _iX1) ;
	__lpDecagon->Rectangle.width	= abs(_iY2 - _iY1) ;

//	********************************************************************
//	*** Comment retrouver les coordonnes d'un point sur un cercle ? ***
//	********************************************************************
//	****                   x = x0 + (r * cos(t))                     ***
//	****                   y = y0 + (r * sin(t))                     ***
//	***	o (x0,y0) sont les coordonnes du centre,                   ***
//	*** r est le rayon, et t l'angle.                                ***
//	********************************************************************

//	********************************************************************
//	*** https://forums.futura-sciences.com/mathematiques-superieur/  ***
//	********************************************************************

	Decagon_Compute_Datas(__lpDecagon) ;
	Decagon_Debug_Datas(__lpDecagon,0,0,szProfileFileName) ;

	return (TRUE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Draw_Decagon_XY(HWND __hWnd,LPDECAGON __lpDecagon)
{
	HDC			_hDC, _hDCMem ;
	HBITMAP		_hBmpMem, _hBmpMemOld ;
	HPEN		_hPen, _hPenOld ;
	HBRUSH		_hBrush, _hBrushOld ;
	RECT		_RcBmp, _RcClient, _Rc ;
	double		_dRayon ;
	int			_iRayon, _iHeight, _iWidth, _iXStart, _iYStart ;
	int			_iW, _iH, _iNewWidth, _iNewHeight ;

	_hDC = GetDC(__hWnd) ;
	if(_hDC)
	{
		_hDCMem = CreateCompatibleDC(_hDC) ;
		if(_hDCMem)
		{
			_iHeight = _iWidth = (int) __lpDecagon->Height ;
			_iXStart = _iYStart = 0 ;

			_hBmpMem = CreateCompatibleBitmap(_hDC,_iWidth,_iHeight) ;
			if(_hBmpMem)
			{
				_hBmpMemOld = SelectObject(_hDCMem,_hBmpMem) ;
				if(_hBmpMemOld)
				{
					SetRect(&_RcBmp,_iXStart,_iYStart,_iWidth,_iHeight) ;

					_hBrush = CreateSolidBrush(ListOfColors[__lpDecagon->ColorBackground].Color) ;
					if(_hBrush)
					{
						FillRect(_hDCMem,&_RcBmp,_hBrush) ;

						_hBrushOld = SelectObject(_hDCMem,_hBrush) ;
						if(_hBrushOld)
						{
							if(__lpDecagon->ShowExternalCircle == TRUE)
							{
								_hPen = CreatePen(PS_SOLID,1,ListOfColors[__lpDecagon->ColorExternalCircle].Color) ;
								if(_hPen)
								{
									_hPenOld = SelectObject(_hDCMem,_hPen) ;
									if(_hPenOld)
									{
										_iW = (_iWidth  - (2 *__lpDecagon->RayonExterieur)) / 2 ;
										_iH = (_iHeight - (2 *__lpDecagon->RayonExterieur)) / 2 ;

										Ellipse(_hDCMem,_iW,_iH,_iW + (2 * __lpDecagon->RayonExterieur),_iH + (2 * __lpDecagon->RayonExterieur)) ;

										SelectObject(_hDCMem,_hPenOld) ;
									}

									DeleteObject(_hPen) ;
								}
							}

							if(__lpDecagon->ShowInternalCircle == TRUE)
							{
								_hPen = CreatePen(PS_DOT,1,ListOfColors[__lpDecagon->ColorInternalCircle].Color) ;
								if(_hPen)
								{
									_hPenOld = SelectObject(_hDCMem,_hPen) ;
									if(_hPenOld)
									{
										_iW = (_iWidth  - (2 * __lpDecagon->RayonInterieur)) / 2 ;
										_iH = (_iHeight - (2 * __lpDecagon->RayonInterieur)) / 2 ;

										Ellipse(_hDCMem,_iW,_iH,_iW +(2 * __lpDecagon->RayonInterieur),_iH + (2 * __lpDecagon->RayonInterieur)) ;

										SelectObject(_hDCMem,_hPenOld) ;
									}

									DeleteObject(_hPen) ;
								}
							}

							_hPen = CreatePen(PS_SOLID,1,ListOfColors[__lpDecagon->ColorLines].Color) ;
							if(_hPen)
							{
								_hPenOld = SelectObject(_hDCMem,_hPen) ;
								if(_hPenOld)
								{
									_dRayon = __lpDecagon->RayonExterieur ;
									_iRayon = (int) _dRayon ;

									MoveToEx(_hDCMem,_iRayon + __lpDecagon->Datas[0].x,_iRayon + __lpDecagon->Datas[0].y,NULL) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[1].x,_iRayon + __lpDecagon->Datas[1].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[2].x,_iRayon + __lpDecagon->Datas[2].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[3].x,_iRayon + __lpDecagon->Datas[3].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[4].x,_iRayon + __lpDecagon->Datas[4].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[5].x,_iRayon + __lpDecagon->Datas[5].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[6].x,_iRayon + __lpDecagon->Datas[6].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[7].x,_iRayon + __lpDecagon->Datas[7].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[8].x,_iRayon + __lpDecagon->Datas[8].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[9].x,_iRayon + __lpDecagon->Datas[9].y) ;
									LineTo(_hDCMem,_iRayon + __lpDecagon->Datas[0].x,_iRayon + __lpDecagon->Datas[0].y) ;

									SelectObject(_hDCMem,_hPenOld) ;
								}

								DeleteObject(_hPen) ;

								if(__lpDecagon->IndexDiagonals != 0)
								{
									switch(__lpDecagon->IndexDiagonals)
									{
										case	1 :	Decagon_DrawAllDiagonales(_hDCMem,__lpDecagon) ;	break ;
										case	2 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,9,0) ;	break ;
										case	3 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,8,1) ;	break ;
										case	4 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,7,2) ;	break ;
										case	5 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,6,3) ;	break ;
										case	6 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,5,4) ;	break ;
										case	7 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,4,5) ;	break ;
										case	8 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,3,6) ;	break ;
										case	9 :	Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,2,7) ;	break ;
										case	10 :Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,1,8) ;	break ;
										case	11 :Decagon_DrawOneDiagonale(_hDCMem,__lpDecagon,0,9) ;	break ;
									}
								}
							}

							SelectObject(_hDCMem,_hBrushOld) ;
						}

						DeleteObject(_hBrush) ;
					}

					GetClientRect(__hWnd,&_RcClient) ;
					ImageResize(_iWidth,_iHeight,250,250,&_iNewWidth,&_iNewHeight) ;

					SetStretchBltMode(_hDC,COLORONCOLOR) ;
					SetStretchBltMode(_hDCMem,COLORONCOLOR) ;

					SetRect(&_Rc,_RcClient.right - 260,_RcClient.top + 100,_RcClient.right - 10,_RcClient.top + 350) ;
					FillRect(_hDC,&_Rc,GetStockObject(WHITE_BRUSH)) ;

					StretchBlt(_hDC,_RcClient.right - 260,_RcClient.top + 100,_iNewWidth,_iNewHeight,_hDCMem,0,0,_iWidth,_iHeight,SRCCOPY) ;

					SelectObject(_hDCMem,_hBmpMemOld) ;
				}

				DeleteObject(_hBmpMem) ;
			}

			DeleteDC(_hDCMem) ;
		}

		ReleaseDC(__hWnd,_hDC) ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_FillDatas(HWND __hWnd,LPDECAGON __lpDecagon)
{
	int			_i, _k ;
	char		_szTmp[1024] ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Height) ;
	SetDlgItemText(__hWnd,IDC_EDIT_01,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Angle_3D) ;
	SetDlgItemText(__hWnd,IDC_EDIT_02,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->RayonExterieur) ;
	SetDlgItemText(__hWnd,IDC_EDIT_03,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->RayonInterieur) ;
	SetDlgItemText(__hWnd,IDC_EDIT_04,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Hypothenuse) ;
	SetDlgItemText(__hWnd,IDC_EDIT_05,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Corde) ;
	SetDlgItemText(__hWnd,IDC_EDIT_06,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Angle) ;
	SetDlgItemText(__hWnd,IDC_EDIT_07,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Arc) ;
	SetDlgItemText(__hWnd,IDC_EDIT_08,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Point_D) ;
	SetDlgItemText(__hWnd,IDC_EDIT_09,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Center.x) ;
	SetDlgItemText(__hWnd,IDC_EDIT_10,_szTmp) ;

	snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Center.y) ;
	SetDlgItemText(__hWnd,IDC_EDIT_11,_szTmp) ;

	_k = IDC_EDIT_12 ;

	for(_i = 0 ; _i < 10 ; _i++)
	{
		snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Datas[_i].x) ;
		SetDlgItemText(__hWnd,_k,_szTmp) ;

		snprintf(_szTmp,sizeof(_szTmp),"%.4f",__lpDecagon->Datas[_i].y) ;
		SetDlgItemText(__hWnd,_k + 1,_szTmp) ;

		_k += 2 ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_WmInitDialog(HWND __hWnd,LPARAM __lParam)
{
	HWND		_hCombo ;
	LPDECAGON	_lpDecagon ;
	LPSTR		_lpszLibelles ;
	int			_i, _j, _k, _m, _iIndex, _iIndexDiagonales, _iIndexColors[4 + MAX_DECAGON_POINTS] ;

	_lpDecagon = (LPDECAGON) __lParam ;
	RtlZeroMemory(_lpDecagon,sizeof(DECAGON)) ;

	SetWindowLongPtr(__hWnd,GWLP_USERDATA,(LONG_PTR) _lpDecagon) ;

	EnforceSignedIntegerEdit(__hWnd) ;

	Decagon_SetDefaultValues(_lpDecagon) ;

	_hCombo = GetDlgItem(__hWnd,IDC_COMBO_04) ;

	_i = 0 ;
	_iIndexDiagonales = 0 ;

	while(Diagonales[_i].Index != -1)
	{
		_lpszLibelles = Diagonales[_i].Libelle ;

		_iIndex = (int) SendMessage(_hCombo,CB_ADDSTRING,0,(LPARAM) _lpszLibelles) ;
		SendMessage(_hCombo,CB_SETITEMDATA,_iIndex,(LPARAM) Diagonales[_i].Index) ;

		if(_lpDecagon->IndexDiagonals == Diagonales[_i].Index)
			_iIndexDiagonales = _iIndex ;

		_i++ ;
	}

	SendMessage(_hCombo,CB_SETCURSEL,_iIndexDiagonales,0) ;

	RtlZeroMemory(_iIndexColors,sizeof(_iIndexColors)) ;
	_i = 0 ;

	while(ListOfColors[_i].Index != -1)
	{
		_iIndex = (int) SendDlgItemMessage(__hWnd,IDC_COMBO_15,CB_ADDSTRING,0,(LPARAM) " ") ;
		SendDlgItemMessage(__hWnd,IDC_COMBO_15,CB_SETITEMDATA,_iIndex,(LPARAM) _i) ;

		if(_lpDecagon->ColorLines == _i)
			_iIndexColors[3] = _iIndex ;

		_k = IDC_COMBO_01 ;

		for(_j = 0 ; _j < 3 ; _j++)
		{
			_iIndex = (int) SendDlgItemMessage(__hWnd,_k,CB_ADDSTRING,0,(LPARAM) " ") ;
			SendDlgItemMessage(__hWnd,_k,CB_SETITEMDATA,_iIndex,(LPARAM) _i) ;

			switch(_k)
			{
				case	IDC_COMBO_01 :	if(_lpDecagon->ColorExternalCircle == _i)
											_iIndexColors[0] = _iIndex ;
										break ;

				case	IDC_COMBO_02 :	if(_lpDecagon->ColorInternalCircle == _i)
											_iIndexColors[1] = _iIndex ;
										break ;

				case	IDC_COMBO_03 :	if(_lpDecagon->ColorBackground == _i)
											_iIndexColors[2] = _iIndex ;
										break ;
			}

			_k++ ;
		}

		_k = IDC_COMBO_05 ;
		_m = 4 ;

		for(_j = 0 ; _j < MAX_DECAGON_POINTS ; _j++)
		{
			_iIndex = (int) SendDlgItemMessage(__hWnd,_k,CB_ADDSTRING,0,(LPARAM) " ") ;
			SendDlgItemMessage(__hWnd,_k,CB_SETITEMDATA,_iIndex,(LPARAM) _i) ;

			if(_lpDecagon->ColorDiagonals[_j] == _i)
				_iIndexColors[_m] = _iIndex ;

			_k++ ;
			_m++ ;
		}

		_i++ ;
	}

	SendDlgItemMessage(__hWnd,IDC_COMBO_01,CB_SETCURSEL,_iIndexColors[ 0],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_02,CB_SETCURSEL,_iIndexColors[ 1],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_03,CB_SETCURSEL,_iIndexColors[ 2],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_15,CB_SETCURSEL,_iIndexColors[ 3],0) ;

	SendDlgItemMessage(__hWnd,IDC_COMBO_05,CB_SETCURSEL,_iIndexColors[ 4],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_06,CB_SETCURSEL,_iIndexColors[ 5],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_07,CB_SETCURSEL,_iIndexColors[ 6],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_08,CB_SETCURSEL,_iIndexColors[ 7],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_09,CB_SETCURSEL,_iIndexColors[ 8],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_10,CB_SETCURSEL,_iIndexColors[ 9],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_11,CB_SETCURSEL,_iIndexColors[10],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_12,CB_SETCURSEL,_iIndexColors[11],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_13,CB_SETCURSEL,_iIndexColors[12],0) ;
	SendDlgItemMessage(__hWnd,IDC_COMBO_14,CB_SETCURSEL,_iIndexColors[13],0) ;

	Decagon_Compute(_lpDecagon) ;
	Decagon_FillDatas(__hWnd,_lpDecagon) ;

	if(_lpDecagon->ShowExternalCircle)
		CheckRadioButton(__hWnd,IDC_RADIO_01,IDC_RADIO_02,IDC_RADIO_01) ;
	else
		CheckRadioButton(__hWnd,IDC_RADIO_01,IDC_RADIO_02,IDC_RADIO_02) ;

	if(_lpDecagon->ShowInternalCircle)
		CheckRadioButton(__hWnd,IDC_RADIO_03,IDC_RADIO_04,IDC_RADIO_03) ;
	else
		CheckRadioButton(__hWnd,IDC_RADIO_03,IDC_RADIO_04,IDC_RADIO_04) ;

	SendDlgItemMessage(__hWnd,IDC_EDIT_01,EM_LIMITTEXT,9,0) ;
	SendDlgItemMessage(__hWnd,IDC_EDIT_02,EM_LIMITTEXT,9,0) ;

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_Button_Compute(HWND __hWnd)
{
	LPDECAGON		_lpDecagon ;
	char			_szTmp[256] ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		if(GetDlgItemText(__hWnd,IDC_EDIT_01,_szTmp,sizeof(_szTmp)))
		{
			_lpDecagon->Height = strtod(_szTmp,NULL) ;

			Decagon_GetDatas(__hWnd,_lpDecagon) ;

			Decagon_Compute(_lpDecagon) ;
			Decagon_FillDatas(__hWnd,_lpDecagon) ;

			Draw_Decagon_XY(__hWnd,_lpDecagon) ;
		}
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Decagon_CreateCsvFile(HWND __hWnd)
{
	LPDECAGON		_lpDecagon ;
	HANDLE			_hFile ;
	OPENFILENAME	_Ofn ;
	char			_szFileName[MAX_PATH] ;
	char			_szBuffer[4096] ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		RtlZeroMemory(&_Ofn,sizeof(OPENFILENAME)) ;
		RtlZeroMemory(_szFileName,sizeof(_szFileName)) ;

		_Ofn.Flags				= OFN_ENABLESIZING|OFN_EXPLORER|OFN_NONETWORKBUTTON|OFN_NOREADONLYRETURN|OFN_PATHMUSTEXIST ;
		_Ofn.hInstance			= hInstance ;
		_Ofn.hwndOwner			= __hWnd ;
		_Ofn.lpstrDefExt		= "csv" ;
		_Ofn.lpstrFile			= _szFileName ;
		_Ofn.lpstrFilter		= "Text files (*.txt)\0*.txt\0CSV Files (*.csv);\0All Files (*.*)\0*.*\0\0" ;
		_Ofn.lStructSize		= sizeof(OPENFILENAME) ;
		_Ofn.nFilterIndex		= 1 ;
		_Ofn.nMaxFile			= sizeof(OPENFILENAME) ;

		if(GetSaveFileName(&_Ofn))
		{
			RtlZeroMemory(_szBuffer,sizeof(_szBuffer)) ;

			DeleteFile(_szFileName) ;

			_hFile = CreateFile(_szFileName,GENERIC_READ|GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL) ;
			if(_hFile != INVALID_HANDLE_VALUE)
			{
				lstrcpy(_szBuffer,"\"Expected Height\";\"Angle for 3D\";\"External Radius\";\"Internal Radius\";\"Hypothenus\";\"Choord\";\"Angle\";\"Arc\";\"Point D\";\"Center X\";\"Center Y\",") ;
				lstrcat(_szBuffer,"\"E6 X\";\"E6 Y\";\"E7 X\";\"E7 Y\";\"E8 X\";\"E8 Y\";\"E9 X\";\"E9 Y\";\"E10 X\";\"E10 Y\";\"E1 X\";\"E1 Y\";\"E2 X\";\"E2 Y\";\"E3 X\";\"E3 Y\";\"E4 X\";\"E4 Y\";\"E5 X\";\"E5 Y\";\n") ;

				if(FileWrite(_hFile,_szBuffer,lstrlen(_szBuffer)))
				{
					snprintf(_szBuffer,sizeof(_szBuffer),"%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f,%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;%f;\n\n",
												_lpDecagon->Height,_lpDecagon->Angle_3D,
												_lpDecagon->RayonExterieur,_lpDecagon->RayonInterieur,
												_lpDecagon->Hypothenuse,_lpDecagon->Corde,
												_lpDecagon->Angle,_lpDecagon->Arc,
												_lpDecagon->Point_D,
												_lpDecagon->Center.x,_lpDecagon->Center.y,
												_lpDecagon->Datas[0].x,_lpDecagon->Datas[0].y,
												_lpDecagon->Datas[1].x,_lpDecagon->Datas[1].y,
												_lpDecagon->Datas[2].x,_lpDecagon->Datas[2].y,
												_lpDecagon->Datas[3].x,_lpDecagon->Datas[3].y,
												_lpDecagon->Datas[4].x,_lpDecagon->Datas[4].y,
												_lpDecagon->Datas[5].x,_lpDecagon->Datas[5].y,
												_lpDecagon->Datas[6].x,_lpDecagon->Datas[6].y,
												_lpDecagon->Datas[7].x,_lpDecagon->Datas[7].y,
												_lpDecagon->Datas[8].x,_lpDecagon->Datas[8].y,
												_lpDecagon->Datas[9].x,_lpDecagon->Datas[9].y) ;

					if(FileWrite(_hFile,_szBuffer,lstrlen(_szBuffer)))
					{
						CloseHandle(_hFile) ;

						MessageBox(__hWnd,"File saved\nThe file is an aSCII Delimited File.","Information",MB_OK|MB_ICONINFORMATION|MB_APPLMODAL) ;
						return (TRUE) ;
					}
					else
					{
						CloseHandle(_hFile) ;

						return (Error("Cannot write into this file")) ;
					}
				}
				else
				{
					CloseHandle(_hFile) ;

					return (Error("Cannot write into this file")) ;
				}
			}
			else
				return (Error("Cannot create this file")) ;
		}
	}

	return (FALSE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Decagon_JpegFile(HWND __hWnd)
{
	LPDECAGON		_lpDecagon ;
	GFL_BITMAP		*_GflBitmap ;
	HBITMAP			_hBitmap ;
	OPENFILENAME	_Ofn ;
	GFL_SAVE_PARAMS	_SaveParams ;
	int				_FormatIndex ;
	char			_szFileName[MAX_PATH] ;
	char			_szTmp[1024] ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		RtlZeroMemory(&_Ofn,sizeof(OPENFILENAME)) ;
		RtlZeroMemory(_szFileName,sizeof(_szFileName)) ;

		_Ofn.Flags				= OFN_ENABLESIZING|OFN_EXPLORER|OFN_NONETWORKBUTTON|OFN_NOREADONLYRETURN|OFN_PATHMUSTEXIST ;
		_Ofn.hInstance			= hInstance ;
		_Ofn.hwndOwner			= __hWnd ;
		_Ofn.lpstrDefExt		= "jpg" ;
		_Ofn.lpstrFile			= _szFileName ;
		_Ofn.lpstrFilter		= "JPeg files (*.jpg)\0*.jpg\0Bitmap Files (*.bmp)\0*.bmp\0All Files (*.*)\0*.*\0\0" ;
		_Ofn.lStructSize		= sizeof(OPENFILENAME) ;
		_Ofn.nFilterIndex		= 1 ;
		_Ofn.nMaxFile			= sizeof(OPENFILENAME) ;

		if(GetSaveFileName(&_Ofn))
		{
			DeleteFile(_szFileName) ;

			if(*PathFindExtension(_szFileName) == '\0')
				lstrcat(_szFileName,".jpg") ;

			lstrcpy(_szTmp,PathFindExtension(_szFileName) + 1) ;
			CharLowerBuff(_szTmp,lstrlen(_szTmp)) ;

			if(lstrcmp(_szTmp,"jpg") == 0)
				_FormatIndex = gflGetFormatIndexByName("jpeg") ;
			else
			{
				_FormatIndex = gflGetFormatIndexByName(_szTmp) ;

				if(gflGetFormatIndexByName(_szTmp) == 0)
					return(Error("This image type is not known")) ;
			}

			_hBitmap = Decagon_CreateMemory_Image(__hWnd,_lpDecagon) ;
			if(_hBitmap)
			{
				if(gflConvertDDBIntoBitmap(_hBitmap,&_GflBitmap) == GFL_NO_ERROR)
				{
					gflGetDefaultSaveParams(&_SaveParams) ;

					_SaveParams.Quality = 95 ;
					_SaveParams.Progressive = TRUE ;
					_SaveParams.OptimizeHuffmanTable = TRUE ;
					_SaveParams.Flags = GFL_SAVE_ANYWAY ;
					_SaveParams.FormatIndex = _FormatIndex ;

					if(gflSaveBitmap(_szFileName,_GflBitmap,&_SaveParams) != GFL_NO_ERROR)
					{
						DeleteObject(_hBitmap) ;

						gflFreeBitmapData(_GflBitmap) ;
						gflFreeBitmap(_GflBitmap) ;

						snprintf(_szTmp,sizeof(_szTmp),"Cannot save the file %s",PathFindFileName(_szFileName)) ;
						return (Error(_szTmp)) ;
					}

					DeleteObject(_hBitmap) ;

					gflFreeBitmapData(_GflBitmap) ;
					gflFreeBitmap(_GflBitmap) ;

					snprintf(_szTmp,sizeof(_szTmp),"The file %s has been successfully saved",PathFindFileName(_szFileName)) ;
					MessageBox(__hWnd,_szTmp,"Information",MB_OK|MB_ICONINFORMATION|MB_APPLMODAL) ;

					return (TRUE) ;
				}
				else
					return (Error("Cannot create the image")) ;
			}
			else
				return (Error("Cannot create the image")) ;
		}
	}

	return (FALSE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Decagon_CopyToClipboard(HWND __hWnd)
{
	LPDECAGON		_lpDecagon ;
	GFL_BITMAP		*_GflBitmap ;
	HBITMAP			_hBitmap ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		_hBitmap = Decagon_CreateMemory_Image(__hWnd,_lpDecagon) ;
		if(_hBitmap)
		{
			if(gflConvertDDBIntoBitmap(_hBitmap,&_GflBitmap) == GFL_NO_ERROR)
			{
				if(gflExportIntoClipboard(_GflBitmap) == GFL_NO_ERROR)
				{
					gflFreeBitmapData(_GflBitmap) ;
					gflFreeBitmap(_GflBitmap) ;

					MessageBox(__hWnd,"Image copied into the clipboad","Information",MB_OK|MB_ICONINFORMATION|MB_APPLMODAL) ;
					return (TRUE) ;
				}
				else
				{
					gflFreeBitmapData(_GflBitmap) ;
					gflFreeBitmap(_GflBitmap) ;

					return (Error("Cannot copy the image into the clipboad")) ;
				}
			}
		}
	}

	return (FALSE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int Decagon_WmDrawItem(HWND __hWnd,WPARAM __wParam,LPDRAWITEMSTRUCT __lpDis)
{
	HDC			_hDCMem_1 ;
	HBITMAP		_hBmpMem_1, _hBmpMemOld_1 ;
	HBRUSH		_hBrush ;
	RECT		_MyRect ;
	int			_iWidth, _iHeight ;
	LPCOLORS	_lpColor ;

	if(__lpDis->itemID == -1)
		return (FALSE) ;

	_iWidth = __lpDis->rcItem.right - __lpDis->rcItem.left ;
	_iHeight = __lpDis->rcItem.bottom - __lpDis->rcItem.top ;

	_hDCMem_1 = CreateCompatibleDC(__lpDis->hDC) ;
	if(_hDCMem_1)
	{
		_hBmpMem_1 = CreateCompatibleBitmap(__lpDis->hDC,_iWidth,_iHeight) ;
		if(_hBmpMem_1)
		{
			_hBmpMemOld_1 = SelectObject(_hDCMem_1,_hBmpMem_1) ;
			if(_hBmpMemOld_1)
			{
				_lpColor = &ListOfColors[__lpDis->itemData] ;

				_hBrush = CreateSolidBrush(_lpColor->Color) ;
				if(_hBrush)
				{
					SetRect(&_MyRect,0,0,_iWidth,_iHeight) ;
					FillRect(_hDCMem_1,&_MyRect,_hBrush) ;
					DeleteObject(_hBrush) ;
				}

				if(__lpDis->itemState & ODS_SELECTED)
					DrawFocusRect(_hDCMem_1,&_MyRect) ;

				BitBlt(__lpDis->hDC,__lpDis->rcItem.left,__lpDis->rcItem.top,_iWidth,_iHeight,_hDCMem_1,0,0,SRCCOPY) ;

				SelectObject(_hDCMem_1,_hBmpMemOld_1) ;
			}

			DeleteObject(_hBmpMem_1) ;
		}

		DeleteDC(_hDCMem_1) ;
	}

	return (TRUE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

void Decagon_WmNotify(HWND __hWnd,LPARAM __lParam)
{
	PNMLINK	_lpNMLink ;
	LITEM	_iItem ;

	switch (((LPNMHDR) __lParam)->code)
	{
		case	NM_CLICK :						// Fall through to the next case.
		case	NM_RETURN :
							_lpNMLink	= (PNMLINK) __lParam ;
							_iItem		= _lpNMLink->item ;

							if((((LPNMHDR) __lParam)->hwndFrom == GetDlgItem(__hWnd,IDC_WEBLINK_01)) && (_iItem.iLink == 0))
							{
								ShellExecuteW(NULL,L"open",_iItem.szUrl,NULL,NULL,SW_SHOW) ;
								break ;
							}

							if((((LPNMHDR) __lParam)->hwndFrom == GetDlgItem(__hWnd,IDC_WEBLINK_02)) && (_iItem.iLink == 0))
							{
								ShellExecuteW(NULL,L"open",_iItem.szUrl,NULL,NULL,SW_SHOW) ;
								break ;
							}

				            break ;
	}

	return ;
}

void Decagon_GetColorsDatas(HWND __hWnd,WPARAM __wParam)
{
	LPDECAGON		_lpDecagon ;
	int				_iIndex ;
	int				_iControl, _iNotification, _iIndice ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		_iControl = LOWORD(__wParam) ;
		_iNotification = HIWORD(__wParam) ;

		if((_iControl >= IDC_COMBO_05) && (IDC_COMBO_05 <= IDC_COMBO_14))
		{
			if(_iNotification == CBN_SELCHANGE)
			{
				_iIndex = SendDlgItemMessage(__hWnd,_iControl,CB_GETCURSEL,0,0) ;
				_iIndice = _iControl - IDC_COMBO_05 ;
				_lpDecagon->ColorDiagonals[_iIndice] = (int) SendDlgItemMessage(__hWnd,_iControl,CB_GETITEMDATA,_iIndex,0) ;
			}
		}
	}

	return ;
}

void Decagon_Exit(HWND __hWnd)
{
	LPDECAGON	_lpDecagon ;

	_lpDecagon = (LPDECAGON) GetWindowLongPtr(__hWnd,GWLP_USERDATA) ;
	if(_lpDecagon)
	{
		Decagon_Debug_Datas(_lpDecagon,0,0,szProfileFileName) ;
	}

	return ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

LRESULT CALLBACK DecagonDlgProc(HWND __hWnd,UINT __uMsg,WPARAM __wParam,LPARAM __lParam)
{
	LPMEASUREITEMSTRUCT		_lpMis ;

	switch(__uMsg)
	{
		case	WM_NOTIFY :			Decagon_WmNotify(__hWnd,__lParam) ;
									break ;

		case	WM_INITDIALOG :		Decagon_WmInitDialog(__hWnd,__lParam) ;
									return (TRUE) ;

		case	WM_COMMAND :		switch(LOWORD(__wParam))
									{
										case	IDC_BUTTON_01 :	if(HIWORD(__wParam) == BN_CLICKED)
																{
																	Decagon_Button_Compute(__hWnd) ;
																	break ;
																}

																break ;

										case	IDC_BUTTON_02 :	Decagon_JpegFile(__hWnd) ;
																break ;

										case	IDC_BUTTON_03 :	Decagon_CreateCsvFile(__hWnd) ;
																break ;

										case	IDC_BUTTON_04 :	Decagon_CopyToClipboard(__hWnd) ;
																break ;

										case	IDC_COMBO_05 :
										case	IDC_COMBO_06 :
										case	IDC_COMBO_07 :
										case	IDC_COMBO_08 :
										case	IDC_COMBO_09 :
										case	IDC_COMBO_10 :
										case	IDC_COMBO_11 :
										case	IDC_COMBO_12 :
										case	IDC_COMBO_13 :
										case	IDC_COMBO_14 :	Decagon_GetColorsDatas(__hWnd,__wParam) ;

																break ;

										case	IDCANCEL :		if(HIWORD(__wParam) == BN_CLICKED)
																{
																	Decagon_Exit(__hWnd) ;
																	EndDialog(__hWnd,IDCANCEL) ;
																	return (TRUE) ;
																}
									}

									break ;

		case	WM_DRAWITEM :		return (Decagon_WmDrawItem(__hWnd,__wParam,(LPDRAWITEMSTRUCT) __lParam)) ;

		case	WM_MEASUREITEM :	_lpMis = (LPMEASUREITEMSTRUCT) __lParam ;
									_lpMis->itemWidth = 100 ;
									_lpMis->itemHeight = 20 ;
									return (TRUE) ;

	}

	return (FALSE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________

int APIENTRY WinMain(HINSTANCE __hInstance, HINSTANCE __hPrevInstance, LPSTR __lpszCmdLine, int __nCmdShow)
{
	INITCOMMONCONTROLSEX	_Icc ;
	char					_szTmp[1024] ;

	hInstance = __hInstance ;

	SetThreadErrorMode(SEM_FAILCRITICALERRORS,NULL) ;

//	*************************************
//	*** Initialize the libraries used ***
//	*************************************

	gflSetPluginsPathname(szProgramFolder) ;

	if(gflLibraryInit() != GFL_NO_ERROR)
		return(Error("Cannot initialize GFL SDK")) ;

	gflEnableLZW(GFL_TRUE) ;

//	**********************************************************************************
//	*** Get the program name and the folder name from which has been launched from ***
//	**********************************************************************************

	GetModuleFileName(hInstance,szProgramPathAndName,MAX_PATH) ;

	lstrcpy(szProgramName,PathFindFileName(lstrcpy(_szTmp,szProgramPathAndName))) ;
	*(PathFindFileName(_szTmp)) = '\0' ;

	lstrcpy(szProgramFolder,_szTmp) ;
	PathRemoveBackslash(szProgramFolder) ;

//	*******************************************
//	*** Create the name of the profile file ***
//	*******************************************

	snprintf(szProfileFileName,sizeof(szProfileFileName),"%s\\DKGone.ini",szProgramFolder) ;

	_Icc.dwSize = sizeof(INITCOMMONCONTROLSEX) ;
	_Icc.dwICC = ICC_WIN95_CLASSES ;

	InitCommonControlsEx(&_Icc) ;

	SystemParametersInfo(SPI_SETGRADIENTCAPTIONS,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETCURSORSHADOW,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETGRADIENTCAPTIONS,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETMENUANIMATION,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETMENUFADE,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETFLATMENU,0,(LPVOID) TRUE,0) ;
	SystemParametersInfo(SPI_SETSELECTIONFADE,0,(LPVOID) TRUE,0) ;

	DialogBoxParam(hInstance,MAKEINTRESOURCE(DLG_DEFINE_DECAGON),NULL,(DLGPROC) DecagonDlgProc,(LPARAM) &ObjectDecagon) ;

	gflLibraryExit() ;

	return (FALSE) ;
}

//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
//	_____________________________________________________________________________________________
