﻿#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) && !defined(WIN32)
	#define WIN32
#endif

#define	DECAGON_PI 					3.14159265358979323846264338327950288419716939937510582
#define	DECAGON_2PI  				(2.00 * DECAGON_PI)
#define	DECAGON_DEG_TO_RAD			(DECAGON_PI / 180.00)
#define	DECAGON_RAD_TO_DEG			(180.00 / DECAGON_PI)
#define	DECAGON_PI_ARC				(DECAGON_PI * 0.4)

#define	OBJECT_DECAGON				2 

#define	MAX_DECAGON_POINTS			10

#define	COSINUS_18					0.95105651629515357211643933337938
#define	SINUS_18					0.30901699437494742410229341718282

typedef struct tagCOLORS
{
	int		Index ;
	DWORD	Color ;
} COLORS, *LPCOLORS ;

typedef struct tagDECAGON_LIBELLES
{
	int		Index ;
	char	Libelle[32] ;
} DECAGON_LIBELLES, *LPDECAGON_LIBELLES ;

typedef struct tagPOINT3D
{
	int			x ;
	int			y ;
	int			z ;
} POINT3D, *LPPOINT3D ;

typedef struct tagRECT3D
{
	int			x ;
	int			y ;
	int			z ;
	int			width ;			// Diameter for a circle
	int			height ;
	int			Depth ;
} RECT3D, *LPRECT3D ;

typedef struct tagPOINT3DD
{
	double		x ;
	double		y ;
	double		z ;
} POINT3DD, *LPPOINT3DD ;

typedef struct tagDECAGON
{
	int			KindOfObject ;

	int			IndexDiagonals ;

	int			ShowExternalCircle ;
	int			ShowInternalCircle ;

	int			ColorLines ;
	int			ColorInternalCircle ;
	int			ColorExternalCircle ;
	int			ColorBackground ;
	int			ColorDiagonals[MAX_DECAGON_POINTS] ;

	double		Height ;
	double		Arc ;
	double		RayonExterieur ;		// Rayon du cercle extérieur
	double		RayonInterieur ;		// Rayon du cercle inscrit
	double		Corde ;
	double		Hypothenuse ;
	double		Point_D ;
	double		Angle ;
	double		Angle_3D ;

	POINT3DD	Center ;

	POINT		Left ;
	POINT		Right ;

	POINT3DD	Datas[MAX_DECAGON_POINTS] ;
	RECT3D		Rectangle ;

} DECAGON, *LPDECAGON ;

typedef	struct tagDECAGON_COORDINATES
{
	int			Index_1 ;
	char		Libelle[8] ;
	double		Sinus ;
	double		Cosinus ;
} DECAGON_COORDINATES, *LPDECAGON_COORDINATES ;

typedef struct tagPROFILE
{
	int			ShowGridLines ;
	int			SaveWindowPosAndSize ;
	int			ShowRecapDialog ;
	int			Window_X ;
	int			Window_Y ;
	int			Window_W ;
	int			Window_H ;
} PROFILE, *LPPROFILE ;

extern LPDECAGON	lpDecagon  ;

LRESULT CALLBACK DecagonDlgProc(HWND __hWnd,UINT __uMsg,WPARAM __wParam,LPARAM __lParam) ;
LPVOID	MemorySetTo0(LPVOID __lpszDst,DWORD __dwBufferSize) ;
BOOL	FileWrite(HANDLE __hFile,LPBYTE __lpBuffer,DWORD __dwBufferSize) ;

#ifdef __cplusplus
}
#endif

