							.Const

							INCLUDE	Win_AsmLibrary.inc

							.Code

;	**********************************************************************************
;	*********************** MemorySetTo0 *********************************************
;	**********************************************************************************

							ALIGN	16

comment^
	INPUT	RCX	=	Source
			RDX	=	Number of bytes to copy

	OUTPUT	RAX	=	Source
^

PUBLIC	MemorySetTo0

MemorySetTo0 :

							push	rdi
							mov		rdi,rcx
							push	rdi
							xor		rax,rax

							xorpd	xmm0,xmm0
							shufpd	xmm0,xmm0,0

							mov		rcx,rdx
							shr		rcx,4
							mov		rax,16
							mov		r10,rcx
							jrcxz	@MemorySetTo0_Loop_128_End
							jmp		@MemorySetTo0_Loop_128

;	------------------> Move 128 bits

;	===========================================================================================
;	===========================================================================================

							ALIGN	16

@MemorySetTo0_Loop_128 :

							movdqu	[rdi],xmm0
							add		rdi,rax
							dec		rcx
							jnz		@MemorySetTo0_Loop_128
							jmp		@MemorySetTo0_Loop_128_End

;	===========================================================================================
;	===========================================================================================

							ALIGN	16

@MemorySetTo0_Loop_128_End :

;	------------------> Move 64 bits

							shl		r10,4
							sub		rdx,r10
							jz		@Finished_MemorySetTo0

							mov		rcx,rdx
							shr		rcx,3
							mov		r10,rcx
							rep		stosq
							shl		r10,3
							sub		rdx,r10
							jz		@Finished_MemorySetTo0

;	------------------> Move 32 bits

							mov		rcx,rdx
							shr		rcx,2
							mov		r10,rcx
							rep		stosd
							shl		r10,2
							sub		rdx,r10
							jz		@Finished_MemorySetTo0

;	------------------> Move 16 bits

							mov		rcx,rdx
							shr		rcx,1
							mov		r10,rcx
							rep		stosw
							shl		r10,1
							sub		rdx,r10
							jz		@Finished_MemorySetTo0

;	------------------> Move 8 bits

							stosb
							jmp		@Finished_MemorySetTo0

;	===========================================================================================
;	===========================================================================================

							ALIGN	16

@Finished_MemorySetTo0 :

							pop		rax
							pop		rdi
							ret

;	**********************************************************************************
;	*********************** F I N I S H E D ******************************************
;	**********************************************************************************

							END
