#include <graphics.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>


void far *buffer[4];
const char nom_fich[40] = "C:\LANGAGES\TCPP\PROGRAMS\DESSIN.FCH";
double ci, cr;
static int lim = 1000, factor = 20;
int a, factorx, factory;
int maxx, maxy;
unsigned size[4];


void ModeGraphique(void);
void save_screen(void);
void restore_screen(void);
void sauvegarde(void);
void trace(int x, int y, int c);
void calcul(double x, double y);
void dessine(void);

void main(void)  {

	ModeGraphique();

	factorx = factor;
	if (factor == 1) factory = 1;
	else factory = (int)(factor/2);

	dessine();
	save_screen();
	cleardevice();
	sauvegarde();
	getch();
	restore_screen();
	restorecrtmode();
}


void ModeGraphique(void)  {

	int gdriver = DETECT, gmode, errorcode;

	initgraph(&gdriver, &gmode, "C:\LANGAGES\TCPP\BGI");
	errorcode = graphresult();

	if (errorcode != grOk)  {
		printf("Erreur graphique: %s\n", grapherrormsg(errorcode));
		printf("Frappez une touche pour continuer...");
		getch();
		exit(0);
		}
	maxx = getmaxx();
	maxy = getmaxy() - 40;
}

void save_screen(void) {

	char s[20];
	int x, y, dx, dy, t;
	int block;

	x = 0;
	y = 0;
	dx = (int)(maxx/2);
	dy = (int)(maxy/2);

	for (block = 0 ; block <= 3 ; block++) {

		size[block] = (unsigned)imagesize(x, y, dx, dy);
		sprintf(s,"Taille=%u\n",size[block]);
		outtextxy(10,190,(char far *)s);
		getch();

		if ((buffer[block] = farmalloc(size[block])) == (void far *)NULL) {
			outtextxy(10,190,"Espace insuffisant");
			return;
			}

		getimage(x, y, dx, dy, buffer[block]);

		if (x == 0) { x = dx; dx = maxx; }
		else { dx = x; x = 0; }
		if (y == 0 && x == 0) { y = dy; dy = maxy; }

		}
}

void sauvegarde(void) {

	FILE *fich;
	int block, i;
	char *p;

	restorecrtmode();
	if ((fich = fopen(nom_fich,"wb")) == (FILE *)NULL) {
		outtextxy(10,190,"Impossible d'ouvrir fichier.");
		return;
		}

	for (block = 0 ; block <= 3 ; block++) {

		p = (char *)buffer[block];

		for (i = 0 ; i <= size[block] ; i++) {
			putch(*p);
			p = p + 1;
			}

		farfree(buffer[block]);
		}

	fclose(fich);
	outtextxy(10,190,"Sauvegarde russie");
	setgraphmode(getgraphmode());
}

void restore_screen(void) {

	int x, y, dx, dy, t;
	int block;

	x = 0;
	y = 0;
	dx = (int)(maxx/2);
	dy = (int)(maxy/2);

	for (block = 0 ; block <= 3 ; block++) {

		putimage(x, y, buffer[block], COPY_PUT);

		if (x == 0) { x = dx; dx = maxx; }
		else { dx = x; x = 0; }
		if (y == 0 && x == 0) { y = dy; dy = maxy; }

		}
}


void calcul(double x, double y) {

	double x1, y1;

	a = 0;
	while (a++ < lim) {

		x1 = x*x - y*y + cr;
		y1 = x*y + x*y + ci;

		if ((x1*x1 + y1*y1) < (double)4.00) { x=x1; y=y1; }
		else break;

		}
}

void trace(int x, int y, int c) {

	int i,j;

	setcolor(c);
	for (i = 0; i < factory; i++)
		line( x*factorx, y*factory + i, (x+1)*factorx-1, y*factory + i);
}


void dessine(void) {

	double Left = -1.202, Right = -1.172;
	double Bottom = 0.293, Top = 0.313;
	double x0, y0;
	double deltax, deltay;

	int xscreen = (int)(maxx/factorx);
	int yscreen = (int)(maxy/factory);
	int n,m;

	deltax = (Right - Left)/xscreen;
	deltay = (Top - Bottom)/yscreen;

	x0 = Left; y0 = Top;

	for (n = 0; n <= xscreen; n++) {

		cr = x0 + n * deltax;

		for (m = 0; m <= yscreen; m++) {

			ci = y0 - m * deltay;

			calcul(0,0);

			if (a < 27) { trace(n,m,a % 2); continue; }
			if (a < 35) { trace(n,m,3); continue; }
			if (a < 55) { trace(n,m,0); continue; }
			if (a < 100) { trace(n,m,2); continue; }
			if (a < lim) { trace(n,m,1); continue; }
			}
		}
}