// Script Scilab d'import de données texte et d'export en WAV
// But : "écouter" une température
// Suite des opérations effectuées :
// 1 - Chargement des données texte
// source : http://www.meteo-paris.com/ile-de-france/station-meteo-paris/pro/)
// 2 - Conditionnement du signal
// Remarque : la suppression de la composante continue se fait par soustraction de la moyenne du signal plutôt que par un filtrage passe-haut
// Avantages : simplicité et respect de la tendance hebdomadaire
// 3 - Exportation en WAV 16bits / 48kHz

  clear all ;
  clc ;
  
// 0 - Définition des données utiles
  Fs = 48000 ;                                                                  // Définition de la fréquence d'échantillonnage

// 1 - Chargement des données texte
  cd 'd:\perso\Futura\xx - Ecouter une température\Scilab\Donnees'              // Définition du répertoire local où se trouvent les données
  Donnees  = fscanfMat('14.01.2012_8j.txt')      ;                              // Récupération des seules données numériques dans le fichier météo
  longueur = size(Donnees,1)                     ;                              // Nombre de points de mesure dans les relevés météo
  cd 'd:\perso\Futura\xx - Ecouter une température\Scilab'                      // On se remet un cran en amont
  signal   = Donnees(:,3)' ;                                                    // Extraction des température "Temp Out" = 3ème colonne, toutes les lignes

// 2 - Conditionnement du signal
  signal = signal - mean(signal) ;                                              // Suppression de la composante continue
  signal = signal / max(abs(signal)) ;                                          // Normalisation entre -1 et +1, nécessaire pour la fonction "savewave"

// 3 - Exportation en WAV 16bits / 48kHz
  savewave('signal.wav',signal,Fs) ;