% Simulation d'un effet Larsen via un filtre rsursif
% On a une chaine micro + prampli micro + ampli + HP + propagation
% Le microphone recapte l'onde sonore, et on est repartis pour un tour
% La FTBO s'entend comme le rapport Pression / Pression au microphone

clear all ;
clc ;

% Paramtres
  Dist = 0.56 ;  % Distance micro / ampli [m]
  Q    = 0.8  ;  % Facteur de surtension  la rsonance
  
% Chargement des donnes externes
  RI_red = wavread('RI_redwirez.wav') ;
  RI_red = RI_red / 8 ;  % Empirique !!!

% Dfinition des donnes utiles
  c          = 340                           ;  % Vitesse des ondes sonores   [m/s]
  Fech       = 50000                         ;  % Frquence d'chantillonnage [Hz]
  pas        = 1/Fech                        ;  % Pas de temps                [s]
  Nyquist    = round(Fech/2)                 ;  % Frquence de Nyquist        [Hz]
  Nfft       = Fech                          ;  % => DeltaF = 1 Hz
  Duree      = 0.1                           ;  % Dure de la simulation      [s]
  t          = [0:pas:Duree-pas]             ;  % Vecteur temps               [s]
  f          = [0:Fech/(Duree*Nfft):Nyquist] ;  % Vecteurs frquences         [Hz]
  w          = 2*pi*f                        ;  % Vecteurs pulsations         [rad/s]
  % f_tot     = [0:Fech/(Duree*Nfft):Fech-Fech/(Duree*Nfft)]    ;
  % w_tot     = 2*pi*f_tot ;  
  Nfft_sonag = 16384        ;
  Nrecouvr   = 500          ;
  Fenetre    = Hanning(512) ;
  
% Donnes physiques
  Gain_micro       =   0.01     ;  % Gain du microphone     [V/Pa]
  Gain_preamp      =  18.00     ;  % Gain du prampli micro [V/V]
  Gain_ampli       =  20.00     ;  % Gain de l'ampli        [V/V]
  Gain_HP_1m       =   0.10     ;  % Gain du haut-parleur   [Pa/V]  1m
  Gain_propagation = (1/Dist)^2 ;  % Gain du  la distance  [Pa/Pa]
  
% Hypothse : la fonction de transfert globale est assimilable  un systme
% masse-ressort avec Q dfini dans les paramtres
% Critiques
% 1 - On passe toutes les BF, alors que l'on devrait avoir une coupure
% d'ordre 2 (enceinte close) ou d'ordre 4 (bass-reflex).
% 2 - Une seule rsonance de bout de bande, alors qu'un HP d'ampli guitare en a plusieurs
% => Quel ordre pour un HP en baffle ouvert comme dans la plupart des amplis guitarre ??
  % Dfinition des paramtres du systme masse-ressort
    k       = 150e6       ;  % Raideur du ressort [N/m]
    m       = 1           ;  % Masse              [kg]
    w0      = sqrt(k/m)   ;  % Pulsation propre   [rad/s]
    f0      = w0 /(2*pi)  ;  % Frquence propre   [Hz]
    b       = sqrt(k*m)/Q ;  % Amortissement      [kg/s]
    
  % Construction de la rponse impulsionnelle du systme masse-ressort
    FT      = 1./(-w.^2*m + j*b*w + k)     ;  % Fonction de transfert
    FT      = k * FT                       ;  % Fonction de transfert normalise
    Taille  = size(FT,2)                   ;
    FT_inv  = [FT conj(FT(Taille-1:-1:2))] ;  % Fonction de transfert inversible par FFT-1
    RI_hp   = real(ifft(FT_inv))           ;  % Rponse impulsionnelle
    RI_hp   = RI_red                       ;
    
  % Construction de la RI globale
    Taille = max(find(RI_hp(:)>max(RI_hp)/1000)) + 1  ;
    RI_hp  = RI_hp(1:Taille) ;
    Taille = Taille + round(Fech*Dist/c) ;
    RI_glob = zeros(1,Taille) ;
    % Dtail de chacune des contributions
      RI_micro            = RI_glob            ;
      RI_preamp           = RI_glob            ;
      RI_ampli            = RI_glob            ;
      RI_HP               = RI_glob            ;
      RI_propagation      = RI_glob            ;
      RI_micro(1)         = Gain_micro         ;
      RI_preamp(1)        = Gain_preamp        ;
      RI_ampli(1)         = Gain_ampli         ;
      RI_HP(1)            = Gain_HP_1m         ;
      Ind                 = round(Fech*Dist/c) ;
      RI_propagation(Ind) = Gain_propagation   ;
    % RI globale
      RI_glob(1) = 1                                ;
      RI_glob    = filter(RI_micro      ,1,RI_glob) ;
      RI_glob    = filter(RI_preamp     ,1,RI_glob) ;
      RI_glob    = filter(RI_ampli      ,1,RI_glob) ;
      RI_glob    = filter(RI_HP         ,1,RI_glob) ;
      RI_glob    = filter(RI_propagation,1,RI_glob) ;
      RI_glob    = filter(RI_hp         ,1,RI_glob) ;
      
  % Utilisation d'un filtre rcursif
  % La partie directe est gale  la RI globale
  % La partie rcursive est gale  -RI_glob, avec un premier coefficient forc  1
    RI_dir    =  RI_glob ;
    RI_rec    = -RI_glob ;
    RI_rec(1) =  1       ;
    
  % Trac de la fonction de transfert du filtre
    [H,F] = freqz(RI_dir,RI_rec,Fech,Fech) ;
    figure(1)
    semilogx(F,20*log10(abs(H))) ;
    axis([20 Fech/2 -40 20]) ;
    grid on ;
    xlabel('Frquence (Hz)') ;
    ylabel('Gain (dB)') ;
    Title(['Gain du filtre IIR modlisant le Larsen. Distance ampli / micro : ' sprintf('%.2f',Dist) 'm'])  
    
  % Construction d'un signal d'excitation
  % Essai 1 : Pseudo-Dirac
    Taille         = size(t,2)                    ;
    Signal         = zeros(1,Taille)              ;
    Signal(1)      = 1                            ;
    Resultat_Dirac = filter(RI_dir,RI_rec,Signal) ;
    
    % Equation de rcurrence gre  la main + saturation
    Taille_signal         = size(Signal ,2)        ;
    Taille_filtre         = size(RI_glob,2)        ;
    Resultat_Dirac_manuel = zeros(1,Taille_signal) ;
    for i = 1:Taille
      Taille_conv              = min(Taille_filtre,i)                                                                                                                               ;
      Resultat_Dirac_manuel(i) = (sum(RI_dir(1:Taille_conv).*Signal(i:-1:i-Taille_conv+1)) - sum(RI_rec(2:Taille_conv).*Resultat_Dirac_manuel(i-1:-1:i-Taille_conv+1))) / RI_rec(1) ;
      Resultat_Dirac_manuel(i) =  saturation(Resultat_Dirac_manuel(i),1)                                                                                                            ;
    end
    
    % Construction des sonagrammes
    [Amp        Freq Temps] = specgram(Resultat_Dirac       ,Nfft_sonag,Fech,Fenetre,Nrecouvr) ;
    [Amp_manuel Freq Temps] = specgram(Resultat_Dirac_manuel,Nfft_sonag,Fech,Fenetre,Nrecouvr) ;
    % Normalisation en amplitude
    Amp                = Amp             * 2 / 256 ;
    Amp(1:64,:)        = Amp(1:64,:)         /   2 ;
    Amp_manuel         = Amp_manuel      * 2 / 256 ;
    Amp_manuel(1:64,:) = Amp_manuel(1:64,:)  /   2 ;
    
    % Tracs
      figure(10) ;
      subplot(2,2,1) ;
      plot(t,Resultat_Dirac) ;
      subplot(2,2,2) ;
      plot(t,Resultat_Dirac_manuel) ;
      subplot(2,2,3) ;
      imagesc(Temps, Freq(1:2049,:), (abs(Amp       (1:2049,:)))) ;
      axis xy ;
      subplot(2,2,4) ;
      imagesc(Temps, Freq(1:2049,:), (abs(Amp_manuel(1:2049,:)))) ;
      axis xy ;
    
  % Essai 2 : Bruit blanc
    Taille         = size(t,2)                    ;
    Signal         = rand(1,Taille) - 0.5         ;
    Signal(1)      = 1                            ;
    Resultat_BB    = filter(RI_dir,RI_rec,Signal) ;
    
    % Equation de rcurrence gre  la main + saturation
    Taille_signal         = size(Signal ,2) ;
    Taille_filtre         = size(RI_glob,2) ;
    Resultat_BB_manuel    = zeros(1,Taille_signal) ;
    for i = 1:Taille
      Taille_conv           = min(Taille_filtre,i)                                                                                                                               ;
      Resultat_BB_manuel(i) = (sum(RI_dir(1:Taille_conv).*Signal(i:-1:i-Taille_conv+1)) - sum(RI_rec(2:Taille_conv).*Resultat_BB_manuel(i-1:-1:i-Taille_conv+1))) / RI_rec(1) ;
      Resultat_BB_manuel(i) = saturation(Resultat_BB_manuel(i),1)                                                                                                             ;
    end
    
    % Construction des sonagrammes
    [Amp        Freq Temps] = specgram(Resultat_BB       ,Nfft_sonag,Fech,Fenetre,Nrecouvr) ;
    [Amp_manuel Freq Temps] = specgram(Resultat_BB_manuel,Nfft_sonag,Fech,Fenetre,Nrecouvr) ;
    % Normalisation en amplitude
    Amp                = Amp             * 2 / 256 ;
    Amp(1:64,:)        = Amp(1:64,:)         /   2 ;
    Amp_manuel         = Amp_manuel      * 2 / 256 ;
    Amp_manuel(1:64,:) = Amp_manuel(1:64,:)  /   2 ;
      
    % Tracs
      figure(20) ;
      subplot(2,2,1) ;
      plot(t,Resultat_BB) ;
      subplot(2,2,2) ;
      plot(t,Resultat_BB_manuel) ;
      subplot(2,2,3) ;
      imagesc(Temps, Freq(1:2049,:), (abs(Amp       (1:2049,:)))) ;
      axis xy ;
      subplot(2,2,4) ;
      imagesc(Temps, Freq(1:2049,:), (abs(Amp_manuel(1:2049,:)))) ;
      axis xy ;