% Mise en vidence de la ventilation sur un signal dbitmtrique
% possdant 2 phase de repos et 2 phases d'effort alternes

clear all ;
clc ;

% Chargement des donnes
  load -ascii 'VE.txt' ;
  
% Constantes
  Fech  = 1            ;
  Duree = max(VE(:,1)) ;
  t     = [0:1:Duree*Fech] ;
  
% Conditionnement des donnes : rchantillonnage
  Debit = interp1(VE(:,1),VE(:,2),t,'spline') ;
  
% Trac intermdiaire pour vrification du rchantillonnage
  figure(1) ;
  plot(VE(:,1),VE(:,2),'r:','LineWidth',2) ;
  hold on ;
  plot(t,Debit) ;
  
% Calcul 1 : spectre
  NDebit        = size(Debit,2)                ;
  Nfft          = 10000                        ;
  Debit_spectre = fft(Debit,Nfft) / (NDebit/2) ;
  Debit_spectre = Debit_spectre(1:Nfft/2+1)    ;
  Freq          = [0:Fech/Nfft:Fech/2]         ;

% Trac du spectre
  figure(2)
  plot(Freq,20*log10(abs(Debit_spectre))) ;

% Calcul 2 : sonagramme
  Nfft    = 10000                ;
  NDebit  = 256                  ;
  Nover   = 8                    ;
  Fenetre = hanning(NDebit)      ;
  freq    = [0:Fech/Nfft:Fech/2] ;
  [Amp Freq Temps]   = specgram(Debit,Nfft,Fech,Fenetre,NDebit-Nover) ;
  Temps = Temps + NDebit/Fech    ;
  % Trac
  figure(3) ;
  imagesc(Temps,Freq(Nfft/2+1:-1:100),(abs(Amp(Nfft/2+1:-1:100,:)))) ;  % fin  l'indice 100 : suppression de la composante continue
  axis xy ;