#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <SDL/SDL.h>

Uint32 getpixel(SDL_Surface *surface, int x, int y);

int main(int argc, char** argv)
{
    SDL_Init(SDL_INIT_VIDEO);
    int hauteur,largeur,i,j;
    SDL_PixelFormat *fmt;
    Uint32 temp, pixel;
    Uint8 red, green, blue;


    FILE *fichierDonnees=fopen("donnees.txt","r+");
    FILE *fichierValeurs=fopen("valeurs.txt","w+");


    if (fichierDonnees==NULL || fichierValeurs==NULL) //test de l'ouverture des fichiers
    {
        exit(0);
    }


    SDL_Surface *photo=SDL_LoadBMP("photo.bmp");
    fmt=photo->format;

    fscanf(fichierDonnees, "taille photo : (svp ne pas changer la disposition des caracteres :) )\nhauteur : %d\nlargeur : %d", &hauteur, &largeur);



    for (i=0;i!=largeur;i++)
    {
        for (j=0;j!=hauteur;j++)
        {

            pixel=getpixel(photo,j,i);


            /* Get Red component */
            temp=pixel&fmt->Rmask; /* Isolate red component */
            temp=temp>>fmt->Rshift;/* Shift it down to 8-bit */
            temp=temp<<fmt->Rloss; /* Expand to a full 8-bit number */
            red=(Uint8)temp;

            /* Get Green component */
            temp=pixel&fmt->Gmask; /* Isolate green component */
            temp=temp>>fmt->Gshift;/* Shift it down to 8-bit */
            temp=temp<<fmt->Gloss; /* Expand to a full 8-bit number */
            green=(Uint8)temp;

            /* Get Blue component */
            temp=pixel&fmt->Bmask; /* Isolate blue component */
            temp=temp>>fmt->Bshift;/* Shift it down to 8-bit */
            temp=temp<<fmt->Bloss; /* Expand to a full 8-bit number */
            blue=(Uint8)temp;

            fprintf(fichierValeurs,"%d;",(red+green+blue)/3); //ceci est la formule magique a changer pour calculer la luminosit !
        }

        fprintf(fichierValeurs,"\n");
    }


    fclose(fichierDonnees);
    fclose(fichierValeurs);

    free(photo);

    SDL_Quit();

    return EXIT_SUCCESS;
}

Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;

    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch (bpp)
    {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if (SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;
    }
}

