#include "chemin_courant.h"

int nombre_de_dossiers_parent(void)
{
	struct stat repertoire_courant, repertoire_parent;
	int nombre_de_parents = 0;
	
	char *position = NULL, remonte[] = "/..";
	position = malloc(strlen(remonte) * sizeof(char));
	
	sprintf(position, "..");
	
	if(stat(".", &repertoire_courant) == -1)
	{
		perror("Pas d'information sur le repertoire courant\n");
		exit (EXIT_FAILURE);
	}
	
	if(stat("..", &repertoire_parent) == -1)
	{
		perror("Pas d'information sur le repertoire parent\n");
		exit (EXIT_FAILURE);
	}
		
	while( (repertoire_courant.st_dev != repertoire_parent.st_dev)
	    || (repertoire_courant.st_ino != repertoire_parent.st_ino))
	{
		if(stat(position, &repertoire_courant) == -1)
		{
			perror("Pas d'information sur le repertoire courant\n");
			exit (EXIT_FAILURE);
		}
		
		position = realloc(position, (strlen(position) + strlen(remonte)) * sizeof(char));
		strcat(position, remonte);
		
		if(stat(position, &repertoire_parent) == -1)
		{
			perror("Pas d'information sur le repertoire parent\n");
			exit (EXIT_FAILURE);
		}
		
		nombre_de_parents++;
	}
	
	free(position);
	return nombre_de_parents;
}

void nom_dossier_courant(char **nom_repertoire)
{
	DIR *repertoire = NULL;
	struct dirent *lecture_repertoire;
	struct stat repertoire_courant, tampon;
	
	int trouve = 0;
	
	if(stat(".", &repertoire_courant) == -1)
	{
		perror("Pas d'information sur le repertoire courant\n");
		exit (EXIT_FAILURE);
	}
	
	chdir("..");
	
	repertoire = opendir(".");
	
	while (!trouve)
	{
		lecture_repertoire = readdir(repertoire);
		if (stat(lecture_repertoire->d_name, &tampon) == -1)
		{
			perror("Can not stat directory") ;
		}
		
		/*Comme pour la racine, si un repertoire est specifie par le
		meme numero d'inode et le meme numero de device que le repertoire
		courant (le premier, avant le chdir(".."), alors, nous avons
		trouve notre candidat.*/
		if ((tampon.st_dev == repertoire_courant.st_dev)
		&& (tampon.st_ino == repertoire_courant.st_ino))
		{
			trouve = 1;
		}
	}
	
	*nom_repertoire = malloc((strlen(lecture_repertoire->d_name) + 1) * sizeof(char));
	
	sprintf(*nom_repertoire, "%s/", lecture_repertoire->d_name);
	chdir(*nom_repertoire);
	closedir(repertoire);
}

void chemin_courant(char **chemin)
{
	char **liste_repertoire = NULL;
	int nombre_de_parents = 0, taille = 0, i = 0;
	
	nombre_de_parents = nombre_de_dossiers_parent();
	
	liste_repertoire = malloc( (size_t)nombre_de_parents * sizeof(char*));
	
	for(i = 0 ; i < nombre_de_parents ; i++)
	{
		nom_dossier_courant(&(liste_repertoire[i]));
		taille += (int)strlen(liste_repertoire[i]);
		chdir("..");
	}
	
	*chemin = malloc((size_t)(taille + 2) * sizeof(char));
	(*chemin)[0] = '/';
	(*chemin)[1] = '\0';
	
	for(i = 0 ; i < nombre_de_parents ; i++)
	{
		strcat(*chemin, liste_repertoire[nombre_de_parents - i - 1]);
		free(liste_repertoire[nombre_de_parents - i - 1]);
	}
	
	free(liste_repertoire);
	chdir(*chemin);
}
