#include "createur_cmake.h"

static char **tableau_de_fichiers = NULL, **tableau_de_librairies = NULL;
static size_t taille_tableau_fichiers = 0, taille_tableau_librairies = 0;


int main(int argc, char *argv[])
{
	if(argc == 1)
	{
		printf("rentrer un nom de fichier en paramètre\nexemple :\n./createur_cmake test.c\n");
		return -1;
	}
	
	if(argc > 2)
	{
		printf("trop de paramètres\n");
		return -1;
	}
	
	
	recherche_dependances(argv[1]);
	creation_fichier_cmake(argv[1]);

	liberation_memoire_listes();
	
	/*
	system("cmake CMakeLists.txt");
	system("make clean all");
	*/
	return 1;
}

void fichier_sources_init(struct Structure_Fichier_H *p_Fichiers_sources)
{
	p_Fichiers_sources->p_dossier = NULL;
	p_Fichiers_sources->p_nom_du_fichier = NULL;
	p_Fichiers_sources->pp_liste_des_includes = NULL;
	p_Fichiers_sources->nombre_includes = 0;
}

void fichier_sources_dossier(char chemin[], struct Structure_Fichier_H *p_Fichiers_sources)
{
	if(p_Fichiers_sources->p_dossier == NULL)
	{
		p_Fichiers_sources->p_dossier = malloc((strlen(chemin) + 1) * sizeof(char));
	}
	else
	{
		p_Fichiers_sources->p_dossier = realloc(p_Fichiers_sources->p_dossier, (strlen(chemin) + 1) * sizeof(char));
	}
	
	strcpy(p_Fichiers_sources->p_dossier, chemin);
}

void fichier_sources_nom(char nom[], struct Structure_Fichier_H *p_Fichiers_sources)
{
	if(p_Fichiers_sources->p_nom_du_fichier == NULL)
	{
		p_Fichiers_sources->p_nom_du_fichier = malloc((strlen(nom) + 1) * sizeof(char));
	}
	else
	{
		p_Fichiers_sources->p_nom_du_fichier = realloc(p_Fichiers_sources->p_nom_du_fichier, (strlen(nom) + 1) * sizeof(char));
	}
	
	strcpy(p_Fichiers_sources->p_nom_du_fichier, nom);
}

void fichier_sources_ajout_include(char chaine[], struct Structure_Fichier_H *p_Fichiers_sources)
{
	p_Fichiers_sources->nombre_includes ++;
	if(p_Fichiers_sources->pp_liste_des_includes == NULL)
	{
		p_Fichiers_sources->pp_liste_des_includes = malloc(p_Fichiers_sources->nombre_includes * sizeof(char*));
	}
	else
	{
		p_Fichiers_sources->pp_liste_des_includes = realloc(p_Fichiers_sources->pp_liste_des_includes, p_Fichiers_sources->nombre_includes * sizeof(char*));
	}
	
	p_Fichiers_sources->pp_liste_des_includes[p_Fichiers_sources->nombre_includes - 1] = malloc( (strlen(chaine) + 1) * sizeof(char));
	strcpy(p_Fichiers_sources->pp_liste_des_includes[p_Fichiers_sources->nombre_includes - 1], chaine);
}

void fichier_sources_destruction(struct Structure_Fichier_H *p_Fichiers_sources)
{
	int i = 0;
	if(p_Fichiers_sources->p_dossier != NULL)
	{
		free(p_Fichiers_sources->p_dossier);
	}
	
	if(p_Fichiers_sources->p_nom_du_fichier != NULL)
	{
		free(p_Fichiers_sources->p_nom_du_fichier);
	}
	
	if(p_Fichiers_sources->nombre_includes != 0)
	{
		for(i = 0 ; i < (int)p_Fichiers_sources->nombre_includes ; i++)
		{
			free(p_Fichiers_sources->pp_liste_des_includes[i]);
		}
		free(p_Fichiers_sources->pp_liste_des_includes);
	}
}

/*****************************MANIPULATION DES CHAINES*****************************/
void decallage_chaine(char chaine[], int decallage)
{
	int i = 0, longueur = (int)strlen(chaine) + 1;
	
	if(decallage < longueur && decallage > 0)
	{
		for(i = 0 ; i < longueur - decallage ; i++)
		{
			chaine[i] = chaine[decallage + i];
		}
	}
}

int tronquer_chaine(char chaine[], char caractere)
{
	int i = 0;
	for(i = (int)strlen(chaine) - 1 ; i >= 0 ; i--)
	{
		if(chaine[i] == caractere)
		{
			chaine[i] = '\0';
			return 1;
		}
	}
	
	return -1;
}
/*****************************GESTION DES FICHIERS*****************************/
void generer_nom_fichier(struct Structure_Fichier_H *p_Fichiers_sources)
{
	int i = 0, j = 0, nombre_monte = 0;
	char *tampon = NULL, *chemin_tampon = NULL, *nom_tampon = NULL;
	
	chemin_tampon = malloc((strlen(p_Fichiers_sources->p_dossier) + 1) * sizeof(char));
	strcpy(chemin_tampon, p_Fichiers_sources->p_dossier);
	
	for(i = 0 ; i < (int)p_Fichiers_sources->nombre_includes ; i++)
	{
		/*si le caractere " apparait dans une chaine cela signifie qu'il s'agit d'un fichier et non d'une librairie*/
		if(strchr(p_Fichiers_sources->pp_liste_des_includes[i], '\"') != NULL)
		{
			/*on extrait alors ce qui se trouve entre les ""*/
			tampon = strtok(p_Fichiers_sources->pp_liste_des_includes[i], "\"");
			tampon = strtok(NULL, "\"");
			
			/*on stock ce nom dans une chaine tampon*/
			nom_tampon = malloc((strlen(tampon) + 1) * sizeof(char));
			strcpy(nom_tampon, tampon);
			
			/*on determine le nombre de dossier parent qu'il faut remonter*/
			nombre_monte = nombre_de_remonte(nom_tampon);
			
			/*on decalle la chaine pour faire disparaite la sous-chaine ../*/
			decallage_chaine(nom_tampon, 3 * nombre_monte);
			
			/*on tronque autant de fois que necessaire le nom du chemin a partir du caractere '/'*/
			for(j = 0 ; j <= nombre_monte ; j++)
			{
				tronquer_chaine(chemin_tampon, '/');
			}
			
			/*une fois les noms formate, on ecris dans la structure la combinaison des 2 chaines tampon*/
			p_Fichiers_sources->pp_liste_des_includes[i] = realloc(p_Fichiers_sources->pp_liste_des_includes[i], (strlen(chemin_tampon) + strlen(nom_tampon) + 2) * sizeof(char));
			sprintf(p_Fichiers_sources->pp_liste_des_includes[i], "%s/%s", chemin_tampon, nom_tampon);
			
			/*on recre le chemin tampon et on libere le nom_tampon pour recommencer l'operation*/
			strcpy(chemin_tampon, p_Fichiers_sources->p_dossier);
			free(nom_tampon);
		}
	}
	
	free(chemin_tampon);
}

void recherche_include(struct Structure_Fichier_H *p_Fichiers_sources)
{
	int i = 0;
	/*creation du chemin complet du fichier (repertoire + nom du fichier)*/
	char *nom_complet = NULL;
	
	struct Structure_fichier_texte Fichier;
	lecture_fichier_init(&Fichier);
	
	
	nom_complet = malloc( (strlen(p_Fichiers_sources->p_dossier) + strlen(p_Fichiers_sources->p_nom_du_fichier) + 1) * sizeof(char));
	nom_complet[0] = '\0';
	strcat(nom_complet, p_Fichiers_sources->p_dossier);
	strcat(nom_complet, p_Fichiers_sources->p_nom_du_fichier);
	
	lecture_fichier(nom_complet, &Fichier);
	
	/*recuperation des includes*/
	analyse_fichier_nombre_apparition("#include", &Fichier);
	analyse_fichier_numero_ligne("#include", &Fichier);
	
	for(i = 0 ; i < Fichier.nombre_apparition ; i++)
	{
		fichier_sources_ajout_include(Fichier.texte[Fichier.numero_ligne[i]], p_Fichiers_sources);
	}
	lecture_fichier_destruction(&Fichier);
	free(nom_complet);
}

int nombre_de_remonte(char chemin_fichier[])
{
	char *tampon = strstr(chemin_fichier, "../");
	int remonte = 0;
	while(tampon != NULL)
	{
		tampon = strstr(tampon + 3, "../");
		remonte ++;
	}
	return remonte;
}

/*****************************GESTION DES LISTES*****************************/
int recherche_liste(char **liste, int taille_liste, char nom[])
{
	int i = 0;
	
	if(liste == NULL)
	{
		return -1;
	}
	
	for(i = 0 ; i < taille_liste ; i++)
	{
		if(strcmp(nom, liste[i]) == 0)
		{
			return i;
		}
	}
	
	return -1;
}


void tri_des_donnees(struct Structure_Fichier_H Fichier[], int nombre_de_fichiers)
{
	int i = 0, j = 0, conversion = 1;
	char *nom_tampon = NULL;
	FILE *fichier = NULL;
	
	for(i = 0 ; i < nombre_de_fichiers ; i++)
	{
		for(j = 0 ; j < (int)Fichier[i].nombre_includes ; j++)
		{
			if(strchr(Fichier[i].pp_liste_des_includes[j], '#') == NULL)
			{
				if(recherche_liste(tableau_de_fichiers, (int)taille_tableau_fichiers, Fichier[i].pp_liste_des_includes[j]) == -1)
				{
					taille_tableau_fichiers ++;
					
					if(tableau_de_fichiers == NULL)
					{
						tableau_de_fichiers = malloc(taille_tableau_fichiers * sizeof(char*));
					}
					else
					{
						tableau_de_fichiers = realloc(tableau_de_fichiers, taille_tableau_fichiers * sizeof(char*));
					}
					
					tableau_de_fichiers[taille_tableau_fichiers - 1] = malloc((strlen(Fichier[i].pp_liste_des_includes[j]) + 1) * sizeof(char));
					strcpy(tableau_de_fichiers[taille_tableau_fichiers - 1], Fichier[i].pp_liste_des_includes[j]);
					
					nom_tampon = malloc((strlen(Fichier[i].pp_liste_des_includes[j]) + 1) * sizeof(char));
					strcpy(nom_tampon, Fichier[i].pp_liste_des_includes[j]);
					
					nom_tampon[strlen(nom_tampon) - 1] = 'c';
					
					fichier = fopen(nom_tampon, "r");
					if(fichier != NULL)
					{
						taille_tableau_fichiers ++;
						tableau_de_fichiers = realloc(tableau_de_fichiers, taille_tableau_fichiers * sizeof(char*));
						tableau_de_fichiers[taille_tableau_fichiers - 1] = malloc((strlen(nom_tampon) + 1) * sizeof(char));
						strcpy(tableau_de_fichiers[taille_tableau_fichiers - 1], nom_tampon);
						fclose(fichier);
					}
					
					free(nom_tampon);
				}
			}
			else
			{
				if(recherche_liste(tableau_de_librairies, (int)taille_tableau_librairies, Fichier[i].pp_liste_des_includes[j]) == -1)
				{
					taille_tableau_librairies ++;
					
					if(tableau_de_librairies == NULL)
					{
						tableau_de_librairies = malloc(taille_tableau_librairies * sizeof(char*));
					}
					else
					{
						tableau_de_librairies = realloc(tableau_de_librairies, taille_tableau_librairies * sizeof(char*));
					}
					
					tableau_de_librairies[taille_tableau_librairies - 1] = malloc((strlen(Fichier[i].pp_liste_des_includes[j]) + 1) * sizeof(char));
					strcpy(tableau_de_librairies[taille_tableau_librairies - 1], Fichier[i].pp_liste_des_includes[j]);
				}
			}
		}
	}
	
	for(i = 0 ; i < (int)taille_tableau_librairies ; i++)
	{conversion *= conversion_librairies(tableau_de_librairies[i]);}
	if(conversion == 0)
	{printf("la ou les librairies inconnues sont à rajouter dans le fichier : librairies.txt\nprocédez de la manière suivante :\nle fichier .h et à la ligne suivante le lien\n\nExemple :\nlib : GL/gl.h\n-lGL\n\n");}
}

int conversion_librairies(char chaine[])
{
	FILE *fichier = NULL;
	fichier = fopen("librairies.txt", "r+");
	if(fichier != NULL)
	{
		int i = 0;
		
		struct Structure_fichier_texte Fichier_librairies;
		lecture_fichier_init(&Fichier_librairies);
		
		lecture_fichier("librairies.txt", &Fichier_librairies);
		
		/*analyse_fichier_nombre_apparition("lib : ", &Fichier_librairies);*/
		analyse_fichier_texte("lib : ", &Fichier_librairies);
		analyse_fichier_numero_ligne("lib : ", &Fichier_librairies);
		
		fclose(fichier);
		for(i = 0 ; i < Fichier_librairies.nombre_apparition ; i++)
		{
			if(strstr(chaine, Fichier_librairies.chaine[i]) != NULL)
			{
				if(Fichier_librairies.numero_ligne[i] + 1 < Fichier_librairies.nombre_de_lignes)
				{strcpy(chaine, Fichier_librairies.texte[Fichier_librairies.numero_ligne[i] + 1]);}
				else {chaine[0] = '\0';}
				return 1;
			}
		}
		
		couleur(ROUGE);
		printf("librairie inconnue : %s\n", chaine);
		couleur("0");
		chaine[0] = '\0';
		lecture_fichier_destruction(&Fichier_librairies);
		return 0;
	}
	else
	{
		//creation d'un fichier par defaut
		fichier = fopen("librairies.txt", "w+");
		
		fprintf(fichier, "lib : GL/gl.h\n-lGL\n\nlib : GL/glu.h\n-lGLU\n\nlib : FTGL/ftgl.h\n-lftgl\n\nlib : SDL/SDL.h\n-lSDLmain -lSDL\n\nlib : SDL/SDL_ttf.h\n-lSDL_ttf\n\nlib : SDL/SDL_image.h\n-lSDL_image\n\nlib : math.h\n-lm\n\nlib : stdio.h\n\n\nlib : stdlib.h\n\n\nlib : string.h\n\n\nlib : opencv/highgui.h\n-lhighgui\n\nlib : opencv/cv.h\n-lcv\n\n");
		fclose(fichier);
		conversion_librairies(chaine);
	}
	return 0;
}

void liberation_memoire_listes(void)
{
	int i = 0;
	if(tableau_de_fichiers != NULL)
	{
		for(i = 0 ; i < (int)taille_tableau_fichiers ; i++)
		{
			free(tableau_de_fichiers[i]);
		}
		free(tableau_de_fichiers);
	}
	
	if(tableau_de_librairies != NULL)
	{
		for(i = 0 ; i < (int)taille_tableau_librairies ; i++)
		{
			free(tableau_de_librairies[i]);
		}
		free(tableau_de_librairies);
	}
}

int recherche_fichier_existant(char nom_du_fichier[], struct Structure_Fichier_H Fichiers_sources[], int nombre_de_fichiers)
{
	int i = 0;
	char *nom_complet = NULL;
	for(i = 0 ; i < nombre_de_fichiers ; i++)
	{
		nom_complet = malloc((strlen(Fichiers_sources[i].p_dossier) + strlen(Fichiers_sources[i].p_nom_du_fichier) + 1) * sizeof(char));
		sprintf(nom_complet, "%s%s", Fichiers_sources[i].p_dossier, Fichiers_sources[i].p_nom_du_fichier);
		
		if(strcmp(nom_complet, nom_du_fichier) == 0)
		{
			return 1;
		}
	}
	return -1;
}

int recherche_dependances(char nom_du_fichier[])
{
	/*determination du chemin courant*/
	char *dossier_courant = NULL;
	int i = 0, j = 0, nombre_de_fichiers = 1;
	
	struct Structure_Fichier_H *p_Fichiers_sources;
	p_Fichiers_sources = malloc(sizeof(struct Structure_Fichier_H));
	
	fichier_sources_init(&(p_Fichiers_sources[0]));
	
	/*creation du premier fichier, celui contenant la fonction main*/
	chemin_courant(&dossier_courant);
	fichier_sources_dossier(dossier_courant, &(p_Fichiers_sources[0]));
	fichier_sources_nom(nom_du_fichier, &(p_Fichiers_sources[0]));
	free(dossier_courant);
	
	/*recherche et creation des noms des fichiers en include*/
	recherche_include(&(p_Fichiers_sources[0]));
	generer_nom_fichier(&(p_Fichiers_sources[0]));
	
	
	/*************************GESTION ET RECHERCHE DES NOMS DES FICHIERS*************************/
	for(i = 0 ; i < nombre_de_fichiers ; i++)
	{
		for(j = 0 ; j < (int)p_Fichiers_sources[i].nombre_includes ; j++)
		{
			/*dans cette partie on ne traitera pas les librairies
			la fonction : generer_nom_fichier va extraire le nom du fichier et de ce fait
			#include n'apparaitra plus, si la fonction strchr ne trouve pas de # cela veut
			dire qu'il s'agit du nom d'un fichier et qu'il faut donc l'ouvrir et le traiter.
			*/
			
			if(recherche_fichier_existant(p_Fichiers_sources[i].pp_liste_des_includes[j], p_Fichiers_sources, nombre_de_fichiers) != 1)
			{
				if( strchr(p_Fichiers_sources[i].pp_liste_des_includes[j], '#') == NULL)
				{
					nombre_de_fichiers ++;

					/*creation d'un nouvel element du tableau, reallocation initialisation*/
					p_Fichiers_sources = realloc(p_Fichiers_sources, (size_t)nombre_de_fichiers * sizeof(struct Structure_Fichier_H));
					fichier_sources_init(&p_Fichiers_sources[nombre_de_fichiers - 1]);
					
					/*creation du chemin du dossier*/
					fichier_sources_dossier(p_Fichiers_sources[i].pp_liste_des_includes[j], &p_Fichiers_sources[nombre_de_fichiers - 1]);
					tronquer_chaine(p_Fichiers_sources[nombre_de_fichiers - 1].p_dossier, '/');
					strcat(p_Fichiers_sources[nombre_de_fichiers - 1].p_dossier, "/");
					
					/*recherche du nom du fichier*/
					fichier_sources_nom(p_Fichiers_sources[i].pp_liste_des_includes[j], &p_Fichiers_sources[nombre_de_fichiers - 1]);
					decallage_chaine(p_Fichiers_sources[nombre_de_fichiers - 1].p_nom_du_fichier, (int)strlen(p_Fichiers_sources[nombre_de_fichiers - 1]. p_dossier));
					
					/*recherche et generation du nom des includes*/
					recherche_include(&p_Fichiers_sources[nombre_de_fichiers - 1]);
					generer_nom_fichier(&p_Fichiers_sources[nombre_de_fichiers - 1]);
				}
			}
		}
	}
	/*************************FIN DE GESTION ET RECHERCHE DES NOMS DES FICHIERS*************************/

	
	tri_des_donnees(p_Fichiers_sources, nombre_de_fichiers);
	
	for(i = 0 ; i < nombre_de_fichiers ; i++)
	{
		fichier_sources_destruction(&(p_Fichiers_sources[i]));
	}
	free(p_Fichiers_sources);
	return nombre_de_fichiers;
}

void creation_fichier_cmake(char nom_fichier[])
{
	int i = 0;
	char *nom_tampon = NULL;
	FILE *fichier = NULL;
	
	nom_tampon = malloc((strlen(nom_fichier) + 1) * sizeof(char));
	strcpy(nom_tampon, nom_fichier);
	
	/*on tronque ne nom du fichier pour obtenir le nom du projet*/
	nom_tampon[strlen(nom_tampon) - 2] = '\0';
	
	fichier = fopen("CMakeLists.txt", "w+");
	
	
	
	fprintf(fichier, "cmake_minimum_required(VERSION 2.6)\n\nproject(%s)\n\nadd_executable(%s\n%s\n", nom_tampon, nom_tampon, nom_fichier);
	
	for(i = 0 ; i < (int)taille_tableau_fichiers ; i++)
	{
		fprintf(fichier, "\"%s\"\n", tableau_de_fichiers[i]);
	}
	fprintf(fichier, ")\n");
	
	fprintf(fichier, "target_link_libraries(%s\n", nom_tampon);
	
	for(i = 0 ; i < (int)taille_tableau_librairies ; i++)
	{
		if(tableau_de_librairies[i][0] != '\0')
		{fprintf(fichier, "%s ", tableau_de_librairies[i]);}
	}
	
	fprintf(fichier, ")\n");
	
	fprintf(fichier, "set_target_properties(%s PROPERTIES COMPILE_FLAGS \" -Werror -g -std=c99 -pedantic -Wall -Wextra -Wformat=2 -Wconversion -Wwrite-strings -Wstrict-prototypes -Wfloat-equal -Wunreachable-code\")\n", nom_tampon);
	
	fclose(fichier);
	free(nom_tampon);
}


