#ifndef CREATEUR_CMAKE_H
#define CREATEUR_CMAKE_H

#include <stdlib.h>
#include <stdio.h>

#include "lecture_fichier.h"
#include "chemin_courant.h"

struct Structure_Fichier_H
{
	char *p_dossier, *p_nom_du_fichier, **pp_liste_des_includes;
	size_t nombre_includes;
};

/*****************************STRUCTURE FICHIER_SOURCES*****************************/
void fichier_sources_init(struct Structure_Fichier_H *p_Fichiers_sources);
void fichier_sources_dossier(char chemin[], struct Structure_Fichier_H *p_Fichiers_sources);
void fichier_sources_nom(char nom[], struct Structure_Fichier_H *p_Fichiers_sources);
void fichier_sources_ajout_include(char chaine[], struct Structure_Fichier_H *p_Fichiers_sources);
void fichier_sources_destruction(struct Structure_Fichier_H *p_Fichiers_sources);

/*****************************MANIPULATION DES CHAINES*****************************/
void decallage_chaine(char chaine[], int decallage);
int tronquer_chaine(char chaine[], char caractere);

/*****************************GESTION DES FICHIERS*****************************/
void generer_nom_fichier(struct Structure_Fichier_H *p_Fichiers_sources);
void recherche_include(struct Structure_Fichier_H *p_Fichiers_sources);
int nombre_de_remonte(char chemin_fichier[]);

/*****************************GESTION DES LISTES*****************************/
int recherche_liste(char **liste, int taille_liste, char nom[]);
void tri_des_donnees(struct Structure_Fichier_H Fichier[], int nombre_de_fichiers);
int conversion_librairies(char chaine[]);
void liberation_memoire_listes(void);

int recherche_fichier_existant(char nom_du_fichier[], struct Structure_Fichier_H Fichiers_sources[], int nombre_de_fichiers);
int recherche_dependances(char nom_du_fichier[]);
void creation_fichier_cmake(char nom_fichier[]);

#endif
