#include "lecture_fichier.h"

void lecture_fichier_init(struct Structure_fichier_texte *p_Fichier_texte)
{
	p_Fichier_texte->texte = NULL;
	p_Fichier_texte->nombre_caracteres_par_ligne = NULL;
	p_Fichier_texte->nombre_de_lignes = 0;
	
	p_Fichier_texte->nombre_apparition = 0;
	p_Fichier_texte->numero_ligne = NULL;
	p_Fichier_texte->valeur = NULL;
	p_Fichier_texte->chaine = NULL;
}

void lecture_fichier_destruction(struct Structure_fichier_texte *p_Fichier_texte)
{
	int i = 0;
	for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
	{
	  	free(p_Fichier_texte->texte[i]);
	}
	free(p_Fichier_texte->texte);
	free(p_Fichier_texte->nombre_caracteres_par_ligne);
	
	/*cette fonction libere la memoire utilise pour la lecture du fichier, elle est a appele
	lorsque que le pointeur sur la Structure_fichier_texte ne sera plus utilise*/
	
	free(p_Fichier_texte->chaine);
	free(p_Fichier_texte->numero_ligne);
	free(p_Fichier_texte->valeur);
}

/***************************LECTURE FICHIER***************************/
int lecture_fichier_test_ouverture(FILE *p_fichier, const char nom_du_fichier[])
{
  	if(p_fichier == NULL)
	{
		couleur(ROUGE);
		printf("impossible d'ouvrir le fichier : %s\n", nom_du_fichier);
		couleur("0");
		return 0;
	}
	else{
	  	couleur(VERT);
		printf("ouverture du fichier : %s\n", nom_du_fichier);
		couleur("0");
		return 1;
	}
	
	/*Cette fonction est un simple test d'ouverture, si jamais le fichier n'a pas pu etre ouvert
	alors cette fonction retourne 0 avec un message d'erreur dans la console (en rouge), dans le cas contraire
	elle affichera le nom du fichier ouvert (toujours dans la console mais en vert cette fois ci)*/
}

int lecture_fichier_nombre_de_lignes(FILE *p_fichier)
{
	/*on commence par revenir au début du fichier*/
	int nombre_de_lignes = 1;
	char caractere = '0';
	
	rewind(p_fichier);
	/*tant que le caractere lu ne correspond pas a la fin du fichier on lit le fichier*/
	while(caractere != EOF)
	{
		caractere = (char)fgetc(p_fichier);
		
		/*si le caractere lu est : \n (retour a la ligne) alors on incremente le nombre de ligne*/
		if(caractere == '\n')
		{nombre_de_lignes ++;}
	}
	
	return nombre_de_lignes;
}

int lecture_fichier_nombre_caracteres_par_ligne(FILE *p_fichier, int **pp_nombre_de_caracteres_par_ligne)
{
	int i = 0, nombre_de_lignes = 0;
	char caractere = '0';
	
	if(*pp_nombre_de_caracteres_par_ligne != NULL)
	{
		couleur(ROUGE);
		printf("fonction : lecture_fichier_nombre_caracteres_par_ligne\n ATTENTION VARIABLE NON INITIALISEE\n");
		couleur("0");
		return 0;
	}
	
	/*on recupere le nombre de ligne*/
	nombre_de_lignes = lecture_fichier_nombre_de_lignes(p_fichier);
	
	/*on initialise le tableau devant contenir le nombre de caracteres par ligne*/
	*pp_nombre_de_caracteres_par_ligne = malloc((size_t)nombre_de_lignes * sizeof(int));
	for(i = 0 ; i < nombre_de_lignes ; i++)
	{
		*(*pp_nombre_de_caracteres_par_ligne + i) = 0;
	}
	
	
	i = 0;
	rewind(p_fichier);
	do
	{
		caractere = (char)fgetc(p_fichier);
		(*(*pp_nombre_de_caracteres_par_ligne + i)) ++;
		if(caractere == '\n')
		{i ++;}
	}while(caractere != EOF);
	return 1;
}

int lecture_fichier(const char nom_du_fichier[], struct Structure_fichier_texte *p_Fichier_texte)
{  
	FILE *fichier = NULL;
	char caractere = '0';
	int i = 0, j = 0;
	
	/*ouverture du fichier et test de l'ouverture*/
	fichier = fopen(nom_du_fichier, "r");
	if(lecture_fichier_test_ouverture(fichier, nom_du_fichier) == 0)
	{return 0;}
	
	/*recuperation du nombre de lignes*/
	p_Fichier_texte->nombre_de_lignes = lecture_fichier_nombre_de_lignes(fichier);
	
	/*recuperation du nombre de caracteres contenu dans chaque ligne*/
	lecture_fichier_nombre_caracteres_par_ligne(fichier, &(p_Fichier_texte->nombre_caracteres_par_ligne));
	
	/*allocation du tableau 2D contenant les caracteres*/
	if(p_Fichier_texte->texte != NULL)
	{
		couleur(ROUGE);
		printf("fonction : lecture_fichier\n ATTENTION VARIABLE NON INITIALISEE\n");
		couleur("0");
		return 0;
	}
	p_Fichier_texte->texte = malloc( (size_t)p_Fichier_texte->nombre_de_lignes * sizeof(char*));
	for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
	{
		p_Fichier_texte->texte[i] = malloc( (size_t)p_Fichier_texte->nombre_caracteres_par_ligne[i] * sizeof(char));
	}
	
	
	/*retour au debut du fichier*/
	i = 0; j = 0;
	rewind(fichier);
	do 
	{
		/*recuperation de tous les caracteres du fichier*/
		caractere = (char)fgetc(fichier);
		switch (caractere)
		{
			case EOF:
			  p_Fichier_texte->texte[i][j] = '\0';
			  fclose(fichier);
			  return 1;
			  break;
			  
			case '\r':
			  p_Fichier_texte->texte[i][j] = '\0';
			  break;
			  
			case '\n':
			  p_Fichier_texte->texte[i][j] = '\0';
			  i++;
			  j = 0;
			  break;

			default:
			  p_Fichier_texte->texte[i][j] = caractere;
			  j++;
			  break;
		}
	}while(caractere != EOF);	/*jusqu'a ce que le caractere lu correspond a la fin du fichier*/
	
	return 0;
}

/***************************ANALYSE FICHIER***************************/

int analyse_fichier_nombre_apparition(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte)
{
	int i = 0;
	
	if(p_Fichier_texte->texte == NULL)
	{
		couleur(ROUGE);
		printf("fonction : analyse_fichier_nombre_apparition\nATTENTION PAS DE TEXTE EN MEMOIRE\n");
		couleur("0");
		return 0;
	}

	p_Fichier_texte->nombre_apparition = 0;
	
	/*On parcourt toutes les lignes*/
	for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
	{
		/*des qu'on trouve la chaine en question on incremente l'occurence*/
		if(strstr(p_Fichier_texte->texte[i], chaine) != NULL)
		{p_Fichier_texte->nombre_apparition ++;}
	}
	
	/*Si le nombre d'apparrition est nul*/
	if(p_Fichier_texte->nombre_apparition == 0)
	{
		printf("chaine non trouvée : %s\n", chaine);
		return 0;
	}
	
	return p_Fichier_texte->nombre_apparition;
}

int analyse_fichier_numero_ligne(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte)
{
	int i = 0, j = 0;
	analyse_fichier_nombre_apparition(chaine, p_Fichier_texte);
	
	if(p_Fichier_texte->nombre_apparition != 0)
	{
		if(p_Fichier_texte->numero_ligne != NULL)
		{
			free(p_Fichier_texte->numero_ligne);
		}
		p_Fichier_texte->numero_ligne = malloc((size_t)p_Fichier_texte->nombre_apparition * sizeof(int));
		
		for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
		{
			/*des qu'on trouve la chaine en question on incremente l'occurence*/
			if(strstr(p_Fichier_texte->texte[i], chaine) != NULL)
			{
				p_Fichier_texte->numero_ligne[j] = i;
				j++;
			}
		}
	}
	return p_Fichier_texte->nombre_apparition;
}

int analyse_fichier_valeur(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte)
{
	/*cette fonction recupere la valeur se trouvant apres la chaine recherchee*/
	char *suite_chaine = NULL;
	int i = 0, j = 0;
	analyse_fichier_nombre_apparition(chaine, p_Fichier_texte);
	
	if(p_Fichier_texte->nombre_apparition != 0)
	{
		if(p_Fichier_texte->valeur != NULL)
		{
			free(p_Fichier_texte->valeur);
		}
		p_Fichier_texte->valeur = malloc((size_t)p_Fichier_texte->nombre_apparition * sizeof(double));
		
		for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
		{
			if(strstr(p_Fichier_texte->texte[i], chaine) != NULL)
			{
				suite_chaine = strstr(p_Fichier_texte->texte[i], chaine);
				p_Fichier_texte->valeur[j] = strtod((suite_chaine + strlen(chaine) + 1), NULL);
				j++;
			}
		}
	}
	return p_Fichier_texte->nombre_apparition;
}

int analyse_fichier_texte(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte)
{
	/*cette fonction recupere la chaine de caractere se trouvant apres la chaine recherchee*/
	char *suite_chaine = NULL;
	int i = 0, j = 0;
	analyse_fichier_nombre_apparition(chaine, p_Fichier_texte);
	
	if(p_Fichier_texte->nombre_apparition != 0)
	{
		if(p_Fichier_texte->chaine != NULL)
		{
			free(p_Fichier_texte->chaine);
		}
		p_Fichier_texte->chaine = malloc((size_t)p_Fichier_texte->nombre_apparition * sizeof(char*));
		
		for(i = 0 ; i < p_Fichier_texte->nombre_de_lignes ; i++)
		{
			if(strstr(p_Fichier_texte->texte[i], chaine) != NULL)
			{
				suite_chaine = strstr(p_Fichier_texte->texte[i], chaine);
				p_Fichier_texte->chaine[j] = (suite_chaine + strlen(chaine));
				j++;
			}
		}
	}
	return p_Fichier_texte->nombre_apparition;
}




