#ifndef LECTURE_FICHIER_H
#define LECTURE_FICHIER_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "couleur.h"

struct Structure_fichier_texte
{
	/*Variables pour contenir le fichier texte*/
	char **texte;
	int nombre_de_lignes, *nombre_caracteres_par_ligne;

	/*Variables pour effectuer des recherches dans le texte*/
	int nombre_apparition, *numero_ligne;
	double *valeur;
	char **chaine;
	/*Attention cette derniere variable est utilise comme un tableau de pointeur
	et non comme un tableau 2D*/
};

void lecture_fichier_init(struct Structure_fichier_texte *p_Fichier_texte);
void lecture_fichier_destruction(struct Structure_fichier_texte *p_Fichier_texte);

/***************************LECTURE FICHIER***************************/
int lecture_fichier_test_ouverture(FILE *p_fichier, const char nom_du_fichier[]);
int lecture_fichier_nombre_de_lignes(FILE *p_fichier);
int lecture_fichier_nombre_caracteres_par_ligne(FILE *p_fichier, int **pp_nombre_de_caracteres_par_ligne);
int lecture_fichier(const char nom_du_fichier[], struct Structure_fichier_texte *p_Fichier_texte);

/***************************ANALYSE FICHIER***************************/

int analyse_fichier_nombre_apparition(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte);
int analyse_fichier_numero_ligne(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte);
int analyse_fichier_valeur(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte);
int analyse_fichier_texte(const char chaine[], struct Structure_fichier_texte *p_Fichier_texte);

#endif
