#include <stdio.h>
#include <stdlib.h>

typedef struct s_board {
  int dimension;
  int dimR;
  int dimC;

  int offset_row;
  int offset_col;
  int** board;
} *Board;

int in_real_board(Board board, int row, int col)
{
  return ( ( (row>=board->offset_row) && (row<board->offset_row+board->dimension) ) &&
      ( (col>=board->offset_col) && (col<board->offset_col+board->dimension) ) ) ;
}

Board read_input()
{
  Board board;
  int i,j;
  int val;

  board = (Board) malloc(sizeof(struct s_board));
  scanf("%d",&(board->dimension));
  board->dimR=board->dimension+2*4;
  board->dimC=board->dimension+2*4;
  board->offset_row=4;
  board->offset_col=4;

  board->board=(int**)malloc(sizeof(int*)*board->dimR);
  for(i=0;i<board->dimR;i++) {
    board->board[i]=(int*)malloc(sizeof(int)*board->dimC);
    for(j=0;j<board->dimC;j++) {
      if (in_real_board(board,i,j))
        scanf("%d", &val);
      else
        val=0;
      board->board[i][j]=val;
    }
  }
  return board;
}

void free_board(Board* pb)
{
  int i;
  if ( (pb==NULL) || (*pb==NULL) ) return;
  for(i=0;i<(*pb)->dimR;i++)
    free((*pb)->board[i]);
  free((*pb)->board);
  free(*pb);
  *pb=NULL;
}

void display_board(Board board)
{
  int i,j;

  printf("Board\n");
  printf("Dimension  : %d\n", board->dimension);
  printf("Dim row    : %d\n", board->dimR);
  printf("Dim col    : %d\n", board->dimC);
  printf("Offset row : %d\n", board->offset_row);
  printf("Offset col : %d\n", board->offset_col);
  for(i=0;i<board->dimR;i++) {
    for(j=0;j<board->dimC;j++)
      printf("%d%c",board->board[i][j], in_real_board(board,i,j)?'.':' ');
    printf("\n");
  }
  printf("\n");
}

int check_board(Board board, int row, int col, int delta_row, int delta_col)
{
  int i,j,k,val;
  val=board->board[row][col];
  if (val==0) return 0;
  i=delta_row;
  j=delta_col;
  k=0;
  while (board->board[row+i][col+j] == val ) {
    i=i+delta_row;
    j=j+delta_col;
    k++;
  }
  if (k==4) return val;
  else      return 0;
}

int check_victory(Board board)
{
  int i,j,val;
  for(i=board->offset_row;i<board->offset_row+board->dimension;i++)
    for(j=board->offset_col;j<board->offset_col+board->dimension;j++)
      if ( (val=check_board(board,i,j,-1,1)) )
        return val;
      else if ( (val=check_board(board,i,j,0,1)) )
        return val;
      else if ( (val=check_board(board,i,j,1,1)) )
        return val;
      else if ( (val=check_board(board,i,j,1,0)) )
        return val;
  return 0;
}

int main()
{
  Board board;

  board=read_input();
#ifdef DEBUG
  display_board(board);
#endif
  printf("%d\n", check_victory(board));
  free_board(&board);
  return 0;
}
