#include "global.h"
#include "moteur.h"
#include "IR.h"

// routine calcule distance

void cal_dis ()
{

    for (;;)
    {
        OS_Flag_Init(F_Dist,0x00);
        ADCON0 &= 0xFF;
        ADCON1 &= 0xFF;
        ADCON2 &= 0xFF;

        GO_bit = 1;
        OS_Wait(!NOT_DONE_bit);   // attente conversion

        CurrentDist = ADRESL;

                  // nouvelle valeur distance
        OS_Flag_Init(F_Dist,0x01);
        OS_Delay(100);
    }
}

// routine tache IR

void TaskIR()
{

    for (;;)
        {
             OS_Flag_Wait_On (MainFlag, 0x01);
             switch (IRFonction)
                {
                        case IR_NORMAL:
                                       OS_Flag_Wait_On(F_Dist,0x01);
                                       if (( CurrentDist > 0) && ( CurrentDist > DistanceMin))
                                       {
                                                 // Obstacle found: Stop the robot
                                                 ChangeMotor(MOT_STOP);

                                                 IRFonction = IR_SCAN_1;

                                                 // signal the distance mini reached
                                                 OS_Squeue_Send(MainSQueue, 'D');
                                        }
                                                 break;

                        case IR_SCAN_1:
                                       // init du Scan, tourner le robot
                                       Angle = tAngle[AngleIndice];
                                       TournerRobot(Angle);
                                       IRFonction = IR_SCAN_2;
                                                  break;

                        case IR_SCAN_2:
                                       //tester la dist
                                       OS_Flag_Wait_On(F_Dist,0x01);
                                       if (( CurrentDist>0) && ( CurrentDist > DistanceMin) && (AngleIndice < 3))
                                          {
                                             AngleIndice++;
                                             IRFonction = IR_SCAN_1;
                                          }
                                       if ((CurrentDist>0) && ( CurrentDist <= DistanceMin) && (AngleIndice < 4))
                                          {
                                             AngleIndice = 0;
                                             OS_Squeue_Send(MainSQueue, 'S');
                                             IRFonction = IR_NORMAL;
                                          }
                                       if ((CurrentDist>0) && ( CurrentDist > DistanceMin) && (AngleIndice = 3))
                                          {
                                             AngleIndice = 0;
                                             Angle = -20;
                                             IRFonction = IR_NORMAL;
                                             OS_Squeue_Send(MainSQueue, 'M');

                                           }
                                                  break;

                }
        }
}

// init ir

#pragma funcall InitIR TaskIR

void InitIR()
{

    IRFonction = IR_NORMAL;

           // Create the IR task
    OS_Task_Create(6, TaskIR);
}