#include "global.h"
#include "clavier.h"
#include "moteur.h"
#include "initialisation.h"
#include "interruption.h"
#include "IR.h"


OST_SQUEUE MainSQueue;
OST_FLAG   MainFlag;
static OST_SMSG smsg_queue;
// ----------------------------------------------
// main
// ----------------------------------------------
void TaskMain()
{
        OST_SMSG smsg;
        char         b;

        // Create the queue
        OS_Squeue_Create(MainSQueue, smsg_queue, 5);

    for (;;)
    {
        OS_Squeue_Wait(MainSQueue, smsg);
            switch (smsg)
            {
                        case 'K':        // clavier
                                b = LireClav();
                                if (b & 0x02)
                                   {
                                      ChangeMoteur(MOT_ON);
                                      ChangeMoteur(MOT_AVANT);
                                      OS_Flag_Init(MainFlag, 1);        // start US Module
                                   }
                                if (b & 0x1)
                                   {
                                      ChangeMoteur(MOT_OFF);
                                      ChangeMoteur(MOT_STOP);
                                      OS_Flag_Init(MainFlag, 0);        // stop US Module
                                   }
                                      break;

                        case 'S':        // message IR espace trouv
                                      ChangeMoteur(MOT_AVANT);
                                      break;

                        case 'M':        // message IR espace non-trouv
                                      TournerRobot(Angle);
                                      ChangeMoteur(MOT_AVANT);
                                      break;
            }
     }
}

#pragma funcall main TaskMain

void main() {

            // OSA Initialisation
    OS_Init();

              // Application Initialisation
    InitAppli();

                // Creer la tache principale
    OS_Task_Create(5, TaskMain);

    OS_EI();         // Enable interrupts
    OS_Run();

}