#include "global.h"
#include "moteur.h"

//   definitions commandes moteurs
#define MOT_OFF                        0
#define MOT_ON                        1
#define MOT_STOP                      2
#define MOT_AVANT                     3
#define MOT_ARRIERE         4
#define MOT_DROITE          5
#define MOT_GAUCHE          6
#define MOT_TOT_DROITE                7
#define MOT_TOT_GAUCHE                8

#define GAUCHE_STOP                {PORTA2_bit=0; PORTA3_bit=0;}
#define GAUCHE_FORWARD             {PORTA2_bit=1; PORTA3_bit=0;}
#define GAUCHE_REVERSE             {PORTA2_bit=0; PORTA3_bit=1;}
#define DROITE_STOP               {PORTA4_bit=0; PORTA5_bit=0;}
#define DROITE_FORWARD            {PORTA4_bit=1; PORTA5_bit=0;}
#define DROITE_REVERSE            {PORTA4_bit=0; PORTA5_bit=1;}


static int                fMotorOn = 0;

// Initialisation du moteur

void InitMoteur()
{
        ChangeMoteur(MOT_OFF);
}

// Modification du sens du moteur

void ChangeMoteur(int bSens)
{
        switch (bSens)
        {
                case MOT_OFF:
                        fMotorOn = 0;
                        break;

                case MOT_ON:
                        fMotorOn = 1;
                        break;

                case MOT_STOP:
                        GAUCHE_STOP;
                        DROITE_STOP;
                        break;

                case MOT_AVANT:
                        if (fMotorOn) {
                                GAUCHE_FORWARD;
                                DROITE_FORWARD;
                        }
                        break;

                case MOT_ARRIERE:
                        if (fMotorOn) {
                                GAUCHE_REVERSE;
                                DROITE_REVERSE;
                        }
                        break;

                case MOT_DROITE:
                        if (fMotorOn) {
                                GAUCHE_FORWARD;
                                DROITE_STOP;
                        }
                        break;

                case MOT_GAUCHE:
                        if (fMotorOn) {
                                GAUCHE_STOP;
                                DROITE_FORWARD;
                        }
                        break;

                case MOT_TOT_DROITE:
                        if (fMotorOn) {
                                GAUCHE_FORWARD;
                                DROITE_REVERSE;
                        }
                        break;

                case MOT_TOT_GAUCHE:
                        if (fMotorOn) {
                                GAUCHE_REVERSE;
                                DROITE_FORWARD;
                        }
                        break;
        }
}

//

void TournerRobot(int Angle)
{
     int Direction;
        int i;

        if (Angle > 0)
        {
                Direction = MOT_DROITE;
        }
        else if (Angle < 0)
        {
                Direction = MOT_GAUCHE;
                Angle = - Angle;
        }
        else
                return;

        ChangeMoteur(Direction);
        i = 2 * Angle;
        while (i-- > 0)
                 Delay_ms(100);

        ChangeMoteur(MOT_STOP);
}