#include "othellier.h"
#include <stdio.h>
#include <stdlib.h>

//L'initialisation de l'othellier (donne en cours)
Othellier init(){
	Othellier oth;
	int i;
	for (i=0; i<100;i++) {
		if ( (i<10) || (i% 10 == 0) || ((i+1)%10 == 0) || (i>89) )
			oth.Case[i] = BORD;
		else oth.Case[i] = VIDE;
	}
	oth.Case[45] = oth.Case[54] = BLANC;
	oth.Case[44] = oth.Case[55] = NOIR;
	oth.materiel[NOIR] = 2;
	oth.materiel[BLANC] = 2;
	return oth;
}


void affiche (partie p){
	int n = 0;
	int i,j;
	for(i=81;i>=11;i-=10){
		n++;
		printf("   +---+---+---+---+---+---+---+---+\n");
		printf(" %d |",n);
		for (j=i;j<=(i+7);j++){              
		if (p.othellier.Case[j] != VIDE) {
			if(p.othellier.Case[j] == NOIR) printf("\033[31m X \033[0m|");
			else printf("\033[34m O \033[0m|");       
			}                                     
		else printf("   |");
		}printf("\n");
	}
	printf("   +---+---+---+---+---+---+---+---+\n");         
	printf("\n");
	printf("     1   2   3   4   5   6   7   8\n");
	printf("\n");
	printf("NOIR   : %d\n",p.othellier.materiel[NOIR]);
	printf("BLANC  : %d\n",p.othellier.materiel[BLANC]);
	printf("           -----------------\n");
}

/* Vérifier qui est le gagnant */
int bloque(Othellier oth){
	int i;
	for (i=0;i<MAX_CASE; i++){						//on parcourt l'othellier
		if(oth.Case[i] == VIDE) return 0;			//on continue
		else{										//on compte les nombres des cases blanches et noires
			if (oth.Case[i] == NOIR) oth.materiel[NOIR]++;
			else if (oth.Case[i] == BLANC) oth.materiel[BLANC]++;
			}
		}
	if (oth.materiel[BLANC]>oth.materiel[NOIR]) printf ("\nJoueur 1 a gagné!\n");
    else if (oth.materiel[BLANC]<oth.materiel[NOIR]) printf ("\nJoueur 2 a gagné!\n");
    else printf ("\nEgalité!\n");
    return 1;
}


/*Vérifier le coup légal */
int legal (Othellier oth, coup c,int num)
{
	int i, legal;
	if(c.position<MAX_CASE && oth.Case[c.position]!=VIDE) return 0;
	switch (num){
		case 1:
			//Vertical vers le haut
			i = c.position-10;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC) {
				i = c.position-10;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
			
			//Vertical vers le bas
			i = c.position+10;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i = c.position+10;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
			
			//Horizontal vers la gauche
			i = c.position-1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i--;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
			
			//Horizontal vers la droite
			i = c.position+1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i++;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
        
			//Diagonal '\' vers le haut
			i = c.position-10-1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i = c.position-11;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;return 1;
        
			//Diagonal '\' vers le bas
			i = c.position+10+1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC)	{
				i = c.position+11;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
        
			//Diagonal '/' vers le haut
			i=c.position-9;
			legal = 0;
			while(c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i = c.position-9;
				legal = 1;
			}        
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
        
			//Diagonal '/' vers le bas
			i=c.position+10-1;
			legal = 0;
			while(c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC){
				i = c.position+9;
				legal = 1;
			}        
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR && legal==1)return 1;
		break;
		
		case 2:
			//Vertical vers le haut
			i = c.position-10;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position-10;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Vertical vers le bas
			i = c.position+10;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position+10;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Horizontal vers la gauche
			i = c.position-1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i--;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Horizontal vers la droite
			i = c.position+1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i++;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Diagonal '\' vers le haut
			i = c.position-10-1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position-11;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Diagonal '\' vers le bas
			i = c.position+10+1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position+11;
				legal = 1;
			}
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Diagonal '/' vers le haut
			i=c.position-10+1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position-9;
				legal = 1;
			}        
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
        
			//Diagonal '/' vers le bas
			i=c.position+10-1;
			legal = 0;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==NOIR){
				i = c.position+9;
				legal = 1;
			}        
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[c.position]==BLANC && legal == 1)return 1;
		break;
	}
	return legal;
}

/* Renvoie le numéro du joueur suivant*/
int change(int num){
	return num=(num-1)%2;
}

/* Choisie un coup */
int choose(partie p,int num){
	if (num==0) printf ("\nC'est le tour du joueur NOIR (\033[34mX\033[0m)\n");
    else printf ("\nC'est le tour du joueur BLANC (\033[31mO\033[0m|)\n");
    printf ("Choisissez une case (Ex: 23 pour la case correspondant a la colonne 2 et la ligne 3) :\n");
    scanf("%d\n", &p.coups.position);
    while(legal(p.othellier,p.coups,num)==0){
		if (num==0) printf ("\nC'est le tour du joueur NOIR (\033[34mX\033[0m)\n");
		else printf ("\nC'est le tour du joueur BLANC (\033[31mO\033[0m|)\n");
		printf("Coups interdit\n");
		printf ("Choisissez une autre case:\n");
		scanf ("\n%d", &p.coups.position);
	}
	return p.coups.position;
}

/* Vérifier si le joueur peut jouer*/
int peut(partie p, int num){
    int i;
    for (i=0; i<MAX_CASE; i++)
		if (legal(p.othellier,p.coups,num)==1) return 1; /* il peut continuer à jouer */
    return 0; /* il ne peut plus jouer */
}

Othellier jouer (Othellier oth, coup c, int num){
	int i,k,temp;
	int pos=c.position;
	switch (num){
		case 1:
			oth.Case[pos] = NOIR;
        
			//Vertical vers le haut
			i=pos-10;
			temp=pos-10;
			while (c.position>0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=i-10;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for(k=i+10;k<=temp;k=k+10)
				{
						oth.Case[k] = NOIR;
				}
			
			//Vertical vers le bas
			i=pos+10;
			temp=pos+10;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=i+10;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for(k=i-10;k>=temp;k=k-10)
				{
						oth.Case[k] = NOIR;
				}
			
			//Horizontal vers la gauche
			i=pos-1;
			temp=pos-1;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=i--;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for(k=i+1;k<=temp;k++)
				{
						oth.Case[k] = NOIR;
				}
			
			//Horizontal vers la droite
			i=temp=pos+1;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i++;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for (k=i-1;k>=temp;k--)
				{
					oth.Case[k] = NOIR;
				}
			
			//Diagonal vers le haut à gauche
			i=pos-11;
			temp=pos-11;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=i-11;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for (k=i+11;k<=temp;k=k+11){
					oth.Case[k] = NOIR;
				}
			
			//Diagonal vers le bas à droit
			i=temp=pos+11;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=i+11;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for (k=i-11;k>=temp;k=k-11){
					oth.Case[k] = NOIR;
				}
			
			//Diagonal vers le haut à droit
			i=temp=pos-9;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=pos-9;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for (k=i+9;k<=temp;k=k+9){
					oth.Case[k] = NOIR;
				}
			
			//Diagonal vers le bas à gauche
			i=temp=pos+9;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC) i=pos+9;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR)
				for (k=i-9;k>=temp;k=k-9){
					oth.Case[k] = NOIR;
				}
		break;
		case 2:
			oth.Case[pos] = BLANC;
        
			//Vertical vers le haut
			i=temp=pos-10;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i-10;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for(k=i+10;k<=temp;k=k+10){
						oth.Case[k] = BLANC;
				}
			
			//Vertical vers le bas
			i=temp=pos+10;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i+10;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for(k=i-10;k>=temp;k=k-10){
						oth.Case[k] = BLANC;
				}
			
			//Horizontal vers la gauche
			i=temp=pos-1;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i-1;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for(k=i+1;k<=temp;k++){
						oth.Case[k] = BLANC;
				}
			
			//Horizontal vers la droite
			i=temp=pos+1;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i+1;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for (k=i-1;k>=temp;k--){
					oth.Case[k] = BLANC;
				}
			
			//Diagonal vers le haut à gauche
			i=pos-11;
			temp=pos-11;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i-11;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for (k=i+11;k<=temp;k=k+11){
					oth.Case[k] = BLANC;
				}
			
			//Diagonal vers le bas à droit
			i=temp=pos+11;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=i+11;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for (k=i-11;k>=temp;k=k-11){
					oth.Case[k] = BLANC;
				}
			
			//Diagonal vers le haut à droit
			i=temp=pos-9;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=pos-9;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for (k=i+9;k<=temp;k=k+9){
					oth.Case[k] = BLANC; 
				}
			
			//Diagonal vers le bas à gauche
			i=temp=pos+9;
			while (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == NOIR) i=pos+9;
			if (c.position>=0 && c.position<MAX_CASE && oth.Case[i] == BLANC)
				for (k=i-9;k>=temp;k=k-9){
					oth.Case[k] = BLANC;
				}
		break;
		}
	return oth;
}
