﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace Projet
{
    class Program
    {
        static void Main(string[] args)
        {
            // Déclaration des Variables
            int n, e, i, j, T, r;
            double Theta;
            int d = 2; // Dimension du problème

            Lecture:
            // Lecture du Fichier Source
            Console.WriteLine("Entrer Nom du Fichier avec les Données. Exemple: datacas1 ");
            string texte = Console.ReadLine();
            string FilePath = @"..\..\" + texte + ".txt";

            try
            {
                StreamReader fichier = new StreamReader(FilePath);        //Création de la variable fichier permettant l'ouverture et la lecture du fichier text dont le chemin est donné par FP
                fichier.ReadLine();
                try
                {

                    n = Convert.ToInt32(fichier.ReadLine());  // Nombre de noeuds

                    fichier.ReadLine();

                    double[,] Cd = new double[n, d];  // Coordonnées des noeuds (x,y)
                    fichier.ReadLine();
                    Extraction(n, Cd, fichier, d);

                    fichier.ReadLine();
                    fichier.ReadLine();

                    e = Convert.ToInt32(fichier.ReadLine());  // Nombre d'éléments

                    fichier.ReadLine();

                    double[,] R = new double[e, 1];  // Raideurs
                    fichier.ReadLine();
                    Extraction(e, R, fichier, 1);

                    fichier.ReadLine();

                    double[,] Cn = new double[e, d];  // Connexion d'éléments (No. noeud 1, No. noeud 2)
                    fichier.ReadLine();
                    Extraction(e, Cn, fichier, d);

                    fichier.ReadLine();

                    double[,] F = new double[n, d];  // Force sur noeuds (Force, Angle d'orientation)
                    fichier.ReadLine();
                    Extraction(n, F, fichier, d);

                    fichier.ReadLine();

                    double[,] Co = new double[n, n];  // Condition limite sur noeuds (x (1=connue, 0=non), valeur x, y (1=connue, 0=non), valeur y)
                    fichier.ReadLine();
                    Extraction(n, Co, fichier, n);

                    fichier.Close();

                    // Affichage des Données Récupérées dans le Fichier Source
                    Console.WriteLine("\nLes coordonnées des noeuds (x,y) Cd=");
                    Affichage_Mat(Cd, n, d);

                    Console.WriteLine("\nLes Raideurs R=");
                    Affichage_Mat(R, e, 1);

                    Console.WriteLine("\n\nLes connexion d'éléments (No. noeud 1, No. noeud 2) Cn=");
                    Affichage_Mat(Cn, e, d);

                    Console.WriteLine("\nLes force sur noeuds (Force, Angle d'orientation) F=");
                    Affichage_Mat(F, n, d);

                    Console.WriteLine("\nLes condition limite sur noeuds (x (1=connue, 0=non), valeur x, y (1=connue, 0=non), valeur y) Co=");
                    Affichage_Mat(Co, n, d * d);

                    double[,] ke = new double[n, n];
                    double[,] K = new double[d * n, d * n];

                    // Initialisaion de la Matrice Globale
                    Initialisation_Matrice_Globale(K, d);

                    // Création de la Matrice Globale
                    int Cn0, Cn1, z;
                    for (z = 0; z < e; z++)
                    {
                        Cn0 = Convert.ToInt32(Cn[z, 0]);
                        Cn1 = Convert.ToInt32(Cn[z, 1]);
                        Theta = Calcul_Theta(Cd, Cn0, Cn1);

                        // Création de la Matrice Élementaire
                        Calcul_Matrice_Elémentaire(ke, Theta);

                        // Assemblage de la Matrice Globale
                        Assemblage(Cn0, Cn0, K, ke, R, z, 0, 0); // 1er carré
                        Assemblage(Cn1, Cn1, K, ke, R, z, 2, 2); // Symétrie du 1er carré
                        Assemblage(Cn0, Cn1, K, ke, R, z, 0, 2); // 2ème carré
                        Assemblage(Cn1, Cn0, K, ke, R, z, 2, 0); // Symétrie du 2ème carré

                        if (d == 2)
                        {
                            Console.WriteLine("Matrice Globale :");
                            Affichage_Mat(K, d * n, d * n);
                        }

                        // Création du second membre
                        double[] U = new double[d * n];
                        double[] S = new double[d * n];
                        int Total;
                        Total = Simp_Temp(Co, U, S, n, F);

                        // Création de la matrice simplifié
                        double[,] MS = new double[Total, Total];
                        double[] SM = new double[Total];
                        double[] SUV = new double[Total];

                        Simplification(K, MS, Total, n, SM, U, S, F);

                        T = Test_Matrice_Tribande(Total, MS);
                        if (T == 1) Console.Write("La méthode de Thomas peut être utilisé\n");
                        else Console.Write("La méthode de Thomas ne peut pas être utilisé car la matrice n'est pas tribande\n");

                        // Choix de la Méthode de Résolution
                        Console.WriteLine("Choix:");
                        Console.WriteLine("     1 = Méthode de Gauss");
                        Console.WriteLine("     2 = Méthode de LU");
                        if (T == 1) Console.WriteLine("     3 = Méthode de Thomas");
                        Console.Write("Selectionner la méthode à utiliser ");
                        string choix = Console.ReadLine();
                        int c = 0;
                        do
                        {
                            c = 0;
                            switch (choix)
                            {
                                case "1":
                                case "Méthode de Gauss":
                                    c = 1;
                                    Console.WriteLine("Un fichier Resultat_" + texte + "_Gauss.txt a été créé");
                                    //Application de GAUSS
                                    Méthode_Gauss(MS, SUV, SM, Total);
                                    break;

                                case "2":
                                case "Méthode LU":
                                    c = 2;
                                    Console.WriteLine("Un fichier Resultat_" + texte + "_LU.txt a été créé");
                                    //Application méthode LU
                                    Méthode_LU(MS, SM, Total, SUV);
                                    break;

                                case "3":
                                case "Méthode de Thomas":
                                    c = 3;
                                    if (T == 1)
                                    {
                                        Console.WriteLine("Un fichier Resultat_" + texte + "_Thomas.txt a été créé");
                                        //Application méthode de Thomas
                                        Méthode_Thomas(Total, MS, SM, SUV);
                                        break;
                                    }
                                    else goto default;

                                default:
                                    c = 4;
                                    if (T == 1) Console.WriteLine("Erreur, Choisir 1, 2, 3.");
                                    else Console.WriteLine("Erreur, Choisir 1, 2.");
                                    choix = Console.ReadLine();
                                    break;
                            }
                        } while (c > 3);

                        // Rédaction du Fichier Résultat
                        string Résultat = @"..\..\Resultat.txt";
                        if (c == 1) Résultat = @"..\..\Résultats\Resultat_" + texte + "_Gauss.txt";
                        if (c == 2) Résultat = @"..\..\Résultats\Resultat_" + texte + "_LU.txt";
                        if (c == 3) Résultat = @"..\..\Résultats\Resultat_" + texte + "_Thomas.txt";
                        StreamWriter Fichier = new StreamWriter(Résultat); // Création du Fichier Résultat
                        string[] UV = new string[Total];
                        Fichier.WriteLine("Résultats\n");
                        Fichier.WriteLine("Matrice simplifiée avec les Conditions Limites :");
                        Écriture_UV(S, d * n, UV, Fichier, Cd, SUV);
                        Écriture_Mat(MS, Total, Total, Fichier);
                        Fichier.WriteLine("\r\n");

                        if (c == 1) Fichier.WriteLine("Solution avec la Méthode de Gauss :\r\n");
                        if (c == 2) Fichier.WriteLine("Solution avec la Méthode LU :\r\n");
                        if (c == 3) Fichier.WriteLine("Solution avec la Méthode de Thomas :\r\n");
                        Écriture_Solution(Total, SUV, UV, Fichier);

                        Fichier.WriteLine("\r\nMatrice des Nouvelles Coordonnées des Noeuds :");
                        Écriture_Mat(Cd, n, d, Fichier);

                        Fichier.Close();

                        Console.ReadKey();

                    }
                }



                // Gestion d'Erreur si Certaines Données sont Manquantes ou au Mauvais Format dans le Fichier Source
                catch (System.FormatException)
                {
                    Console.WriteLine("Le programme a rencontré un problème lors de la lecture du fichier.\nVeuillez vérifier l'écriture des données du fichiers");
                    Console.ReadKey();
                    Environment.Exit(0);
                }
            }

            // Gestion d'Erreur si le Fichier Source est Inexistant
            catch (System.IO.FileNotFoundException)
            {
                Console.WriteLine("\nLe fichier est inexitant ou n'est pas rangé dans le bon dossier.\nAssurez vous que le fichier soit rangé dans le dossier\nProjet Final Crombet_Leroy\\Projet\n");
                goto Lecture;
            }
            }



        /*Sous Programmes*/

        // Création des matrices a partir d'un fichier TXT
        static void Extraction(int n, double[,] M, StreamReader fichier, int m)
        {
            int a, b;
            string texte;
            try                         //La procédure éssaye d'executer les lignes de programmes ci dessous et si il rencontre un problème de type "FormatException" alors il execute le programme dans "catch"
            {
                for (a = 0; a < n; a++)     //La boucle pour fait varier par incrément de 1 l'indice a qui gère les lignes de la matrice mat tout en réstant dans les dimentions de ligne n de mat
                {
                    texte = fichier.ReadLine();                   //La chaîne de caractère nommée txt recois tous les caractères contenue dans la ligne lue du fihcier
                    string[] nums = texte.Split(' ');            //Le tableau de chaîne de craractère nommé nums range les caractères dans le tableau, il découpe le rangement des caractères séparés un espace
                    for (b = 0; b < m; b++)                    //La boucle pour fait varier par incrément de 1 l'indice b qui gère les colones de la matrice mat tout en réstant dans les dimentions de colonne v de mat
                    {
                        M[a, b] = Convert.ToDouble(nums[b]);  //Il convertit les caractères ranger dans le tableau nums[] en valeur réél double précision, puis il range la valeur convertie dans la matrice mat[,]
                    }
                }
            }
            //Gestion d'érreur si lors de la lecture du fichier certaines données sont manquantes ou pas au bon format.
            catch (System.FormatException)
            {
                Console.WriteLine("Le programme a rencontré un problème lors de la lecture du fichier.\nVeuillez vérifier l'écriture des données du fichiers");
                Console.ReadKey();
                Environment.Exit(0);        //Force l'arret du programme
            }
        }


        // Écriture d'une Matrice sur Fichier Texte
        static void Écriture_Mat(double[,] M, int n, int m, StreamWriter Fichier)
        {
            int i, j;
            for (i = 0; i < n; i++)
            {
                Fichier.WriteLine();
                for (j = 0; j < m; j++)
                {
                    Fichier.Write("{0,12:f3}", M[i, j]);
                }
            }
        }

        // Écriture des Déplacements dans le Fichier Texte et Mise à Jour des Anciennes Coordonnées après Résolution
        static void Écriture_UV(double[] Vect_S, int m, string[] uv, StreamWriter fichier, double[,] co, double[] s)
        {
            int i, j, a, z, w;
            a = 0;                                          // Indice décalé pour la création du vecteur "UV[a]"                                                               
            z = 0;                                          // Indice permettant de lire notre vecteur contenant les simplifications
            for (i = 0; i < (m / 2); i++)                   // Les boucles pour i et j nous permettents de gérer des indices décalés; i permet de mettre le bon numéros au vecteur déplacement et de géré l'indice de ligne de notre matrice Co[,]
            {                                               // Grâce à ça notre z va varier de 0 à n; a de 0 au nombre de solution
                for (j = 0; j < 2; j++)
                {
                    if (Vect_S[z] == 0)                              // Si notre vecteur solution contient 0 alors c'est que le déplacement est inconnue et donc qu'on doit créé sa solution
                    {
                        if (z % 2 == 0) uv[a] = "U" + (i + 1);          // Si notre entier z est paire alors on est sur les déplacements en x noté U ; de plus on ajoute l'entier contenu dans c nous donnant le numéro du déplacement
                        else uv[a] = "V" + (i + 1);                     // Sinon nous somme sur les déplacements en y noté V
                        a += 1;                                         // On incrémente a de 1 car on vient de créer un déplacement
                        w = 1;                                          // w=1 quand on bien un déplacement inconnu avant résolution
                    }
                    else
                    {
                        w = 0;                      // w=0 quand le déplacement est déjà connu
                    }
                    
                    // Calcul des nouvelles coordonnées
                    if (z % 2 == 0 && w == 1) co[i, 0] = co[i, 0] + s[a - 1];     // Comme écrit précédemment le test "z % 2 ==0" nous permet de savoir si on est sur l'axe x et "w==1" permet de savoir qu'on a changé d'indice a
                    if (z % 2 != 0 && w == 1) co[i, 1] = co[i, 1] + s[a - 1];     // On ajoute nos solutions trouvées aux coordonnées contenue dans notre matrice   Co[,]; notre indice de colone vaut 0 quand la solution est sur l'axe des x et 1 quand la solution est sur l'axe y
                    z += 1;
                }
            }
        }

        // Écriture du Vecteur Solution dans un Fichier Texte
        static void Écriture_Solution(int m, double[] s, string[] uv, StreamWriter fichier)
        {
            int i;

            for (i = 0; i < m; i++)
            {
                fichier.WriteLine(uv[i] + " = {0,10:f4}", s[i]); // Dans le tableau de caractère "UV[]" est rangé dans la lettre du déplacement (soit U soit V) ainsi que sont numéro; puis on écris "=" la valeur de la solution 
            }
        }

        // Affichage d'une Matrice sur Invitation de Commande
        static void Affichage_Mat(double[,] m, int h, int c)
        {
            int k, l;
            for (k = 0; k < h; k++)
            {
                for (l = 0; l < c; l++)
                {
                    Console.Write("{0,9:f2}", m[k, l]);
                }
                Console.WriteLine();
            }
            Console.WriteLine();
        }

        // Affichage d'un Vecteur sur Invitation de Commande
        static void Affichage_Vecteur(double[] m, int l)
        {
            int k;
            for (k = 0; k < l; k++)
            {
                Console.Write("{0,12:f4}", m[k]);
            }
            Console.WriteLine("\n");
        }

        // Calcul de l'Angle Theta
        static double Calcul_Theta(double[,] cd, int l, int m)
        {
            double Theta;                //Angle theta recherché
            double CA, CO, H;            //CA = côté adjacent ; CO = côté opposé ; H = hypothénuse)
            int i, j;
            i = l - 1;
            j = m - 1;


            CA = cd[j, 1] - cd[i, 1];     // Calcul du coté adjacent en utilisant les coordonnées des noeuds de l'élément
            CO = cd[j, 0] - cd[i, 0];     // Calcul du coté opposé en utilisant les coordonnées des noeuds de l'élément
            H = Math.Sqrt(CA * CA + CO * CO);  // Théorème de Pythagore pour calculer l'hypothénuse

            Theta = Math.Asin(CA / H);       // Calcul de notre angle theta
            return Theta;                    // Retourne l'angle calculé
        }

        // Création de la Matrice Élémentaire
        static void Calcul_Matrice_Elémentaire(double[,] M, double theta)
        {
            double c;       // Cosinus theta
            double s;       // Sinus theta
            int i, j, k, l;

            c = Math.Cos(theta);
            s = Math.Sin(theta);

            if (c < Math.Pow(10, -10) && c > 0) c = 0;  // Anti-bug d'arrondi si le résultat tend vers 0 mais n'est pas 0 a cause d'arrondi logiciel coté positif
            if (s < Math.Pow(10, -10) && s > 0) s = 0;
            if (c > Math.Pow(-10, -10) && c < 0) c = 0; // Anti-bug d'arrondi si le résultat tend vers 0 mais n'est pas 0 a cause d'arrondi logiciel coté négatif
            if (s > Math.Pow(-10, -10) && s < 0) s = 0;

            for (i = 0; i < 3; i = i + 2)
            {
                k = i + 1;
                for (j = 0; j < 3; j = j + 2)
                {
                    l = j + 1;
                    if (i == j)
                    {
                        M[i, j] = c * c;
                        M[k, l] = s * s;
                    }
                    else
                    {
                        M[i, j] = -(c * c);
                        M[k, l] = -(s * s);
                    }
                    if ((i + l) != 3)
                    {
                        M[i, l] = c * s;
                        M[k, j] = c * s;
                    }
                    else
                    {
                        M[i, l] = -(c * s);
                        M[k, j] = -(c * s);
                    }
                }
            }
        }

        // Assemblage de la Matrice Globale par Élément
        static void Assemblage(int m, int n, double[,] k, double[,] KE, double[,] r, int Z, int a, int b)
        {
            int h, l, i, j, I, J, H, L;       // Les indices en majuscules sont les indices de la matrice globale et les indices en miniscules sont les indices de la matrice élémentaire
            double R;                         // R est le coefficient de raideur de l'élément
            i = a;
            R = r[Z, 0];
            for (I = m + m - 2; I < 2 * m; I = I + 2)    //Les indices I et J des boucles ne prennent que 2 valeurs paires par appel de la procédure
            {                                            // Idem pour les indices i et j sauf que ceux-ci sont bloqués car ils ne prendront comme valeurs soit 0 soit 2 pour rester dans les dimmensions de la matrice élémentaire qui sont toujours constantes
                j = b;
                H = I + 1;                               // Les indices K et L ne prennent que 2 valeurs impaires par appel de la procédure
                h = i + 1;                               // Idem pour les indices k et l sauf que ceux-ci sont bloqués car ils ne prendront comme valeurs soit 1 soit 3 pour rester dans les dimmensions de la matrice élémentaire qui sont toujours constantes
                for (J = n + n - 2; J < 2 * n; J = J + 2)
                {
                    L = J + 1;
                    l = j + 1;
                    k[I, J] = k[I, J] + (KE[i, j]) * R;       // On ajoute à la matrice gloable la matrice élémentaire multipliée par son coeficient de raideur
                    k[H, L] = k[H, L] + (KE[h, l]) * R;
                    k[I, L] = k[I, L] + (KE[i, l]) * R;
                    k[H, J] = k[H, J] + (KE[h, j]) * R;
                    j = j + 1;
                }
                i = i + 1;
            }
        }

        //initialisation matrice globale a 0
        static void Initialisation_Matrice_Globale(double[,] k, int D)
        {
            int i, j;
            for (i = 0; i < D; i++)
            {
                for (j = 0; j < D; j++)
                {
                    k[i, j] = 0;
                }
            }
        }

        // Lecture des conditions limites avec création du second membre temporaire (sans force)
        static int Simp_Temp(double[,] co, double[] u, double[] s, int m, double[,] f)
        {
            int i, j, k, l;
            k = 0;
            l = 0;
            for (i = 0; i < m; i++)
            {
                for (j = 0; j < 3; j = j + 2)
                {
                    if (co[i, j] == 1)
                    {
                        u[k] = u[k] + co[i, j + 1];    // Met la valeur de la condition limite dans le vecteur déplacement
                        s[k] = 1;                      // Met notre vecteur S[] à 1 pour qu'ensuite on puisse faire une simplification
                    }
                    else
                    {
                        u[k] = 0;         // Met 0 car on ne connait pas la valeur du déplacement selon la condition limite
                        s[k] = 0;         // Met 0 car il s'agit d'une inconnue à résoudre par la suite
                        l = l + 1;        // Le compteur s'incrémente a chaque inconnue
                    }
                    k = k + 1;
                }
            }
            return l;    // Retourne le nombre d"inconnue du problème pour créer la matrice simplifiée et le vecteur solution
        }

        // Simplification de la matrice gloable et addition des nouveaux termes au second membre
        static void Simplification(double[,] k, double[,] ms, int total, int m, double[] sm, double[] u, double[] s, double[,] f)
        {
            int a, b, c, d, e, h, z, x;
            double[] MF = new double [m * 2];
            h = 0;
            for (e = 0; e < m; e++)
            {
                for (z = 0; z < 3; z += 2)
                {
                    if (h % 2 == 0)
                    {
                        MF[h] = f[e, 0] * Math.Cos((f[e, 1] * (Math.PI)) / 180.0);         // Converti l'angle de la force en radian pour ensuite en calculer le cosinus, enfin on multiplie le cos par l'intensité de la force
                    }                                                                      // Calcule du cosinus car cette ligne correspond a la force sur l'axe X
                    else
                    {
                        MF[h] = f[e, 0] * Math.Sin((f[e, 1] * (Math.PI)) / 180.0);         // Converti l'angle de la force en radian pour ensuite en calculer le sinus, enfin on multiplie le cos par l'intensité de la force
                    }                                                                      // Calcule du sinus car cette ligne correspond a la force sur l'axe Y
                    h = h + 1;
                }
            }
            b = 0;
            x = 0;
            for (z = 0; z < m * 2; z++)
            {
                if (s[z] == 1)   //Si le déplacement est connu alors :
                {
                    a = 0;
                    for (c = 0; c < 2 * m; c++)     // Boucle pour récupérer tous les éléments d'une colonne z de la matrice globale en vérifiant chaque ligne c
                    {
                        if (s[c] == 0)              // Di notre vecteur simplificiation = 0 alors on ne connait pas le déplacement, il faut alors récupérer la valeur de la ligne c
                        {
                            sm[a] = sm[a] - (u[z] * k[c, z]);      // On ajoute au second membre SM[] la valeur du déplacement connu multipliée par la valeur de la matrice globale
                            a = a + 1;
                        }
                    }
                }
                else
                {
                    sm[x] += MF[z];    // On ajoute la valeur de la force au second membre
                    x = x + 1;
                    d = 0;
                    for (c = 0; c < 2 * m; c++)
                    {
                        if (s[c] == 0)              // Si notre vecteur simplificiation = 0 alors on ne connait pas le déplacement, alors il faut récupérer la valeur de la ligne c
                        {
                            ms[d, b] = k[c, z];     //Rremplissage de la matrice simplifiée par les valeurs à reprendre de la matrice globale
                            d = d + 1;
                        }
                    }
                    b = b + 1;
                }
            }
        }

        // Méthode de Gauss
        static void Méthode_Gauss(double[,] k, double[] s, double[] sm, int m)
        {
            int i, j, h;
            double coef;

            double[,] tab = new double[m, m + 1];
            double[] X = new double[m];

            for (i = 0; i < m; i++)
            {
                for (j = 0; j < m; j++)
                {
                    tab[i, j] = k[i, j];
                }
                tab[i, m] = sm[i];
            }

            for (h = 0; h < m - 1; h++)
            {
                for (i = h + 1; i < m; i++)
                {
                    coef = tab[i, h] / tab[h, h];
                    for (j = h; j < m + 1; j++)
                    {
                        tab[i, j] = tab[i, j] - (tab[h, j] * coef);
                    }
                }
            }

            for (i = m - 1; i > -1; i--)
            {
                X[i] = (tab[i, m] - Somme(tab, i, m, X)) / tab[i, i];
            }
            for (i = 1; i < m + 1; i++)
            {
                s[i - 1] = X[i - 1];
            }

        }

        // Fonction permettant de faire la somme en commençant par l'indice l+1
        static double Somme(double[,] M, int l, int c, double[] Y)
        {
            int j;
            double S = 0;

            for (j = l + 1; j < c; j++)
            {
                S = S + M[l, j] * Y[j];
            }
            return S;
        }

        // Méthode LU
        static void Méthode_LU(double[,] k, double[] sm, int m, double[] suv)
        {
            int n, i, j, r;
            n = m;
            double[,] A = new double[n, n];
            double[,] L = new double[n, n];
            double[,] U = new double[n, n];
            double[] B = new double[n];
            double[] Y = new double[n];
            double[] x = new double[n];

            for (i = 0; i < n; i++)
            {
                for (j = 0; j < n; j++)
                {
                    A[i, j] = k[i, j];
                }

                B[i] = sm[i];
            }

            for (i = 0; i < n; i++)
            {
                L[i, i] = 1;
            }

            for (r = 0; r < n; r++)
            {
                for (j = r; j < n; j++)
                {
                    U[r, j] = A[r, j] - SLU(L, U, r, r, j);
                }
                for (i = r; i < n; i++)
                {
                    L[i, r] = (A[i, r] - SLU(L, U, r, i, r)) / U[r, r];
                }
            }

            CalculY(Y, L, B, n);
            CalculX(x, Y, U, n);
            for (i = 0; i < n; i++)
            {
                suv[i] = x[i];
            }
        }

        // Somme LU (Matrice L, Matrice U, Boucle r, indice L[X,],indiceU[,X])
        static double SLU(double[,] X, double[,] Y, int R, int P, int H)
        {
            int k;
            double S = 0;

            for (k = 0; k < R; k++)
            {
                S = S + X[P, k] * Y[k, H];
            }
            return S;
        }

        // Fonction permettant de faire la somme mais en commençant par l'indice 0
        static double S0(double[,] G, double[] H, int J)
        {
            int w;
            double S = 0;

            for (w = 0; w < J; w++)
            {
                S = S + G[J, w] * H[w];
            }
            return S;
        }

        static void CalculY(double[] Y, double[,] L, double[] B, int N)
        {
            int k;
            Y[0] = B[0];
            for (k = 1; k < N; k++)
            {
                Y[k] = B[k] - S0(L, Y, k);
            }
        }

        static void CalculX(double[] X, double[] Y, double[,] U, int N)
        {
            int k;

            X[N - 1] = Y[N - 1] / U[N - 1, N - 1];
            for (k = N - 2; k > -1; k--)
            {
                X[k] = (Y[k] - Somme(U, k, N, X)) / U[k, k];
            }
        }

        // Méthode de Thomas
        static void Méthode_Thomas(int m, double[,] k, double[] sm, double[] suv)
        {
            int n, i, j;
            n = m;
            double[,] H = new double[n, n];
            double[] D = new double[n];

            for (i = 0; i < m; i++)
            {
                for (j = 0; j < m; j++)
                {
                    H[i, j] = k[i, j];
                }
                D[i] = sm[i];
            }
            double[] A = new double[n];
            double[] B = new double[n];
            double[] C = new double[n];
            double[] Alpha = new double[n];
            double[] Beta = new double[n];
            double[] U = new double[n];

            for (i = 1; i < n; i++)
            {
                A[i] = k[i, i - 1];
            }
            for (i = 0; i < n; i++)
            {
                B[i] = k[i, i];
            }
            for (i = 0; i < n - 1; i++)
            {
                C[i] = k[i, i + 1];
            }

            Alpha[0] = C[0] / B[0];
            Beta[0] = D[0] / B[0];

            for (i = 1; i < n; i++)
            {
                Alpha[i] = C[i] / (B[i] - (A[i] * Alpha[i - 1]));
                Beta[i] = (D[i] - (A[i] * Beta[i - 1])) / (B[i] - (A[i] * Alpha[i - 1]));
            }

            U[n - 1] = Beta[n - 1];

            for (i = m - 2; i > -1; i--)
            {
                U[i] = Beta[i] - (Alpha[i] * U[i + 1]);
            }
            for (i = 0; i < n; i++)
            {
                suv[i] = U[i];
            }
        }

        static int Test_Matrice_Tribande(int m, double[,] k)
        {
            int i, j, a;
            a = 3;
            for (i = 0; i < m - 2; i++)
            {
                j = i + 2;
                while (k[i, j] == 0 && j < m - 1)
                {
                    j = j + 1;
                }
                if (k[i, j] == 0)
                {
                    a = 1;
                    continue;
                }
                else
                {
                    a = 0;
                    break;
                }
            }
            for (j = 0; j < m - 2; j++)
            {
                i = j + 2;
                while (k[i, j] == 0 && i < m - 1)
                {
                    i = i + 1;
                }
                if (k[i, j] == 0)
                {
                    a = 1;
                    continue;
                }
                else
                {
                    a = 0;
                    break;
                }
            }
            return a;
        }
    }
}
