
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * Class Block, un morceau du serpent
 */
public class Block extends JPanel
{
	//creation attribution position x,y
	protected int posX;
	protected int posY;
	
	// creation d'une ancre qui va nous servir de block a suivre, on va dire a notre serpent de suivre ce bloc comme ca on aura que celui la a gerer
	private Block ancre;
	
	//on déclare une couleur
	private Color color ;
	
    //Cree un Block du serpent qui suivra le Block ancre
	public Block(Block ancre)
	{
		this.ancre = ancre;
		this.posX = ancre.posX+1;
		this.posY = ancre.posY;
		
		this.setSize(new Dimension(Donnees.tailleCase, Donnees.tailleCase));
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
    //Block a la position (posX, posY)
	public Block(int posX, int posY)
	{
		this.posX = posX;
		this.posY = posY;
		
		this.setSize(new Dimension(Donnees.tailleCase, Donnees.tailleCase));
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
    //Faire avancer le Block vers le Block qu'il suit
	protected void avance()
	{
		this.posX = ancre.posX;
		this.posY = ancre.posY;
		
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
	/**
	 * Block.gauche: Vers la gauche
	 * Block.droite: Vers la droite
	 * Block.haut: Vers le haut
	 * Block.bas: Vers le bas
	 * Faire avancer le serpent dans la direction dir
	 * @param dir direction a prendre
	 */
	protected void avance(int dir)
	{
		if(dir == Snake.droite) {
			posX++;
		} else if(dir == Snake.gauche) {
			posX--;
		} else if(dir == Snake.haut) {
			posY--;
		} else if(dir == Snake.bas) {
			posY++;
		}
		
		//Si le serpent sort du cadre le faire apparaitre de l'autre cote
		
		if(posX<0 && dir == Snake.gauche) {
			posX=Donnees.NBRCaseX-1;
		}
		
		if(posX>=Donnees.NBRCaseX && dir == Snake.droite) {
			posX=0;
		}
		if(posY<0 && dir == Snake.haut) {
			posY=Donnees.NBRCaseY-1;
		}
		
		if(posY>=Donnees.NBRCaseY && dir == Snake.bas) {
			posY=0;
		}
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
    //Faire bouger le Block a la position (posX, posY)
	public void moveIt(int posX, int posY)
	{
		this.posX = posX;
		this.posY = posY;
		
		this.setSize(new Dimension(Donnees.tailleCase, Donnees.tailleCase));
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
    //methode graphic
	public void paintComponent(Graphics g)
	{
		g.setColor(Color.BLACK);
		g.drawOval(0, 0, Donnees.tailleCase-1, Donnees.tailleCase-1);
		
		g.setColor(color);
		g.fillOval(1, 1, Donnees.tailleCase-3, Donnees.tailleCase-3);
	}

    //Donner la couleur color au Block
	public void setColor(Color color)
	{
		this.color = color;
	}
	
    //retourne la couleur du Block
	public Color getColor()
	{
		return color;
	}
}
