
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/**
 * Class Main du Snake
 * @author Corentin
 *
 */
public class Main extends JFrame {
	
	private final Main before = this;
	private static final String version = "0.1";
	
	private Block tete;
	private Snake snake;
	
	private JPanel mapPanel = new JPanel();
	
	public static void main(String[] args)
	{
		new Main();
	}
	
    //Constructeur pour construire la fenetre du jeu
	public Main()
	{
        //titre de la fenetre est ca
		this.setTitle("Snake !");
        
        //placement de nouveau composant(BorderLayout)
		this.setLayout(new BorderLayout());
		
			JMenuBar mb = new JMenuBar();
		
			start.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
			
			jeu.add(start);

			{
				public void actionPerformed(ActionEvent arg0)
				{
					serpent.setStatue(Snake.PAUSE);
					//Dialog.info(before, "Jeu en pause !");
					serpent.setStatue(Snake.PLAY);
				}
			});
			
			jeu.add(pause);
			
			aPropos.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
			//ici ici ici ici ici ici ici
			
			mb.add(jeu);
			mb.add(info);
			
			this.getContentPane().add(mb, BorderLayout.LEFT);
		
		//SNAKE !
			
			mapPanel.setLayout(new FlowLayout());
			mapPanel.add(Donnees.MAP, BorderLayout.CENTER);
			this.getContentPane().add(mapPanel);
		
			tete = new Block((Donnees.NBRCaseX-1)/2, (Data.NBRCaseY-1)/2);
			tete.setColor(new Color((int)(Math.random()*127), (int)(Math.random()*127), (int)(Math.random()*127)));
			serpent = new Snake(tete, Donnees.tailleSerpent);
			
			new Thread(serpent).start();
			this.addKeyListener(serpent);
			
		//COMPTEUR
			
		this.add(serpent.getPanel(), BorderLayout.SOUTH);
			
		this.pack();
        //afficher la fenetr au centre
		this.setLocationRelativeTo(null);
		
		//on peut pas changer la taille de la fenetre
        this.setResizable(false);
        //quitter le programme quand on ferme la fenetre
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        //rendre fenetre visible
		this.setVisible(true);
	}
	
    //Rejouer et retablir la fenetre
    
    /*
	 public void replay()
	{
		Donnees.MAP.removeAll();
		Donnees.MAP.repaint();
		
		mapPanel.removeAll();
		mapPanel.repaint();
		
		this.remove(mapPanel);
		mapPanel.remove(Donnees.MAP);
		Donnees.reborn();
		
		mapPanel.add(Donnees.MAP, BorderLayout.CENTER);
		this.getContentPane().add(mapPanel);
		
		tete.moveIt((Donnees.NBRCaseX-1)/2, (Donnees.NBRCaseY-1)/2);
		tete.setColor(new Color((int)(Math.random()*127), (int)(Math.random()*127), (int)(Math.random()*127)));
		serpent.reborn(tete, Donnees.tailleSerpent);
		
		this.pack();
		this.setLocationRelativeTo(null);
	} 
	*/
}
