
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * Carte sur laquelle bouge le serpent
 * @author Corentin
 *
 */
public class Map extends JPanel {
	
	private int tailleX;
	private int tailleY;
	
	/**
	 * Cree une carte
	 * @param sizeX taille X en pixel de la carte
	 * @param sizeY taille Y en pixel de la carte
	 */
	public Map(int sizeX, int sizeY)
	{
		this.tailleX = tailleX;
		this.tailleY = tailleY;
		
        //taille de la carte
		this.setSize(tailleX, tailleY);
        //preference de la taille
		this.setPreferredSize(new Dimension(tailleX, tailleY));
        //nous interdis de modifier le Layout
		this.setLayout(null);
	}
	
	public void paintComponent(Graphics g)
	{
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, this.tailleX, this.tailleY);
		
		g.setColor(Color.BLACK);
		g.drawRect(0, 0, this.tailleX-1, this.tailleY-1);
	}
     
     //ajout de composant provenant d'une liste dans la carte
	public void add(Component[] array)
	{
		for(Component o : array)
			this.add(o);
	}
     
     //changer les composant de la liste 
	public void remove(Component[] array)
	{
		for(Component o : array)
			this.remove(o);
	}
}
