
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * Nouriture pour le serpent
 * @author Corentin
 *
 */
public class Pomme extends JPanel {
	
	//coordonnes position de la pomme en x,y
	protected int posX;
	protected int posY;
	
	//couleur de la pomme
	private Color color = new Color(198, 8, 8);
	
	/**
	 * Cree un nouvel  objectif pour le serpent
	 * @param posX position horizontal de l'objectif
	 * @param posY position vertical de l'objectif
	 */
	 
	//constructeur
	public Pomme(int posX, int posY)
	{
		this.setSize(new Dimension(Donnees.tailleCase, Donnees.tailleCase));
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
		
		this.posX = posX;
		this.posY = posY;
	}
	
	/**
	 * Bouger l'objectif
	 * @param posX position horizontal de l'objectif
	 * @param posY position vertical de l'objectif
	 */
	public void moveIt(int posX, int posY)
	{
		color = new Color((int)(Math.random()*255), (int)(Math.random()*255), (int)(Math.random()*255));
		
		this.posX = posX;
		this.posY = posY;
		
		//coordonnees en pixels de la pomme
		this.setLocation(posX*Donnees.tailleCase, posY*Donnees.tailleCase);
	}
	
	//methode graphique, aide javadoc
	public void paintComponent(Graphics g)
	{
		g.setColor(Color.BLACK);
		g.drawOval(Donnees.tailleCase/6, Donnees.tailleCase/6, Donnees.tailleCase-(Donnees.tailleCase/3)-1, Donnees.tailleCase-(Donnees.tailleCase/3)-1);
		
		g.setColor(color);
		g.fillOval(Donnees.tailleCase/6+1, Donnees.tailleCase/6+1, Donnees.tailleCase-(Donnees.tailleCase/3)-3, Donnees.tailleCase-(Donnees.tailleCase/3)-3);
	}
	
    //return position horizontal de l'objectif pour pouvoir l'utiliser dans l'objet Serpent
	public int getPosX()
	{
		return posX;
	}
	
	/**
	 * @return position vertical de l'objectif pour pouvoir l'utiliser dans l'objet Serpent
	 */
	public int getPosY()
	{
		return posY;
	}
}
