
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * 
 * Le serpent
 *
 */
public class Snake extends JPanel implements Runnable, KeyListener {

	//declarations de plusieurs attributs, les directions et les etats
	public final static int gauche = -1;
	public final static int droite = 1;
	public final static int haut = -2;
	public final static int bas = 2;

	public final static int PLAY = 0;
	public final static int DEAD = 1;
	public final static int PAUSE = 2;
	
	//
	private Block tete;
	private ArrayList<Block> queue = new ArrayList<Block>();
	
	//declaration, initialisation de la premiere direction
	private int dir = gauche;
	private int dirAv = gauche;
	
	//declaration d'une couleur
	private Color color;
	
	//declaration, initialisation du statue du serpent
	private int statue = PLAY;
	
	public Pomme objectif = new Pomme((int)(Math.random()*Donnees.NBRCaseX),(int)(Math.random()*Donnees.NBRCaseY));
	public int score = 0;
	public JPanel fenetre = new JPanel();
	
	/**
	 * Cree un nouveau serpent
	 * @param tete le Block representant sa tete
	 * @param nbrQueue le nombre de Block en plus de sa tete
	 */
	public Snake(Block tete, int nbrQueue)
	{
		//tete devient tete du serpent
		this.tete = tete;
		
		//une couleur 
		color = new Color(tete.getColor().getRed()+127, tete.getColor().getGreen()+127, tete.getColor().getBlue()+127);
		
		//Ajoute le corp (aide javadoc pour la list)
		for(int i=0;i<nbrQueue;i++)
		{
			if(i==0)
				queue.add(new Block(tete));
			else queue.add(new Block(queue.get(i-1)));
			
			queue.get(i).setColor(color);
		}
		
		//Ajouter a la map (aide internet + javadoc)
		
		Donnees.MAP.add(tete);
		Donnees.MAP.add(queue.toArray(new Block[queue.size()]));
		Donnees.MAP.add(objectif);
		
		//Ajouter le panel du score a l'ecran
		
		fenetre.add(new JLabel("Score: "));
		fenetre.add(new JLabel(String.valueOf(score)));
	}
	
	/**
	 * Resussite le serpent
	 * @param tete le Block representant sa tete
	 * @param nbrQueu le nombre de Block en plus de sa tete
	 */
	public void reborn(Block tete, int nbrQueue) 
    {
		this.tete = tete;
		color = new Color(tete.getColor().getRed()+127, tete.getColor().getGreen()+127, tete.getColor().getBlue()+127);
		score = 0;
		
		fenetre.removeAll();
		fenetre.add(new JLabel("Score: "));
		fenetre.add(new JLabel(String.valueOf(score)));
		
		queue.removeAll(queue);
		
		for(int i=0;i<nbrQueue;i++)//Ajouter le corp du serpent
		{
			if(i==0)
				queue.add(new Block(tete));
			else queue.add(new Block(queue.get(i-1)));
			
			queue.get(i).setColor(color);
		}
		
		objectif = new Pomme((int)(Math.random()*Donnees.NBRCaseX), (int)(Math.random()*Donnees.NBRCaseY));
		
		Donnees.MAP.add(tete);
		Donnees.MAP.add(queue.toArray(new Block[queu.size()]));
		Donnees.MAP.add(objectif);
		
		dir = gauche;
		dirAv = gauche;
		statue = PLAY;
	}
	
    //Ajouter un Block en plus au serpent
	public void addOne()
	{
		Block b = new Block(queue.get(queue.size()-1));
		b.setColor(color);
		
		queue.add(b);
		Donnees.MAP.add(b);
	}

    //Faire avancer le serpent d'une case
	public void avance()
	{
		for(int k=queue.size()-1;k>=0;k--)//Remplacer le Block n-1 par celui n
			queue.get(k).avance();
		
		if(dir+dirAv != 0)//Ne peut pas ce diriger dans le sens contraire
		{
			tete.avance(dir);//On fait avancer la tete toujours dans la meme direction
			dirAv=dir;
		}
		else
			tete.avance((int) (dirAv));//On fait avancer la tete dans la direction dir
		
		for(int k=0;k<queue.size();k++)
			if(queue.get(k).getLocation().equals(tete.getLocation()))//Si la tete touche un autre Block du serpent
			{
				statue = DEAD;//Bloquer le serpent
			}
		
		if(tete.posX == objectif.getPosX() && tete.posY == objectif.getPosY())//Si il a atteind un objectif
		{
			objectif.moveIt((int)(Math.random()*Donnees.NBRCaseX), (int)(Math.random()*Donnees.NBRCaseY));
			this.addOne();
			score++;
			((JLabel)fenetre.getComponent(1)).setText(String.valueOf(score));
			fenetre.repaint();
		}
	}
	
	/**
	 * Thread run
	 * Pour cela, nous avons du prendre exemple sur internet et nous nous sommes aider de la javadoc
	 */
	public void run()
	{
		while(true)
		{
			if(statue == PLAY)//Faire avancer le serpent s'il est vivant
			{
				this.avance();
				
				try
				{
					Thread.sleep(1040-10*Donnees.vitesseSerpent);
				}
				catch (InterruptedException e){e.printStackTrace();}
			}
		}
	}
    
    //reconnaitre les entrees clavier des 4 fleches, aide du programme asteroide
	public void keyPressed(KeyEvent e)
	{
		if(e.getKeyCode()==KeyEvent.VK_UP) {
			dir=haut;
		} else if(e.getKeyCode()==KeyEvent.VK_DOWN) {
			dir=bas;
		} else if(e.getKeyCode()==KeyEvent.VK_LEFT) {
			dir=gauche;
		} else if(e.getKeyCode()==KeyEvent.VK_RIGHT) {
			dir=droite;
		}
	}
	
	public void keyReleased(KeyEvent e){}
	public void keyTyped(KeyEvent e){}
	
    //return les Block formant la queue du serpent
	public ArrayList<Block> getQueu() ;
	{
		return queue;
	}
	
	/**
	 * Snake.DEAD: mort
	 * Snake.PLAY: vivant
	 * Snake.PAUSE: en pause
	 * @return statue du serpent
	 */
	public int getStatue()
	{
		return statue;
	}
	
	/**
	 * Snake.DEAD: mort
	 * Snake.PLAY: vivant
	 * Snake.PAUSE: en pause
	 * @param statue statue a donner au serpent
	 */
	public void setStatue(int statue)
	{
		this.statue = statue;
	}
	
    //@return Panel du score
	public JPanel getPanel()
	{
		return this.fenetre;
	}
}
