/*
 * dht22.c
 * A library for Grove - Temperature and Humidity Sensor Pro at RP
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : technion@lolware.net, yexiaobo@seeedstudio.com
 * Create Time:
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



#include "dht22.h"


/*
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/types.h>
#include <unistd.h>*/

using namespace std;

#define MAXTIMINGS 85
static int dht22_dat[5] = {0,0,0,0,0};
static int _lockfd;


dht22::dht22()
{
	previousTemp = 0;
	previousHum = 0;
}


void dht22::init()
{

	_lockfd = open_lockfile(LOCKFILE);

}

void dht22::close()
{
	close_lockfile(_lockfd);
}


void dht22::PrintUsage()
{
	std::cout << "ReadDHT22 <pin> <mode>" << std::endl;
	std::cout << "  pin  : GPIO No (0-7)" << std::endl;
	std::cout << "  mode : V - verbose output" << std::endl;
	std::cout << "         S - simple output." << std::endl;
	std::cout << "             [-]HHH" << std::endl;
	std::cout << "             [-]TTT" << std::endl;
	std::cout << "             Values are signed 16 bit resolution and need dividing by 10" << std::endl;
}

uint8_t dht22::sizecvt(const int read)
{
    /* digitalRead() and friends from wiringpi are defined as returning a value
       < 256. However, they are returned as int() types. This is a safety function */

    if (read > 255 || read < 0)
    {
        std::cout << "Invalid data from wiringPi library" << std::endl;
        exit(EXIT_FAILURE);
    }
    return (uint8_t)read;
}

int dht22::read_dht22_dat(int iPin, float* piHumidity, float* piTemp)
{
    uint8_t laststate = HIGH;
    uint8_t counter = 0;
    uint8_t j = 0, i;

    dht22_dat[0] = dht22_dat[1] = dht22_dat[2] = dht22_dat[3] = dht22_dat[4] = 0;

    // pull pin down for 18 milliseconds
    pinMode(iPin, OUTPUT);
    digitalWrite(iPin, LOW);
    delay(18);

    // then pull it up for 40 microseconds
    digitalWrite(iPin, HIGH);
    delayMicroseconds(40);

	// prepare to read the pin
    pinMode(iPin, INPUT);

    // detect change and read data
    for ( i=0; i< MAXTIMINGS; i++)
	{
        counter = 0;
        while (sizecvt(digitalRead(iPin)) == laststate)
		{
            counter++;
            delayMicroseconds(1);
            if (counter == 255)
			{
                break;
            }
        }
        laststate = sizecvt(digitalRead(iPin));

        if (counter == 255) break;

        // ignore first 3 transitions
        if ((i >= 4) && (i%2 == 0))
		{
            // shove each bit into the storage bytes
            dht22_dat[j/8] <<= 1;
            if (counter > 16)
                dht22_dat[j/8] |= 1;
            j++;
        }
    }

    // check we read 40 bits (8bit x 5 ) + verify checksum in the last byte
    // print it out if data is good
    if ((j >= 40) && (dht22_dat[4] == ((dht22_dat[0] + dht22_dat[1] + dht22_dat[2] + dht22_dat[3]) & 0xFF)) )
	{
		*piHumidity = dht22_dat[0] * 256 + dht22_dat[1];
		*piTemp = (dht22_dat[2] & 0x7F)* 256 + dht22_dat[3];

		*piHumidity /= 10.0;
		*piTemp /= 10.0;

		if(previousHum != *piHumidity)
		{
			_observer->onHumiditeChange(*piHumidity);
		}

		if(previousTemp != *piTemp)
		{
			_observer->onTemperatureChange(*piTemp);
		}

		previousHum = *piHumidity;
		previousTemp = *piTemp;


        if ((dht22_dat[2] & 0x80) != 0)
			*piTemp *= -1;

		return 1;
    }
    else
    {
        return 0;
    }
}


void dht22::setListeners(dhtObserver *observer)
{
	_observer = observer;
}


/*
int main( int argc, char * argv[])
{
    int lockfd;
    int iPin = 0;
    int iErr = 0;
    char cMode = 'V';
	int iReturnCode = 0;

    if ( argc !=3 )
	{
		PrintUsage();
		return -1;
	}

	if (strlen(argv[1]) != 1 || argv[1][0] < '0' || argv[1][0] > '7')
	{
		PrintUsage();
	    //printf ("Invalid Pin Value [%s]\n", argv[1]);
	    std::cout << "Invalid Pin Value " << argv[1] << std::endl;
		return -1;
	}
	if (strlen(argv[2]) != 1 || (argv[2][0] != 'V' && argv[2][0] != 'S'))
	{
		PrintUsage();
	    //printf ("Invalid Mode Value [%s]\n", argv[2]);
	    std::cout << "Invalid Mode Value " << argv[2] << std::endl;
		return -1;
	}

	iPin = atoi(argv[1]);
	cMode = argv[2][0];

	if (cMode == 'V')
	{
		printf ("Raspberry Pi wiringPi DHT22 reader\n");
	    printf ("   Reading data from pin %d\n", iPin);
	    std::cout << "Raspberry Pi wiringPi DHT22 reader" << std::endl;
	    std::cout << "Reading data from pin " << iPin << std::endl;
	}

    lockfd = open_lockfile(LOCKFILE);

	iErr = wiringPiSetup ();
    if (iErr == -1)
	{
		if (cMode == 'V')
			std::cout << "ERROR : Failed to init WiringPi " << iErr << std::endl;
        iReturnCode = -1;
	}
	else
	{
		if (setuid(getuid()) < 0)
		{
			perror("Dropping privileges failed\n");
			iReturnCode = -1;
		}
		else
		{
			int iHumidity = -1;
			int iTemp = -1;

			while (read_dht22_dat(iPin, &iHumidity, &iTemp) != 1)
			{
				cout << "Bad data, next" << endl;
				sleep(1);
			}
			
			cout << "Humidite " << iHumidity/10.0 << endl;
			cout << "Temperature " << iTemp/10.0 << endl;
			
			
			for(int i = 0; i<10; i++)
			{
				// read_dht22_dat(iPin);
				if (read_dht22_dat(iPin, &iHumidity, &iTemp) == 1)
				{
					if (cMode == 'V')
						//printf("    Humidity = %.2f %% Temperature = %.2f *C \n", (float)(iHumidity/10.0), (float)(iTemp/10.0) );
						std::cout << "Humidity = " << (float)(iHumidity/10.0) << "%   " << "Temperature = " << (float)(iTemp/10.0) << "°C" << std::endl;
					else
						//printf("%d\n%d\n", iHumidity, iTemp);
						std::cout << iHumidity << std::endl;
						std::cout << iTemp << std::endl;
						iReturnCode = 0;


					break;
				}
				else
				{
					if (cMode == 'V')
					{
						std::cout << "    Data not good, skip" << std::endl;
						iReturnCode = -1;
					}
				}
			}
		}
	}

    close_lockfile(lockfd);

    return iReturnCode;
}

*/
