#pragma once
#include <wiringPi.h>
#include <cstdint>
#include <cstdio>
#include <iostream>
#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <sys/types.h>

#include "locking.h"
#include "dhtObserver.h"


class dht22
{
	public:
		dht22();
		void init();
		void close();
		void PrintUsage();
		uint8_t sizecvt(const int read);
		int read_dht22_dat(int iPin, float* piHumidity, float* piTemp);

		void setListeners(dhtObserver *observer);

	private:
		dhtObserver *_observer;
		float previousTemp;
		float previousHum;

};