//    			Name: Ants->food 1.0 2017/06/01
//   			Author: christian breant
//				christian.breant@gmail.com
//
//             The ants are searching for food or pheromons.
//             If they find  food they get red and leave pheromons.
//				If they find pheromons they get grey.
//				if they are lost they get yellow.
//				





#include <stdlib.h>
#include <stdio.h>
#include <SDL.h>
#include <math.h>
#include <time.h>
#include <thread.h>
#include <mutex>
#include <stack.h>
#include <SDL_getenv.h>
 
#define ant_hill_size 20  
#define food_hill_size 40
#define ant_size 10
#define FALSE  0
#define TRUE  1
                
void horizontal_line(int x, int y, int w, Uint32 coul,SDL_Surface *surface )
{
  SDL_Rect r;
 
  r.x = x;
  r.y = y;
  r.w = w;
  r.h = 1;
 
  SDL_FillRect(surface, &r, coul);
}

void disk(int cx, int cy, int rayon, Uint32 coul,SDL_Surface *surface )
{
  int d, y, x;
 
  d = 3 - (2 * rayon);
  x = 0;
  y = rayon;
 
  while (y >= x) {
    horizontal_line(cx - x, cy - y, 2 * x + 1, coul,surface);
    horizontal_line(cx - x, cy + y, 2 * x + 1, coul,surface);
    horizontal_line(cx - y, cy - x, 2 * y + 1, coul,surface);
    horizontal_line(cx - y, cy + x, 2 * y + 1, coul,surface);
 
    if (d < 0)
      d = d + (4 * x) + 6;
    else {
      d = d + 4 * (x - y) + 10;
      y--;
    }
 
    x++;
  }
}

void setPixel(SDL_Surface *surface, int x, int y, Uint32 coul)
{
  *((Uint32*)(surface->pixels) + x + y * surface->w) = coul;
}


Uint32 getpixel(const SDL_Surface* surface, int x, int y)
{
  const int bpp = surface->format->BytesPerPixel;

  /* Here p is the address to the pixel we want to retrieve */
  const Uint8* p = (Uint8*)surface->pixels + y * surface->pitch + x * bpp;

  switch (bpp)
  {
    case 1:
      return *p;
    case 2:
      return *(Uint16*)p;
    case 3:
      if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
return p[0] << 16 | p[1] << 8 | p[2];
      return p[0] | p[1] << 8 | p[2] << 16;
    case 4:
      return *(Uint32*)p;
    default:
      //assert(false && "Shouldn't be reached!");
      return 0;
  }
  return 0;
}

std::mutex lock; 

 search_food(double x_pos,double  y_pos, int  id,SDL_Surface *surface,SDL_Surface *surface_back)
    {
    	
		double x_head_pos;
	    double y_head_pos;
		srand(time(NULL)+id);
    	double angle_alea;double angle;double angle_init=id;double vx,vy;double i=1;
    		
		SDL_Surface* ant_surface = SDL_CreateRGBSurface(SDL_HWSURFACE, ant_size+1, ant_size+1, 32, 0, 0, 0, 0);
        SDL_FillRect(ant_surface, NULL, SDL_MapRGB(surface->format, 0, 0, 255));// d'abord bleu
	    Uint32 ant_couleur=SDL_MapRGB(surface->format, 0, 0, 0);
	    disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface); //puis un disque noir
	    SDL_SetColorKey(ant_surface, SDL_SRCCOLORKEY| SDL_RLEACCEL, SDL_MapRGB(ant_surface->format, 0, 0, 255));// bleu transparent
        
		SDL_Rect ant_surface_rect;
    	ant_surface_rect.x=x_pos-(ant_size+1)/2; ant_surface_rect.y=y_pos-(ant_size+1)/2;ant_surface_rect.w=ant_size+1;ant_surface_rect.h=ant_size+1;
	  
    	Uint32 couleur_pixel;	Uint8 pixel_vert;Uint8 pixel_rouge, pheromone=0;;Uint8 pixel_bleu;
    	int black_essai_detection; double grey_essai_detection;
    	double x_ant_hill=(surface_back->w)/5;
		double y_ant_hill=(surface_back->h)*0.8;
		
		struct point
    	{
    		int x;
    		int y;
		};
		point position;
		std::stack <point> position_stack;
		
		while(1<2)
	    {
		 	
 		    lock.lock();
 		    pixel_vert=0; pixel_rouge=0;pixel_bleu=0;
     		// on dpose une trace
     		if (ant_couleur==SDL_MapRGB(surface->format, 128, 0, 0))
     		{
     			SDL_SetAlpha( ant_surface, SDL_SRCALPHA | SDL_RLEACCEL, 9);
			 }
	        else
	        {
	        	SDL_SetAlpha( ant_surface, SDL_SRCALPHA | SDL_RLEACCEL, 0);
			}
	        
	        SDL_BlitSurface(ant_surface, NULL, surface_back, &ant_surface_rect);
	        SDL_BlitSurface(surface_back, &ant_surface_rect, surface, &ant_surface_rect);
	        SDL_UpdateRect(surface, ant_surface_rect.x, ant_surface_rect.y, ant_surface_rect.w, ant_surface_rect.h );
			
           // on s'oriente en faisant au plus 100 essais
           
           black_essai_detection=0;
           while ((black_essai_detection<10)&&(ant_couleur==SDL_MapRGB(surface->format, 0, 0, 0)))
           {
           	   i=-i;
                black_essai_detection=black_essai_detection+1;
                angle_alea=(rand()%(2*90))*3.14/180-1.57;// angle aleatoire de moyenne 0 degre
			    angle=angle_init+angle_alea;// angle aleatoire de moyenne angle_init
			    x_head_pos=x_pos+ant_size/2*cos(angle);
			    y_head_pos=y_pos+ant_size/2*sin(angle);
			    
			    if ((x_head_pos<0)||(y_head_pos<0)||(x_head_pos>surface->w)||(y_head_pos>surface->h))
				{
					vx=0;
	        		vy=0;
	        		
	        		
	        		angle_init=rand();
	        		
				}			  
				
			    if((x_head_pos>0)&&(y_head_pos>0)&&(x_head_pos<surface->w)&&(y_head_pos<surface->h))
			    {
				     vx=0.5*(x_head_pos-x_pos);
	        		 vy=0.5*(y_head_pos-y_pos);
                     couleur_pixel=getpixel(surface_back,int(x_head_pos),int(y_head_pos));
                     SDL_GetRGB(couleur_pixel, surface->format, &pixel_rouge, &pixel_vert, &pixel_bleu);
			        //SDL_UnlockSurface(surface_back);
			        if (pixel_rouge==255)
	                {
	                     vx=0;
	        	         vy=0;
	        	         disk(x_head_pos,y_head_pos,ant_size/2,SDL_MapRGB(surface->format,120,0,0),surface_back);
	        	         
						 ant_couleur=SDL_MapRGB(surface->format, 128, 0, 0);
	        			 disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
						 	
	                	 
			        }  
			        
			        	
    				else if ((pixel_rouge<255)&&(pixel_rouge>0))
                   	{
                  		vx=0;
       					vy=0;
	        	         	        	         
					 	ant_couleur=SDL_MapRGB(surface->format, 128, 128, 128);
  			 			disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
						 	
 	 									
					}
 				    			
			    } 
		    }
           
           
           grey_essai_detection=0;pheromone=0;
           while ((grey_essai_detection<6)&&(ant_couleur==SDL_MapRGB(surface->format,128, 128, 128)))
		   {
		   		i=-i;
		        grey_essai_detection=grey_essai_detection+1;
                
		        x_head_pos=x_pos+ant_size/2*cos(angle+i*0.1*grey_essai_detection);
			    y_head_pos=y_pos+ant_size/2*sin(angle+i*0.1*grey_essai_detection);
				if ((x_head_pos<0)||(y_head_pos<0)||(x_head_pos>surface->w)||(y_head_pos>surface->h))
				{
					vx=0;
	        		vy=0;
	        		angle=-angle;
	        		
				}
				if((x_head_pos>0)&&(y_head_pos>0)&&(x_head_pos<surface->w)&&(y_head_pos<surface->h))
			    {
			    	couleur_pixel=getpixel(surface_back,int(x_head_pos),int(y_head_pos));
                	SDL_GetRGB(couleur_pixel, surface->format, &pixel_rouge, &pixel_vert, &pixel_bleu);
                	if (pixel_rouge==255)
	                {
	                     vx=0;
	        	         vy=0;
	        	         disk(x_head_pos,y_head_pos,ant_size/2,SDL_MapRGB(surface->format,120,0,0),surface_back);
	        	         
						 ant_couleur=SDL_MapRGB(surface->format, 128, 0, 0);
	        			 disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
						 	
	                	 
			        }  
                 	else if ((pixel_rouge<255)&&(pixel_rouge>0)&&(pixel_rouge>=pheromone))
                 	{
                        vx=0.5*(x_head_pos-x_pos);
	        		    vy=0.5*(y_head_pos-y_pos);
					    pheromone=pixel_rouge;
	        		    angle=angle+i*0.1*grey_essai_detection;
	        		   
			 	   }
				   
			    }
				
		   }
		   
		   if ((pheromone<=9)&&(ant_couleur==SDL_MapRGB(surface->format,128, 128, 128)))
		   {
		   	  ant_couleur=SDL_MapRGB(surface->format, 0, 0, 0);
	        disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
	        pheromone=0;
		   }
		    // on avance
		    if((ant_couleur==SDL_MapRGB(surface->format, 0, 0, 0))||(ant_couleur==SDL_MapRGB(surface->format, 128, 128, 128)))
		    {
		    	x_pos=x_pos+vx;y_pos=y_pos+vy;
	        	x_head_pos=x_head_pos+vx;y_head_pos=y_head_pos+vy;
	        	position.x=x_pos;position.y=y_pos;
	        	position_stack.push(position);
	        	if ((position_stack.size()>(surface->w)*2))
	        	{
	        	   ant_couleur=SDL_MapRGB(surface->format, 255, 255, 0);
	        	   disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
				}
			}
	        if((!position_stack.empty())&&((ant_couleur==SDL_MapRGB(surface->format, 128, 0, 0))||(ant_couleur==SDL_MapRGB(surface->format, 255,255, 0))))
		    {
		    	position =position_stack.top();
	        	
	        	x_pos=position.x;y_pos=position.y;
	        	position_stack.pop();
	        	
			}
			if ((position_stack.size()>100)&&(pow(x_pos-x_ant_hill,2)+pow(y_pos-y_ant_hill,2)<pow(ant_size*2+ant_hill_size*2,2))&&((ant_couleur==SDL_MapRGB(surface->format, 128, 0, 0))||(ant_couleur==SDL_MapRGB(surface->format, 255,255, 0))))
			{
				
				while (!position_stack.empty())
				{
					position_stack.pop();  
				}
				for (int i=0;i<(ant_size*2+ant_hill_size*2)/ant_size*4 ;i++  )
				{
					position.x=x_ant_hill+int(i*ant_size/4*(x_pos-x_ant_hill)/(ant_size*2+ant_hill_size*2));
					position.y=y_ant_hill+int(i*ant_size/4*(y_pos-y_ant_hill)/(ant_size*2+ant_hill_size*2));
					position_stack.push(position);
				}
			
			}
			
			if((position_stack.empty())&&((ant_couleur==SDL_MapRGB(surface->format, 128, 0, 0))||(ant_couleur==SDL_MapRGB(surface->format, 255,255, 0))))
		    {
		    	   	
	        	
	        	ant_couleur=SDL_MapRGB(surface->format, 128, 128, 128);
				disk((ant_size+1)/2,  (ant_size+1)/2, ant_size/2, ant_couleur,ant_surface);
			}
	       
			
	        ant_surface_rect.x=x_pos-(ant_size+1)/2; ant_surface_rect.y=y_pos-(ant_size+1)/2; 
	        SDL_SetAlpha( ant_surface, SDL_SRCALPHA | SDL_RLEACCEL, 255);
	        SDL_BlitSurface(ant_surface, NULL, surface, &ant_surface_rect);
            SDL_UpdateRect(surface, ant_surface_rect.x, ant_surface_rect.y, ant_surface_rect.w, ant_surface_rect.h );
            
	      //SDL_Flip(surface);
	        
       		std::this_thread::sleep_for(std::chrono::milliseconds(2));
       		
           lock.unlock();
	         
	   }
	}
	



	erase(SDL_Surface *surface,SDL_Surface *surface_back)
	{
	  SDL_Surface* erase_surface;
	  SDL_Rect erase_surface_rect;erase_surface_rect.w=2;erase_surface_rect.h=2;
	  int x_pos=2; int scan=1;	
	  erase_surface = SDL_CreateRGBSurface(SDL_HWSURFACE, 2, 2, 32, 0, 0, 0, 0);
      
	  SDL_FillRect(erase_surface, NULL, SDL_MapRGB(surface->format, 0, 255, 0));
	  SDL_SetAlpha( erase_surface, SDL_SRCALPHA | SDL_RLEACCEL, 60);
	  Uint32 couleur_pixel;	Uint8 pixel_vert;Uint8 pixel_rouge;Uint8 pixel_bleu;
	  double x_ant_hill=(surface_back->w)/5;
	  double y_ant_hill=(surface_back->h)*0.8;
      
	  while(1<2)
         {
		  		
		       for( int y_pos=1; y_pos<(surface->h)-1;y_pos=y_pos+ 2)
               {
               	 lock.lock();
               	   for( int x_pos=1;x_pos<(surface->w)-1;x_pos=x_pos+2)
               	   {
					  
					  couleur_pixel=getpixel(surface_back,int(x_pos),int(y_pos));
               	   	  SDL_GetRGB(couleur_pixel, surface->format, &pixel_rouge, &pixel_vert, &pixel_bleu);
               	   	  if((couleur_pixel!=SDL_MapRGB(surface->format, 255, 0, 0)))
               	   	  
               	   	  {
  					  
               	   			erase_surface_rect.x=x_pos; erase_surface_rect.y=y_pos;
                			SDL_BlitSurface(erase_surface, NULL, surface_back, &erase_surface_rect);
	            			SDL_BlitSurface(surface_back, &erase_surface_rect, surface, &erase_surface_rect);
	            			 //SDL_Flip(surface);
	            			//SDL_UpdateRect(surface, erase_surface_rect.x, erase_surface_rect.y, erase_surface_rect.w, erase_surface_rect.h );
	   			       }
	   			       
	   			        
	   			        
               	   }
               	 
	        	 lock.unlock();     
          	    
                }  
            lock.lock();    
			disk(x_ant_hill,y_ant_hill,ant_hill_size,SDL_MapRGB(surface->format,0,0,0),surface_back);
			SDL_Flip(surface);
			lock.unlock();
           std::this_thread::sleep_for(std::chrono::milliseconds(1));
           
            
             
           
		}
    }
   		    



int main(int argc, char *argv[])

{

    SDL_Surface *ecran,*ecran1 = NULL;
    

    SDL_Init(SDL_INIT_VIDEO);
    if (SDL_Init(SDL_INIT_VIDEO) < 0) {
    fprintf(stderr, "Erreur  l'initialisation de la SDL : %s\n", SDL_GetError());
    exit(EXIT_FAILURE);
  					   }
    putenv("SDL_VIDEO_WINDOW_POS=0,20"); //pour placer en x,y (ici 0,0)
    ecran1 = SDL_SetVideoMode(0,0, 32, SDL_HWSURFACE|SDL_FULLSCREEN/*|SDL_DOUBLEBUF*/);
    
	ecran = SDL_SetVideoMode(0,ecran1->h-20, 32, SDL_HWSURFACE/*|SDL_FULLSCREEN/*|SDL_DOUBLEBUF*/);
	SDL_FreeSurface(ecran1);
    
	SDL_WM_GrabInput(SDL_GRAB_ON);
    if (ecran == NULL) 
	{
       		  fprintf(stderr, "Impossible d'activer le mode graphique : %s\n", SDL_GetError());
    		  exit(EXIT_FAILURE);
     }

    SDL_WM_SetCaption("Ants->food 1.0   2017/06/01    	PRESS ANY KEY TO EXIT           author: Christian Breant 		              	christian.breant@gmail.com   		           ", NULL);
  

    // Coloration de la surface ecran en vert
    
    
	SDL_Surface* background = SDL_CreateRGBSurface(SDL_HWSURFACE, ecran->w, ecran->h, 32, 0, 0, 0, 0);
	SDL_FillRect(background, NULL, SDL_MapRGB(ecran->format, 0, 255, 0));
	
	
    
	
	//cration d'un disque nourriture
	
	disk((background->w)/10*8,(background->h)/5,food_hill_size,SDL_MapRGB(ecran->format, 255, 0, 0),background);
	//cration d'un disque fourmilire
	disk((background->w)/5,(background->h)*8/10,ant_hill_size,SDL_MapRGB(ecran->format, 0, 0, 0),background);
	
	SDL_BlitSurface(background, NULL, ecran,NULL);
    SDL_Flip(ecran); 
    
    
    std::thread ant_thread1(search_food,(ecran->w)/5,(ecran->h)*8/10,1,ecran,background);
    ant_thread1.detach();
    std::thread ant_thread2(search_food,(ecran->w)/5,(ecran->h)*8/10,2,ecran,background);
    ant_thread2.detach();
    std::thread ant_thread3(search_food,(ecran->w)/5,(ecran->h)*8/10,3,ecran,background);
    ant_thread3.detach();
    std::thread ant_thread4(search_food,(ecran->w)/5,(ecran->h)*8/10,4,ecran,background);
    ant_thread4.detach();
    std::thread ant_thread5(search_food,(ecran->w)/5,(ecran->h)*8/10,5,ecran,background);
    ant_thread5.detach();
    std::thread ant_thread6(search_food,(ecran->w)/5,(ecran->h)*8/10,6,ecran,background);
    ant_thread6.detach();
    std::thread ant_thread7(search_food,(ecran->w)/5,(ecran->h)*8/10,7,ecran,background);
    ant_thread7.detach();
    std::thread ant_thread8(search_food,(ecran->w)/5,(ecran->h)*8/10,8,ecran,background);
    ant_thread8.detach();
    std::thread ant_thread9(search_food,(ecran->w)/5,(ecran->h)*8/10,9,ecran,background);
    ant_thread9.detach();
    std::thread ant_thread10(search_food,(ecran->w)/5,(ecran->h)*8/10,10,ecran,background);
    ant_thread10.detach();
    std::thread ant_thread11(search_food,(ecran->w)/5,(ecran->h)*8/10,11,ecran,background);
    ant_thread11.detach();
    std::thread ant_thread12(search_food,(ecran->w)/5,(ecran->h)*8/10,12,ecran,background);
    ant_thread12.detach();
    std::thread ant_thread13(search_food,(ecran->w)/5,(ecran->h)*8/10,13,ecran,background);
    ant_thread13.detach();
    std::thread ant_thread14(search_food,(ecran->w)/5,(ecran->h)*8/10,14,ecran,background);
    ant_thread14.detach();
    std::thread ant_thread15(search_food,(ecran->w)/5,(ecran->h)*8/10,15,ecran,background);
    ant_thread15.detach();
    std::thread ant_thread16(search_food,(ecran->w)/5,(ecran->h)*8/10,16,ecran,background);
    ant_thread16.detach();
    std::thread ant_thread17(search_food,(ecran->w)/5,(ecran->h)*8/10,17,ecran,background);
    ant_thread17.detach();
    std::thread ant_thread18(search_food,(ecran->w)/5,(ecran->h)*8/10,18,ecran,background);
    ant_thread18.detach();
    std::thread ant_thread19(search_food,(ecran->w)/5,(ecran->h)*8/10,19,ecran,background);
    ant_thread19.detach();
    std::thread ant_thread20(search_food,(ecran->w)/5,(ecran->h)*8/10,20,ecran,background);
    ant_thread20.detach();
    
    
    std::thread erase_tread(erase,ecran,background);
    erase_tread.detach();
    
	

    

    SDL_Event event;
 	while (event.type != SDL_QUIT && event.type != SDL_KEYDOWN)
  	{
     	  SDL_WaitEvent(&event);
     	  switch(event.type) /* Test du type d'vnement */
		  {

		       case SDL_MOUSEBUTTONDOWN:
	       	   switch(event.button.button)
	       	   {
  				   case SDL_BUTTON_RIGHT:
  				   //L_Flip(ecran);
     	   	       break;
					 
				   case SDL_BUTTON_LEFT:
			   	   
			   	   
                   
               	   break;
               	   
           	    }

            	break;

   			 }
	}

	SDL_FreeSurface(background); 
	SDL_FreeSurface(ecran); 
	//SDL_FreeSurface(ant_surface);
	//SDL_FreeSurface(erase_surface);
    SDL_Quit();


    return EXIT_SUCCESS;

}
