# -*- coding: utf-8 -*-

import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
import fonction_in_curve as tamb
import scipy.spatial
import scipy.sparse.linalg as splin

L = 1
H = 1

dl = 0.05
sol = tamb.in_curve(tamb.rect,[L,H],(100,100),dl)
sol_tri,Nint,Nbord = tamb.triang(sol,dl,tamb.rect,[L,H],tamb.rect_bord(L,H,dl))

# plt.plot(sol_tri[:,0],sol_tri[:,1],linestyle="",marker="+",label="tri")
# plt.plot(sol[:,0],sol[:,1],linestyle="",marker="x")
# plt.legend()
# plt.show()

# triangulation
tri = scipy.spatial.Delaunay(sol_tri)
# plt.triplot(sol_tri[:,0],sol_tri[:,1],tri.simplices)
# plt.show()

M = tamb.M(sol_tri,tri,Nint,dl)

valp,vecp = np.linalg.eig(M)
valp = np.real(valp)
vecp = np.real(vecp)

# comparaison avec la solution exacte :
eps = 1e-10
T = 1000
U = np.arange(0,T,1)
valp = -np.sort(-valp[valp < -eps]) # on retire les valeurs propres (quasi-) nulles
NUsim = np.array([len(tamb.count_vp(valp,u)) for u in U]) # la simulation
NU = np.array([len(tamb.rect_tambour(L,H,u)) for u in U]) # exactes
plt.plot(U,NUsim,label='simulation')
plt.plot(U,NU,label='exactes')
plt.legend()
plt.show()


# plot 3D d'un vecteur propre
fig = plt.figure()
ax = fig.gca(projection='3d')
ax.plot_trisurf(sol_tri[:,0],sol_tri[:,1],vecp[:,0],triangles=tri.simplices)
plt.show()