
<?php

class imageManager {

    private $db;
 
    public function __construct($db) {

        $this->setDb($db);
    }

    public function setDb(PDO $dbh) {

        return $this->db = $dbh;
    }

    public function createImageData(Image $image) {

        try {

            $sql = 'INSERT INTO images(title, descr, filename) VALUES(:title, :descr, :filename)';

            $stmnt = $this->db->prepare($sql);

            $title = htmlspecialchars($image->getTitle());
            $descr = htmlspecialchars($image->getDescr());
            $filename = htmlspecialchars($image->getFilename());

            $stmnt->bindParam(':title', $title);
            $stmnt->bindParam(':descr', $descr);
            $stmnt->bindParam(':filename', $filename);

            $stmnt->execute();
        }
        catch(PDOException $e) {

            echo 'Une erreur est survenue lors de l\'insertion des données dans la base. ' . $e->getMessage();
        }
    }

    /* Méthode retournant les fichiers présents dans le repertoire
       où nous avons placé nos images et que nous définissons
       au moyen de la variable $image_dir
    */

    /*public function readImages($image_dir) {

        // Iterator
 
        $i = 0;

        // Nous ouvrons le dossier $image_dir avec opendir
        // et affectons le résultat à la variable $handle

        if($handle = opendir($image_dir)) {

            while(false !== ($entry = readdir($handle))) {

                // La variable $entry ne pourra pas se voir affecté les . et les .. 

                if($entry != "." && $entry != "..") {

                    $i++;

                    $images[$i]['filename'] = $entry;
  
                    // Utilisation de $this pour appeler la méthode readImageData
  
                    $image_data = $this->readImageData($entry);

                    $images[$i]['title'] = $image_data['title'];
                    $images[$i]['descr'] = $image_data['descr'];
                }
            }
        }

        closedir($handle); // Nous fermons le repertoire avec closedir

        return $images; // Nous retournons le tableau de données
    }*/

    public function readImagesData() {

        try {

            $sql = 'SELECT id, title, descr, filename FROM images';

            $stmnt = $this->db->prepare($sql);

            $stmnt->execute();

            while($row = $stmnt->fetch(PDO::FETCH_ASSOC)) {

                $path = IMAGE_DIR_PATH . $row['filename'];
                
                if(file_exists($path)) {

                    $images_data[$row['id']]['id'] = $row['id'];
                    $images_data[$row['id']]['title'] = $row['title'];
                    $images_data[$row['id']]['descr'] = $row['descr'];
                    $images_data[$row['id']]['filename'] = $row['filename'];
                    $images_data[$row['id']]['exist'] = 'OK';
                }
            }
                echo '<pre>';
                print_r($images_data);
                echo '</pre>';

                return $images_data;
        }
        catch(PDOException $e) {

            echo 'Une erreur est survenue lors de la récupération des données dans la base. ' . $e->getMessage();
        }
    }

    public function readImageData($filename) {
        
        try {
            
            $sql = 'SELECT id, title, descr, filename FROM images WHERE filename = :filename';

            $stmnt = $this->db->prepare($sql);

            $stmnt->execute(array(

                ":filename" => $filename
            ));

            $count = $stmnt->rowCount();

            if($count > 0) {

                return $stmnt->fetch();
            }
            else {

                return false;
            }
        }
        catch(PDOException $e) {

            echo 'Une erreur est survenue lors de la récupération d\'une des données dans la base. Message d\'erreur : ' . $e->getMessage();
        }
    }

    public function updateImageData(Image $image) {

        try {

            $sql = 'UPDATE images SET title = :title, descr = :descr WHERE filename = :filename';

            $stmnt = $this->db->prepare($sql);

            $title = htmlspecialchars($image->getTitle());
            $descr = htmlspecialchars($image->getDescr());
            $filename = htmlspecialchars($image->getFilename());

            $stmnt->bindParam(':title', $title);
            $stmnt->bindParam(':descr', $descr);
            $stmnt->bindParam(':filename', $filename);

            $stmnt->execute();
        }
        catch(PDOException $e) {

            echo 'Une erreur est survenue lors de la mise à jour des données dans la base. ' . $e->getMessage();
        }
    }

    public function deleteImageData($filename) {

        try {

            $sql = 'DELETE FROM images WHERE filename = :filename';

            $stmnt = $this->db->prepare($sql);

            $stmnt->bindParam(':filename', $filename);

            $stmnt->execute();

            $count = $stmnt->rowCount();
 
            return $count;
        }
        catch(PDOException $e) {

            echo 'Une erreur est survenue lors de la suppression des données dans la base. ' . $e->getMessage();
        }
    }

    public function upload($files) {

        $upload_dir = IMAGE_DIR_PATH;
 
        foreach($files['upload_form']['error'] as $key => $error) {

            $error = 0;

            if($error == UPLOAD_ERR_OK) {

                $type = $files['upload_form']['type'][$key];
                $size = $files['upload_form']['size'][$key];
                $tmp_name = $files['upload_form']['tmp_name'][$key];
                $name = $files['upload_form']['name'][$key];
                $filename = $this->cleanText($name);

                // Seules les fichiers jpg qui ont une taille inférieurs ou égal à 70 000 000 Octets sont autorisés.

                if(($type == 'image/jpeg') AND ($size <= 70000000)) {
 
                    if(move_uploaded_file($tmp_name, $upload_dir . $filename) === false) {

                        $error++;
                    }
                    else {

                        // Appel avec $this de la méthode au sein d'une même classe

                        $this->createThumbnail($filename);
                    }
                }
                else {

                    echo '<p class="msg_error">Seules les fichiers jpg qui ont une taille inférieurs ou égal à 70 000 000 Octets sont autorisés.</p>';

                    $error++;
                }
            }
            else {

                $error++;
            }
        }
        
        if($error == 0) {

            return true;
        }
        else {

            return false;
        }
    }

    public function createThumbnail($filename) {

        // Définition des chemins des images et des vignettes.

        $image = IMAGE_DIR_PATH . $filename;
        $vignette = THUMB_DIR_PATH . $filename;

        // Récupération des dimensions de l'image source.

        $size = getimagesize($image);
        $largeur = $size[0];
        $hauteur = $size[1];

        // Définition des valeurs souhaitées pour les vignettes.
        // Ce sont des valeurs maximales.

        $largeur_max = 200;
        $hauteur_max = 200;

        // Création de l'image source avec imagecreatefromjpeg.

        $image_src = imagecreatefromjpeg($image);

        // On crée un ratio (une proportion).
        // et on verifie que l'image source ne soit pas
        // plus petite que l'image de destination.

        if($largeur > $largeur_max OR $hauteur > $hauteur_max) {

            // Si largeur plus grande que hauteur.
 
            if($hauteur <= $largeur) {

                $ratio = $largeur_max / $largeur;
            }
            else {

                $ratio = $hauteur_max / $hauteur;
            }
        }
        else {

            // l'image créee sera identique à l'originale.

            $ratio = 1;
        }

        // Création de l'image noire de destination avec imagecreatetruecolor.

        $image_destination = imagecreatetruecolor(round($largeur * $ratio), round($hauteur * $ratio));

        // Fabrication de la vignette avec dimensions souhaitées.

        imagecopyresampled($image_destination, $image_src, 0, 0, 0, 0, round($largeur * $ratio), round($hauteur * $ratio), $largeur, $hauteur);

        // Envoi de la nouvelle image JPEG dans le fichier.

        if(!imagejpeg($image_destination, $vignette)) {
 
            $error_msg = 'la création de la vignette a echouée pour l\'image ' . $image;
            
            return $error_msg;
 
            exit;
        }
        else {

            return true;
        }
    }

    public function cleanText($filename) {

        $special = array(' ', '\'', 'á','à','â','ä','ã','å','ç','é','è','ê',
                         'ë','í','ì','î','ï','ñ','ó','ò','ô','ö','õ','ú','ù',
                         'û','ü','ý','ÿ','Á','À','Â','Ä','Ã','Å','Ç','É','È',
                         'Ê','Ë','Í','Ï','Î','Ì','Ñ','Ó','Ò','Ô','Ö','Õ','Ú',
                         'Ù','Û','Ü','Ý');
 
        $normal = array('-', '', 'a','a','a','a','a','a','c','e','e','e','e',
                        'i','i','i','i','n','o','o','o','o','o','u','u','u',
                        'u','y','y','A','A','A','A','A','A','C','E','E','E',
                        'E','E','I','I','I','I','N','O','O','O','O','O','U',
                        'U','U','U','Y');
 
        $result = str_replace($special, $normal, $filename);

        $results = strtolower($result);

        return $results;
    }
}